/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.ConsolePlugin;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

public class CompileRunOptionPane
extends AbstractOptionPane
implements ActionListener {
    private static final long serialVersionUID = -1672963909425664168L;
    public static final String NONE = "none";
    private JComboBox modeBox;
    private JRadioButton compilerCommando;
    private JComboBox compilerCommandList;
    private JTextField compilerCustomText;
    private JRadioButton compilerCustom;
    private JRadioButton interpreterCommando;
    private JComboBox interpreterCommandList;
    private JTextField interpreterCustomText;
    private JRadioButton interpreterCustom;

    public CompileRunOptionPane() {
        super("console.compile-run");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.modeBox) {
            this.update(((Mode)this.modeBox.getSelectedItem()).getName());
        } else if (source == this.compilerCommando) {
            this.compilerCommandList.setEnabled(true);
            this.compilerCustomText.setEnabled(false);
        } else if (source == this.compilerCustom) {
            this.compilerCommandList.setEnabled(false);
            this.compilerCustomText.setEnabled(true);
        } else if (source == this.interpreterCommando) {
            this.interpreterCommandList.setEnabled(true);
            this.interpreterCustomText.setEnabled(false);
        } else if (source == this.interpreterCustom) {
            this.interpreterCommandList.setEnabled(false);
            this.interpreterCustomText.setEnabled(true);
        }
    }

    protected void _init() {
        EditAction[] commandos = ConsolePlugin.getCommandoCommands();
        String[] labels = new String[commandos.length + 1];
        for (int i = 0; i < commandos.length; ++i) {
            labels[i + 1] = commandos[i].getLabel();
        }
        labels[0] = NONE;
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        modePanel.add(new JLabel("Set compiler/interpreter for edit mode:"));
        this.modeBox = new JComboBox<Mode>(jEdit.getModes());
        this.modeBox.setSelectedItem(jEdit.getActiveView().getBuffer().getMode());
        modePanel.add(this.modeBox);
        this.addComponent(modePanel);
        JPanel compilerPanel = new JPanel();
        compilerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Compiler"));
        compilerPanel.setLayout(new BoxLayout(compilerPanel, 1));
        JPanel compilerCommandoPanel = new JPanel();
        compilerCommandoPanel.setLayout(new BoxLayout(compilerCommandoPanel, 0));
        this.compilerCommando = new JRadioButton("Use command");
        compilerCommandoPanel.add(this.compilerCommando);
        compilerCommandoPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.compilerCommandList = new JComboBox<String>(labels);
        compilerCommandoPanel.add(this.compilerCommandList);
        JPanel compilerCustomPanel = new JPanel();
        compilerCustomPanel.setLayout(new BoxLayout(compilerCustomPanel, 0));
        this.compilerCustom = new JRadioButton("Use custom command");
        compilerCustomPanel.add(this.compilerCustom);
        this.compilerCustomText = new JTextField(30);
        compilerCustomPanel.add(this.compilerCustomText);
        compilerPanel.add(compilerCommandoPanel);
        compilerPanel.add(compilerCustomPanel);
        JPanel interpreterPanel = new JPanel();
        interpreterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Interpreter"));
        interpreterPanel.setLayout(new BoxLayout(interpreterPanel, 1));
        JPanel interpreterCommandoPanel = new JPanel();
        interpreterCommandoPanel.setLayout(new BoxLayout(interpreterCommandoPanel, 0));
        this.interpreterCommando = new JRadioButton("Use command");
        interpreterCommandoPanel.add(this.interpreterCommando);
        interpreterCommandoPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.interpreterCommandList = new JComboBox<String>(labels);
        interpreterCommandoPanel.add(this.interpreterCommandList);
        JPanel interpreterCustomPanel = new JPanel();
        interpreterCustomPanel.setLayout(new BoxLayout(interpreterCustomPanel, 0));
        this.interpreterCustom = new JRadioButton("Use custom command");
        interpreterCustomPanel.add(this.interpreterCustom);
        this.interpreterCustomText = new JTextField(30);
        interpreterCustomPanel.add(this.interpreterCustomText);
        interpreterPanel.add(interpreterCommandoPanel);
        interpreterPanel.add(interpreterCustomPanel);
        JLabel help2 = new JLabel();
        help2.setText(jEdit.getProperty((String)"options.console.compile-run.help"));
        this.addComponent(compilerPanel);
        this.addComponent(interpreterPanel);
        this.addComponent(Box.createRigidArea(new Dimension(0, 20)));
        this.addComponent(help2);
        ButtonGroup compilerGroup = new ButtonGroup();
        ButtonGroup interpreterGroup = new ButtonGroup();
        compilerGroup.add(this.compilerCommando);
        compilerGroup.add(this.compilerCustom);
        interpreterGroup.add(this.interpreterCommando);
        interpreterGroup.add(this.interpreterCustom);
        this.modeBox.addActionListener(this);
        this.compilerCommando.addActionListener(this);
        this.compilerCustom.addActionListener(this);
        this.interpreterCommando.addActionListener(this);
        this.interpreterCustom.addActionListener(this);
        this.update(null);
    }

    protected void update(String mode) {
        String currentCompileCommand;
        if (mode == null) {
            mode = jEdit.getActiveView().getBuffer().getMode().getName();
        }
        if ((currentCompileCommand = jEdit.getProperty((String)("mode." + mode + ".commando.compile"))) != null) {
            this.compilerCommandList.setSelectedItem(currentCompileCommand);
        } else {
            this.compilerCommandList.setSelectedIndex(0);
        }
        String currentInterpretCommand = jEdit.getProperty((String)("mode." + mode + ".commando.run"));
        if (currentInterpretCommand != null) {
            this.interpreterCommandList.setSelectedItem(currentInterpretCommand);
        } else {
            this.interpreterCommandList.setSelectedIndex(0);
        }
        this.compilerCustomText.setText(jEdit.getProperty((String)("mode." + mode + ".compile.custom"), (String)""));
        this.interpreterCustomText.setText(jEdit.getProperty((String)("mode." + mode + ".run.custom"), (String)""));
        if (!jEdit.getBooleanProperty((String)("mode." + mode + ".compile.use-custom"))) {
            this.compilerCommando.setSelected(true);
            this.compilerCommandList.setEnabled(true);
            this.compilerCustomText.setEnabled(false);
        } else {
            this.compilerCustom.setSelected(true);
            this.compilerCommandList.setEnabled(false);
            this.compilerCustomText.setEnabled(true);
        }
        if (!jEdit.getBooleanProperty((String)("mode." + mode + ".run.use-custom"))) {
            this.interpreterCommando.setSelected(true);
            this.interpreterCommandList.setEnabled(true);
            this.interpreterCustomText.setEnabled(false);
        } else {
            this.interpreterCustom.setSelected(true);
            this.interpreterCommandList.setEnabled(false);
            this.interpreterCustomText.setEnabled(true);
        }
    }

    protected void _save() {
        String mode = this.modeBox.getSelectedItem().toString();
        jEdit.setBooleanProperty((String)("mode." + mode + ".compile.use-custom"), (boolean)this.compilerCustom.isSelected());
        jEdit.setBooleanProperty((String)("mode." + mode + ".run.use-custom"), (boolean)this.interpreterCustom.isSelected());
        if (this.compilerCommandList.getSelectedIndex() == 0) {
            jEdit.unsetProperty((String)("mode." + mode + ".commando.compile"));
        } else {
            jEdit.setProperty((String)("mode." + mode + ".commando.compile"), (String)((String)this.compilerCommandList.getSelectedItem()));
        }
        if (this.interpreterCommandList.getSelectedIndex() == 0) {
            jEdit.unsetProperty((String)("mode." + mode + ".commando.run"));
        } else {
            jEdit.setProperty((String)("mode." + mode + ".commando.run"), (String)((String)this.interpreterCommandList.getSelectedItem()));
        }
        jEdit.setProperty((String)("mode." + mode + ".compile.custom"), (String)this.compilerCustomText.getText());
        jEdit.setProperty((String)("mode." + mode + ".run.custom"), (String)this.interpreterCustomText.getText());
    }
}

