/*
 * Decompiled with CFR 0.152.
 */
package common.gui.blame;

import common.gui.blame.BlameModel;
import common.gui.blame.BlamePane;
import common.gui.blame.BlamePaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class BasicBlamePaneUI
extends BlamePaneUI
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private BlamePane blamePane;
    private BlameRendererPane blameRendererPane;
    private int pixelsPerLine = 12;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBlamePaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.blamePane = (BlamePane)c;
        this.blamePane.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    public void installDefaults() {
    }

    public void installComponents() {
        this.blameRendererPane = new BlameRendererPane();
        this.blamePane.add((Component)this.blameRendererPane, "Center");
    }

    public void installListeners() {
        this.blamePane.addChangeListener(this);
        this.blamePane.addMouseListener(this);
        this.blamePane.addMouseMotionListener(this);
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.blamePane.remove(this.blameRendererPane);
    }

    public void uninstallListeners() {
        this.blamePane.removeChangeListener(this);
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.blameRendererPane.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        BlameModel model = this.blamePane.getModel();
        if (model == null) {
            return;
        }
        int screenLine = e.getY() / this.pixelsPerLine;
        JEditTextArea textArea = model.getTextArea();
        textArea.setCaretPosition(textArea.getScreenLineStartOffset(screenLine), false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        BlameModel model = this.blamePane.getModel();
        if (model == null) {
            return;
        }
        int screenLine = e.getY() / this.pixelsPerLine;
        int index = model.getTextArea().getPhysicalLineOfScreenLine(screenLine);
        String tooltip = model.getToolTipText(index);
        if (tooltip != null) {
            this.blamePane.setToolTipText(tooltip);
        }
    }

    public class BlameRendererPane
    extends JPanel {
        public BlameRendererPane() {
            BlameModel model = BasicBlamePaneUI.this.blamePane.getModel();
            if (model == null) {
                throw new IllegalArgumentException("blame model is null");
            }
            if (model.getBlame() == null) {
                throw new IllegalArgumentException("no blame found in model");
            }
            int max_width = 0;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            Graphics g = model.getTextArea().getPainter().getGraphics();
            for (String line : model.getBlame()) {
                int width = (int)fm.getStringBounds(line, g).getWidth();
                max_width = width > max_width ? width : max_width;
            }
            Dimension dim = this.getPreferredSize();
            dim.width = max_width + 3;
            this.setPreferredSize(dim);
        }

        @Override
        public void paintComponent(Graphics gfx) {
            super.paintComponent(gfx);
            BlameModel model = BasicBlamePaneUI.this.blamePane.getModel();
            Rectangle size = this.getBounds();
            gfx.setColor(this.getBackground());
            gfx.fillRect(0, 0, size.width, size.height);
            gfx.setFont(this.getFont());
            if (!"none".equals(jEdit.getProperty((String)"view.antiAlias"))) {
                ((Graphics2D)gfx).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            JEditTextArea textArea = model.getTextArea();
            BasicBlamePaneUI.this.pixelsPerLine = textArea.getPainter().getLineHeight();
            int caretLine = textArea.getCaretLine();
            Color foreground = jEdit.getColorProperty((String)"view.fgColor", (Color)Color.BLACK);
            Color highlight = jEdit.getColorProperty((String)"view.lineHighlightColor", (Color)Color.WHITE);
            gfx.setColor(foreground);
            List<String> blame = model.getBlame();
            int descent = gfx.getFontMetrics().getDescent();
            for (int screenLine = 0; screenLine <= textArea.getLastScreenLine(); ++screenLine) {
                int physicalLine = textArea.getPhysicalLineOfScreenLine(screenLine);
                if (screenLine == caretLine) {
                    gfx.setColor(highlight);
                    gfx.fillRect(0, screenLine * BasicBlamePaneUI.this.pixelsPerLine, size.width, BasicBlamePaneUI.this.pixelsPerLine);
                    gfx.setColor(foreground);
                }
                if (physicalLine < 0 || physicalLine >= blame.size()) continue;
                gfx.drawString(blame.get(physicalLine), 3, (screenLine + 1) * BasicBlamePaneUI.this.pixelsPerLine - descent);
            }
        }
    }
}

