/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.gui.util.ConstraintFactory;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListPanel
extends JPanel {
    private JLabel label;
    private JList list;
    private JScrollPane scrollpane;
    private boolean reorderable = true;
    private boolean sorted = false;

    public ListPanel(String title) {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel(title);
        this.list = new JList(new DefaultListModel());
        this.list.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scrollpane = new JScrollPane(this.list);
        ConstraintFactory cf = new ConstraintFactory();
        this.add((Component)this.label, cf.buildConstraints(0, 0, 10, 1, 17, 2, 100, 0));
        this.add((Component)this.scrollpane, cf.buildConstraints(0, 1, 10, 10, 11, 1));
        if (this.reorderable) {
            // empty if block
        }
    }

    public ListPanel(String title, Object[] items) {
        this(title);
        for (int i = 0; i < items.length; ++i) {
            this.addElement(items[i]);
        }
    }

    public void clear() {
        ((DefaultListModel)this.list.getModel()).clear();
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        super.addKeyListener(kl);
        this.list.addKeyListener(kl);
    }

    public void addElement(Object element) {
        ((DefaultListModel)this.list.getModel()).addElement(element);
    }

    public boolean removeElement(Object element) {
        return ((DefaultListModel)this.list.getModel()).removeElement(element);
    }

    public void setLabel(String label) {
        this.label.setText(label);
    }

    public void setSorted(boolean b) {
        this.sorted = b;
        if (this.sorted) {
            this.reorderable = false;
        }
    }

    public void setReorderable(boolean b) {
        this.reorderable = b;
    }

    public void setSelectedIndex(int i) {
        this.list.setSelectedIndex(i);
    }

    public int getLastSelectedIndex() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            return selected[selected.length - 1];
        }
        return -1;
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public Object[] toArray() {
        return ((DefaultListModel)this.list.getModel()).toArray();
    }
}

