/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class TextToolsSorting {
    public static void sortLines(JEditTextArea textArea, boolean reverse) {
        if (!TextToolsPlugin.isTextAreaEditable(null, textArea)) {
            return;
        }
        int[] selRows = TextToolsSorting.getRectSelectionRows(textArea);
        if (selRows != null) {
            JSort jsort = new JSort(false);
            jsort.addSortConstraint(selRows[0] + 1, selRows[1] + 1, !reverse);
            TextToolsSorting.sortAndInsertData(textArea, jsort, false);
        } else {
            JEditBuffer b = textArea.getBuffer();
            b.beginCompoundEdit();
            int[] lines = textArea.getSelectedLines();
            if (lines.length > 1) {
                TextToolsSorting.sortLines(b, lines, reverse);
            } else {
                TextToolsSorting.sortLines(b, reverse);
            }
            b.endCompoundEdit();
        }
    }

    public static void sortLines(JEditBuffer d, boolean reverse) {
        int[] lIndices = new int[d.getLineCount()];
        for (int i = 0; i < lIndices.length; ++i) {
            lIndices[i] = i;
        }
        TextToolsSorting.sortLines(d, lIndices, reverse);
    }

    public static void sortLines(JEditBuffer d, int[] lIndices, boolean reverse) {
        String[] lines = new String[lIndices.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = d.getLineText(lIndices[i]);
        }
        Object compare = new StandardUtilities.StringCompare(false);
        if (reverse) {
            compare = new ReverseCompare(compare);
        }
        Arrays.sort(lines, compare);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length - 1; ++i) {
            sb.append(lines[i]).append('\n');
        }
        sb.append(lines[lines.length - 1]);
        int start = d.getLineStartOffset(lIndices[0]);
        int length = d.getLineEndOffset(lIndices[lIndices.length - 1]) - start - 1;
        d.remove(start, length);
        d.insert(start, sb.toString());
    }

    public static void sortAdvanced(View view, JEditTextArea textArea) {
        if (!TextToolsPlugin.isTextAreaEditable(view, textArea)) {
            return;
        }
        new TextToolsSortDialog(view, textArea);
    }

    public static void deleteDuplicates(View view, JEditTextArea textArea) {
        if (!TextToolsPlugin.isTextAreaEditable(view, textArea)) {
            return;
        }
        JSort jsort = new JSort(true, true);
        int[] selRows = TextToolsSorting.getRectSelectionRows(textArea);
        if (selRows == null) {
            selRows = new int[]{-1, -1};
        }
        jsort.addSortConstraint(selRows[0] + 1, selRows[1] + 1, true, false, false, false, true);
        TextToolsSorting.sortAndInsertData(textArea, jsort, false);
    }

    public static void shuffleLines(View view, JEditTextArea textArea) {
        ArrayList recs = TextToolsSorting.getData(textArea);
        if (recs == null) {
            return;
        }
        JSort.shuffle(recs);
        Iterator iter = recs.iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next()).append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        if (textArea.getSelectedLines().length > 1) {
            textArea.setSelectedText(sb.toString());
        } else {
            textArea.setText(sb.toString());
        }
    }

    public static boolean sortAndInsertData(JEditTextArea textArea, JSort jsort, boolean sortOnlySelection) {
        ArrayList data = TextToolsSorting.getData(textArea, sortOnlySelection);
        if (data == null) {
            return false;
        }
        if (data.size() == 1) {
            return false;
        }
        if (TextToolsPlugin.debugTT) {
            Iterator di = data.iterator();
            while (di.hasNext()) {
                Log.log((int)1, BeanShell.class, (Object)("TextToolsSortDialog.231: di.next() = " + di.next()));
            }
        }
        jsort.sort(data);
        Iterator iter = data.iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next()).append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        if (textArea.getSelectionCount() > 0) {
            textArea.setSelectedText(sb.toString());
        } else {
            textArea.setText(sb.toString());
        }
        return true;
    }

    static ArrayList getData(JEditTextArea textArea) {
        return TextToolsSorting.getData(textArea, false);
    }

    static ArrayList getData(JEditTextArea textArea, boolean onlyRectSelection) {
        JEditBuffer buffer = textArea.getBuffer();
        if (buffer.isReadOnly()) {
            Log.log((int)5, TextToolsSorting.class, (Object)jEdit.getProperty((String)"texttoolsplugin.error.isReadOnly.message"));
            textArea.getToolkit().beep();
            return null;
        }
        int[] rectSelRows = null;
        if (onlyRectSelection) {
            rectSelRows = TextToolsSorting.getRectSelectionRows(textArea);
            if (rectSelRows == null) {
                Log.log((int)5, TextToolsSorting.class, (Object)jEdit.getProperty((String)"texttoolsplugin.error.no-rect-selection.message"));
                textArea.getToolkit().beep();
                return null;
            }
            if (TextToolsPlugin.debugTT) {
                Log.log((int)1, BeanShell.class, (Object)("TextToolsSorting.199: rectSelRows = " + rectSelRows[0] + ", " + rectSelRows[1]));
            }
        }
        ArrayList<String> recs = new ArrayList<String>();
        Selection[] selection = textArea.getSelection();
        if (selection == null || selection.length == 0) {
            if (buffer.getLength() == 0) {
                Log.log((int)5, TextToolsSorting.class, (Object)jEdit.getProperty((String)"texttoolsplugin.error.empty.message"));
                textArea.getToolkit().beep();
                return null;
            }
            for (int i = 0; i < buffer.getLineCount(); ++i) {
                recs.add(textArea.getLineText(i));
            }
        } else {
            if (selection.length > 1) {
                Log.log((int)5, TextToolsSorting.class, (Object)"multiselection not allowed");
                textArea.getToolkit().beep();
                return null;
            }
            Selection sel0 = selection[0];
            if (sel0.getEnd() == sel0.getStart(buffer, sel0.getEndLine())) {
                sel0 = new Selection.Range(sel0.getStart(), sel0.getEnd() - 1);
            }
            int selStartLine = buffer.getLineOfOffset(sel0.getStart());
            int selEndLine = buffer.getLineOfOffset(sel0.getEnd());
            for (int i = selStartLine; i <= selEndLine; ++i) {
                if (onlyRectSelection) {
                    recs.add(textArea.getLineText(i).substring(rectSelRows[0], rectSelRows[1]));
                    continue;
                }
                recs.add(textArea.getLineText(i));
            }
            if (!onlyRectSelection) {
                sel0 = new Selection.Range(buffer.getLineStartOffset(selStartLine), buffer.getLineEndOffset(selEndLine) - 1);
                textArea.setSelection(sel0);
            }
        }
        return recs;
    }

    static String getSubstringOrSpaces(String s, int beginIndex, int endIndex) {
        int actLen = s.length();
        int reqLen = endIndex - beginIndex;
        if (actLen <= beginIndex) {
            return StandardUtilities.createWhiteSpace((int)reqLen, (int)0);
        }
        if (actLen < endIndex) {
            return s.substring(beginIndex) + StandardUtilities.createWhiteSpace((int)(reqLen - actLen), (int)0);
        }
        return s.substring(beginIndex, endIndex);
    }

    static int[] getRectSelectionRows(JEditTextArea textArea) {
        Selection[] selection = textArea.getSelection();
        if (selection.length != 0 && selection[0] instanceof Selection.Rect) {
            JEditBuffer buffer = textArea.getBuffer();
            int[] selRows = new int[2];
            int selLine = selection[0].getStartLine();
            selRows[0] = selection[0].getStart(buffer, selLine) - buffer.getLineStartOffset(selLine);
            selRows[1] = selection[0].getEnd(buffer, selLine) - buffer.getLineStartOffset(selLine) - 1;
            return selRows;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReverseCompare<E>
    implements Comparator<E> {
        private Comparator<E> comp;

        ReverseCompare(Comparator<E> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(E obj1, E obj2) {
            return this.comp.compare(obj2, obj1);
        }
    }
}

