/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class TextToolsSortDialog
extends EnhancedDialog
implements ActionListener {
    private JSort jsort;
    private List data;
    private View view;
    private JEditTextArea textArea;
    private boolean selection;
    private JCheckBox onlySelectionCheckBox;
    private JCheckBox dontSortCheckBox;
    private JCheckBox delDupsCheckBox;
    private JButton ok;
    private JButton cancel;
    private JButton clear;
    private JButton help;
    private SortTableModel sortTableModel;
    private JTable sortTable;

    public TextToolsSortDialog(View view, JEditTextArea textArea) {
        super((Frame)view, jEdit.getProperty((String)"text-tools.sortadvanced.label"), false);
        this.view = view;
        this.textArea = textArea;
        view.showWaitCursor();
        this.sortTableModel = new SortTableModel();
        boolean rectSel = false;
        int[] selRows = TextToolsSorting.getRectSelectionRows(textArea);
        if (selRows != null) {
            this.sortTableModel.setValueAt(new Integer(selRows[0] + 1), 0, 0);
            this.sortTableModel.setValueAt(new Integer(selRows[1] + 1), 0, 1);
            rectSel = true;
        }
        this.sortTable = new JTable(this.sortTableModel);
        TableColumnModel cMod = this.sortTable.getColumnModel();
        this.sortTable.setTableHeader(new SortTableHeader(cMod));
        this.sortTable.setRowHeight(25);
        this.sortTable.setPreferredScrollableViewportSize(new Dimension(430, 200));
        JScrollPane scroll = new JScrollPane(this.sortTable);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(5, 8, 8, 8));
        content.setLayout(new BorderLayout());
        this.setContentPane(content);
        content.add((Component)scroll, "Center");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(this);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalStrut(6));
        this.clear = new JButton("Clear");
        this.clear.addActionListener(this);
        buttons.add(this.clear);
        buttons.add(Box.createHorizontalStrut(6));
        this.help = new JButton("Help");
        this.help.addActionListener(this);
        buttons.add(this.help);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(Box.createGlue());
        content.add((Component)buttons, "South");
        this.delDupsCheckBox = new JCheckBox(jEdit.getProperty((String)"text-tools.sortadvanced.delete-identic-lines"));
        this.onlySelectionCheckBox = new JCheckBox(jEdit.getProperty((String)"text-tools.sortadvanced.sort-only-selection"));
        JPanel checkBoxes = new JPanel();
        if (rectSel) {
            checkBoxes.add(this.onlySelectionCheckBox);
        }
        checkBoxes.add(this.delDupsCheckBox);
        content.add((Component)checkBoxes, "North");
        view.hideWaitCursor();
        this.pack();
        GUIUtilities.loadGeometry((Window)((Object)this), (String)"texttools-sort-control");
        this.setLocationRelativeTo((Component)view);
        this.setVisible(true);
    }

    public void ok() {
        this.ok(true);
    }

    public void cancel() {
        this.dispose();
    }

    public void ok(boolean dispose) {
        this.jsort = new JSort(this.delDupsCheckBox.isSelected());
        Log.log((int)1, (Object)this, (Object)(" delDups is set to " + this.delDupsCheckBox.isSelected()));
        for (int i = 0; i < 10; ++i) {
            int start = (Integer)this.sortTableModel.getValueAt(i, 0);
            int end = (Integer)this.sortTableModel.getValueAt(i, 1);
            if (this.onlySelectionCheckBox.isSelected()) {
                start = 0;
                end = 10000;
            }
            boolean ascending = (Boolean)this.sortTableModel.getValueAt(i, 2) == false;
            boolean ignoreCase = (Boolean)this.sortTableModel.getValueAt(i, 3);
            boolean textType = (Boolean)this.sortTableModel.getValueAt(i, 4);
            boolean trim = (Boolean)this.sortTableModel.getValueAt(i, 5);
            boolean delDupRange = (Boolean)this.sortTableModel.getValueAt(i, 6);
            if (end == 0 && ascending && !ignoreCase && !textType && !trim) break;
            Log.log((int)1, (Object)this, (Object)("Sort constraint: " + start + " " + end + " " + ascending + " " + ignoreCase + " " + textType + " " + trim));
            this.jsort.addSortConstraint(start, end, ascending, ignoreCase, textType, trim, delDupRange);
        }
        if (!TextToolsSorting.sortAndInsertData(this.textArea, this.jsort, this.onlySelectionCheckBox.isSelected())) {
            return;
        }
        GUIUtilities.saveGeometry((Window)((Object)this), (String)"texttools-sort-control");
        if (dispose) {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.clear) {
            this.sortTableModel.clear();
        } else if (source == this.help) {
            this.showHelp();
        }
    }

    private void showHelp() {
        URL helpUrl = TextToolsSortDialog.class.getResource("TextTools.html");
        if (helpUrl == null) {
            Log.log((int)5, (Object)this, (Object)"Help URL is null, cannot display help");
        } else {
            new HelpViewer(helpUrl.toString());
        }
    }

    private class SortTableHeader
    extends JTableHeader {
        public SortTableHeader(TableColumnModel tcom) {
            super(tcom);
        }

        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            switch (this.columnAtPoint(p)) {
                case 0: {
                    return "Start column for the sort field";
                }
                case 1: {
                    return "End column for the sort field";
                }
                case 2: {
                    return "Enable for descending sort order";
                }
                case 3: {
                    return "Enable for case insensitive sort";
                }
                case 4: {
                    return "Enable for numeric type sort";
                }
                case 5: {
                    return "Trim whitespace before sorting";
                }
            }
            return null;
        }
    }

    private class SortTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[7];
        private int[] startColumns;
        private int[] endColumns;
        private boolean[] ignoreCases;
        private boolean[] directions;
        private boolean[] types;
        private boolean[] trims;
        private boolean[] delDups;

        public SortTableModel() {
            this.columnNames[0] = "Start";
            this.columnNames[1] = "End";
            this.columnNames[2] = "Desc";
            this.columnNames[3] = "ICase";
            this.columnNames[4] = "Numeric";
            this.columnNames[5] = "Trim";
            this.columnNames[6] = "DelDups";
            this.clear();
        }

        public void clear() {
            this.startColumns = new int[10];
            this.endColumns = new int[10];
            this.ignoreCases = new boolean[10];
            this.directions = new boolean[10];
            this.types = new boolean[10];
            this.trims = new boolean[10];
            this.delDups = new boolean[10];
            this.fireTableDataChanged();
        }

        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 0: {
                    this.startColumns[row] = (Integer)value;
                    break;
                }
                case 1: {
                    this.endColumns[row] = (Integer)value;
                    break;
                }
                case 2: {
                    this.directions[row] = (Boolean)value;
                    break;
                }
                case 3: {
                    this.ignoreCases[row] = (Boolean)value;
                    break;
                }
                case 4: {
                    this.types[row] = (Boolean)value;
                    break;
                }
                case 5: {
                    this.trims[row] = (Boolean)value;
                    break;
                }
                case 6: {
                    this.delDups[row] = (Boolean)value;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.startColumns.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return new Integer(this.startColumns[row]);
                }
                case 1: {
                    return new Integer(this.endColumns[row]);
                }
                case 2: {
                    return new Boolean(this.directions[row]);
                }
                case 3: {
                    return new Boolean(this.ignoreCases[row]);
                }
                case 4: {
                    return new Boolean(this.types[row]);
                }
                case 5: {
                    return new Boolean(this.trims[row]);
                }
                case 6: {
                    return new Boolean(this.delDups[row]);
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

