/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class TextToolsPlugin
extends EditPlugin {
    public static boolean debugTT = false;

    public static boolean isTextAreaEditable(View view, JEditTextArea textArea) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            if (view != null) {
                view.getStatus().setMessageAndClear(jEdit.getProperty((String)"view.status.textTools.buffer-not-editable"));
            }
            return false;
        }
        return true;
    }

    public static boolean isSelectedAndRectangular(View view, JEditTextArea textArea) {
        Selection[] selection = textArea.getSelection();
        if (selection.length == 0 || selection[0] instanceof Selection.Range) {
            textArea.getToolkit().beep();
            if (view != null) {
                view.getStatus().setMessageAndClear(jEdit.getProperty((String)"view.status.textTools.rectangular-selection-required"));
            }
            return false;
        }
        return true;
    }

    public static void transposeChars(JEditTextArea textArea) {
        int caret;
        int line = textArea.getCaretLine();
        if (!textArea.isEditable() || textArea.getLineLength(line) < 2) {
            textArea.getToolkit().beep();
            return;
        }
        int start = caret = textArea.getCaretPosition();
        if (caret == textArea.getLineStartOffset(line)) {
            ++caret;
        } else if (caret == textArea.getLineEndOffset(line) - 1) {
            --caret;
        }
        JEditBuffer b = textArea.getBuffer();
        b.beginCompoundEdit();
        String pair = b.getText(caret - 1, 2);
        String trans = new String(new char[]{pair.charAt(1), pair.charAt(0)});
        b.remove(caret - 1, 2);
        b.insert(caret - 1, trans);
        textArea.setCaretPosition(start);
        b.endCompoundEdit();
    }

    public static void transposeWords(JEditTextArea textArea) {
        int line = textArea.getCaretLine();
        if (!textArea.isEditable() || textArea.getLineLength(line) == 0) {
            textArea.getToolkit().beep();
            return;
        }
        int lineStart = textArea.getLineStartOffset(line);
        int offset = textArea.getCaretPosition() - lineStart;
        JEditBuffer buffer = textArea.getBuffer();
        String lineText = textArea.getLineText(line);
        String noWordSep = (String)buffer.getProperty((Object)"noWordSep");
        if (offset == lineText.length()) {
            --offset;
        }
        int wordStart = TextUtilities.findWordStart((String)lineText, (int)offset, (String)noWordSep);
        int wordEnd = TextUtilities.findWordEnd((String)lineText, (int)(offset + 1), (String)noWordSep);
        if (wordStart == 0 && wordEnd == lineText.length()) {
            return;
        }
        boolean reverseBias = false;
        boolean word = TextToolsPlugin.isWordChar(lineText.charAt(wordStart), noWordSep) || (reverseBias = wordStart == offset);
        int word2End = 0;
        int word2Start = 0;
        int word1End = 0;
        int word1Start = 0;
        if (word) {
            if (wordStart == 0) {
                word1Start = wordStart;
                word1End = wordEnd;
                word2Start = TextUtilities.findWordEnd((String)lineText, (int)(word1End + 1), (String)noWordSep);
                if (word2Start == lineText.length()) {
                    return;
                }
                word2End = TextUtilities.findWordEnd((String)lineText, (int)(word2Start + 1), (String)noWordSep);
            } else if (wordEnd == lineText.length()) {
                word2Start = wordStart;
                word2End = wordEnd;
                word1End = TextUtilities.findWordStart((String)lineText, (int)(word2Start - 1), (String)noWordSep);
                if (word1End == 0) {
                    return;
                }
                word1Start = TextUtilities.findWordStart((String)lineText, (int)(word1End - 1), (String)noWordSep);
            } else if (reverseBias) {
                word2Start = TextUtilities.findWordStart((String)lineText, (int)(wordStart - 1), (String)noWordSep);
                if (word2Start == 0) {
                    return;
                }
                word2End = wordStart;
                word1End = TextUtilities.findWordStart((String)lineText, (int)(word2Start - 1), (String)noWordSep);
                if (word1End == 0) {
                    return;
                }
                word1Start = TextUtilities.findWordStart((String)lineText, (int)(word1End - 1), (String)noWordSep);
            } else {
                word2Start = wordStart;
                word2End = wordEnd;
                word1End = TextUtilities.findWordStart((String)lineText, (int)(word2Start - 1), (String)noWordSep);
                if (word1End == 0) {
                    return;
                }
                word1Start = TextUtilities.findWordStart((String)lineText, (int)(word1End - 1), (String)noWordSep);
            }
        } else if (wordStart == 0) {
            word1End = TextUtilities.findWordEnd((String)lineText, (int)(wordEnd + 1), (String)noWordSep);
            if (word1End == lineText.length()) {
                return;
            }
            word1Start = wordEnd;
            word2Start = TextUtilities.findWordEnd((String)lineText, (int)(word1End + 1), (String)noWordSep);
            if (word2Start == lineText.length()) {
                return;
            }
            word2End = TextUtilities.findWordEnd((String)lineText, (int)(word2Start + 1), (String)noWordSep);
        } else if (wordEnd == lineText.length()) {
            word2Start = TextUtilities.findWordStart((String)lineText, (int)(wordStart - 1), (String)noWordSep);
            if (word2Start == 0) {
                return;
            }
            word2End = wordStart;
            word1End = TextUtilities.findWordStart((String)lineText, (int)(word2Start - 1), (String)noWordSep);
            if (word1End == 0) {
                return;
            }
            word1Start = TextUtilities.findWordStart((String)lineText, (int)(word1End - 1), (String)noWordSep);
        } else {
            word1Start = TextUtilities.findWordStart((String)lineText, (int)(wordStart - 1), (String)noWordSep);
            word1End = TextUtilities.findWordEnd((String)lineText, (int)wordStart, (String)noWordSep);
            word2Start = TextUtilities.findWordStart((String)lineText, (int)wordEnd, (String)noWordSep);
            word2End = TextUtilities.findWordEnd((String)lineText, (int)(wordEnd + 1), (String)noWordSep);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(lineText.substring(word2Start, word2End));
        buf.append(lineText.substring(word1End, word2Start));
        buf.append(lineText.substring(word1Start, word1End));
        buffer.beginCompoundEdit();
        buffer.remove(lineStart + word1Start, word2End - word1Start);
        buffer.insert(lineStart + word1Start, buf.toString());
        textArea.setCaretPosition(lineStart + word2End);
        buffer.endCompoundEdit();
    }

    public static void transposeLines(JEditTextArea textArea) {
        if (!textArea.isEditable() || textArea.getLineCount() < 2) {
            textArea.getToolkit().beep();
            return;
        }
        int line = textArea.getCaretLine();
        if (line == 0) {
            ++line;
        }
        int start = textArea.getLineStartOffset(line - 1);
        int end = textArea.getLineEndOffset(line);
        StringBuilder buf = new StringBuilder();
        buf.append(textArea.getLineText(line)).append('\n');
        buf.append(textArea.getLineText(line - 1)).append('\n');
        JEditBuffer b = textArea.getBuffer();
        b.beginCompoundEdit();
        b.remove(start, end - start);
        b.insert(start, buf.toString());
        textArea.setCaretPosition(end - 1);
        b.endCompoundEdit();
    }

    public static void doColumnInsert(View view) {
        JEditTextArea ta = view.getTextArea();
        final Selection[] sel = ta.getSelection();
        if (sel.length != 0 && sel[0] instanceof Selection.Rect) {
            final View theView = view;
            int width = ta.getWidth();
            int height = ta.getHeight();
            int taX = ta.getX();
            int taY = ta.getY();
            int xCoord = taX + width / 2;
            int yCoord = taY + height / 2;
            ColumnInsertDialog dialog = new ColumnInsertDialog(new KeyListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        int startPos = -1;
                        int endPos = -1;
                        int cols = -1;
                        Selection.Rect rSel = (Selection.Rect)sel[0];
                        startPos = rSel.getStartLine();
                        endPos = rSel.getEndLine();
                        int rows = endPos - startPos;
                        int startCol = rSel.getStart((JEditBuffer)theView.getBuffer(), startPos);
                        int endCol = rSel.getEnd((JEditBuffer)theView.getBuffer(), startPos);
                        cols = endCol - startCol;
                        int[] colNum = new int[rows + 1];
                        int j = 0;
                        for (int i = startPos; i <= endPos; ++i) {
                            colNum[j++] = rSel.getStart((JEditBuffer)theView.getBuffer(), i);
                        }
                        ColumnInsertDialog d = (ColumnInsertDialog)((JTextField)e.getSource()).getTopLevelAncestor();
                        String text = d.getText();
                        d.dispose();
                        JEditBuffer buff = theView.getTextArea().getBuffer();
                        try {
                            buff.beginCompoundEdit();
                            theView.getTextArea().setSelectedText("");
                            int strLen = text.length();
                            for (int i = 0; i < colNum.length; ++i) {
                                buff.insert(colNum[i] + i * strLen - i * cols, text);
                            }
                        }
                        finally {
                            buff.endCompoundEdit();
                        }
                    }
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            dialog.setBounds(xCoord, yCoord, dialog.getWidth(), dialog.getHeight());
        } else {
            view.getToolkit().beep();
        }
    }

    public static void textToolsBlockHandling(View view, JEditTextArea textArea) {
        if (TextToolsPlugin.isTextAreaEditable(view, textArea) && TextToolsPlugin.isSelectedAndRectangular(view, textArea)) {
            new TextToolsBlockHandlingDialog(view);
        } else {
            GUIUtilities.error((Component)view, (String)"texttoolsplugin.error.no-rect-selection", null);
        }
    }

    public static void spacesToTabsXT(JEditTextArea textArea) {
        System.out.println("Call SpacesToTabs_XT 1");
    }

    private static final boolean isWordChar(char ch, String noWordSep) {
        return Character.isLetterOrDigit(ch) || noWordSep != null && noWordSep.indexOf(ch) != -1;
    }
}

