/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class TextToolsComments {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toggleLineComments(View view) {
        JEditTextArea textArea = view.getTextArea();
        JEditBuffer buffer = textArea.getBuffer();
        try {
            if (!buffer.isEditable()) {
                view.getToolkit().beep();
                return;
            }
            Selection[] selections = textArea.getSelection();
            int selectionNo = selections.length < 1 ? 1 : selections.length;
            for (int j = 0; j < selectionNo; ++j) {
                Selection[] sArr;
                String lineComment;
                String line;
                int[] lines;
                if (selections.length < 1) {
                    lines = new int[]{textArea.getCaretLine()};
                } else {
                    lines = new int[selections[j].getEndLine() - selections[j].getStartLine() + 1];
                    for (int i = 0; i < lines.length; ++i) {
                        lines[i] = i + selections[j].getStartLine();
                    }
                }
                int leftmost = Integer.MAX_VALUE;
                if (jEdit.getBooleanProperty((String)"options.toggle-comments.indentAsBlock")) {
                    for (int i = 0; i < lines.length; ++i) {
                        line = buffer.getLineText(lines[i]);
                        if (line.trim().length() < 1) continue;
                        leftmost = Math.min(leftmost, StandardUtilities.getLeadingWhiteSpaceWidth((String)line, (int)buffer.getTabSize()));
                    }
                }
                boolean doUncomment = true;
                if (jEdit.getBooleanProperty((String)"options.toggle-comments.commentAsBlock")) {
                    for (int i = 0; doUncomment && i < lines.length; ++i) {
                        line = buffer.getLineText(lines[i]).trim();
                        lineComment = buffer.getContextSensitiveProperty(buffer.getLineStartOffset(lines[i]), "lineComment");
                        if (lineComment == null || lineComment.length() == 0 || line.length() <= 0 || line.startsWith(lineComment)) continue;
                        doUncomment = false;
                    }
                }
                boolean noCommentableLines = true;
                lineComment = null;
                for (int i = 0; i < lines.length; ++i) {
                    Log.log((int)1, TextToolsComments.class, (Object)("looping line: " + lines[i]));
                    line = buffer.getLineText(lines[i]);
                    int lineStart = buffer.getLineStartOffset(lines[i]);
                    int pos = lineStart + StandardUtilities.getLeadingWhiteSpace((String)line);
                    if (i == 0) {
                        lineComment = buffer.getContextSensitiveProperty(pos + 1, "lineComment");
                    }
                    if (line.trim().length() < 1) continue;
                    if (lineComment == null || lineComment.length() == 0) {
                        Log.log((int)1, TextToolsComments.class, (Object)("No line comment: " + lines[i]));
                        continue;
                    }
                    noCommentableLines = false;
                    TextToolsComments.lockBuffer(buffer);
                    if (line.trim().startsWith(lineComment) && doUncomment) {
                        buffer.remove(pos, lineComment.length());
                        if (!Character.isWhitespace(buffer.getText(pos, 1).charAt(0))) continue;
                        buffer.remove(pos, 1);
                        continue;
                    }
                    if (jEdit.getBooleanProperty((String)"options.toggle-comments.indentAtLineStart")) {
                        buffer.insert(lineStart, lineComment + " ");
                        continue;
                    }
                    if (jEdit.getBooleanProperty((String)"options.toggle-comments.indentAsBlock")) {
                        Segment seg = new Segment();
                        buffer.getLineText(lines[i], seg);
                        Log.log((int)1, TextToolsComments.class, (Object)("commenting line: " + lines[i]));
                        buffer.insert(lineStart + StandardUtilities.getOffsetOfVirtualColumn((Segment)seg, (int)buffer.getTabSize(), (int)leftmost, null), lineComment + " ");
                        continue;
                    }
                    buffer.insert(pos, lineComment + " ");
                }
                if (noCommentableLines) {
                    view.getToolkit().beep();
                    return;
                }
                if (jEdit.getBooleanProperty((String)"options.toggle-comments.keepSelected") || (sArr = textArea.getSelection()).length <= 0) continue;
                textArea.setCaretPosition(sArr[sArr.length - 1].getEnd());
            }
        }
        finally {
            TextToolsComments.unlockBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toggleRangeComments(View view) {
        JEditTextArea textArea = view.getTextArea();
        JEditBuffer buffer = textArea.getBuffer();
        if (!buffer.isEditable() || !TextToolsComments.usesRangeComments(buffer)) {
            view.getToolkit().beep();
            return;
        }
        try {
            Selection[] selections = textArea.getSelection();
            if (selections.length < 1) {
                TextToolsComments.toggleRangeComment(buffer, textArea.getCaretPosition());
            }
            for (int i = 0; i < selections.length; ++i) {
                String selectTxt = textArea.getSelectedText(selections[i]);
                try {
                    TextToolsComments.lockBuffer(buffer);
                    int start = selections[i].getStart();
                    int end = selections[i].getEnd();
                    int length = TextToolsComments.toggleRangeComment(buffer, start, end);
                    if (!jEdit.getBooleanProperty((String)"options.toggle-comments.keepSelected")) continue;
                    textArea.addToSelection((Selection)new Selection.Range(start, start + length));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    Log.log((int)9, TextToolsComments.class, (Object)sw.toString());
                }
            }
        }
        finally {
            TextToolsComments.unlockBuffer(buffer);
        }
    }

    private static boolean isInRangeComment(JEditBuffer buffer, int offset) {
        String preceding = buffer.getText(0, offset);
        String commentStart = buffer.getContextSensitiveProperty(offset, "commentStart");
        String commentEnd = buffer.getContextSensitiveProperty(offset, "commentEnd");
        int lastStart = preceding.lastIndexOf(commentStart);
        int lastEnd = preceding.lastIndexOf(commentEnd);
        return lastStart != -1 && lastStart > lastEnd;
    }

    private static boolean lockBuffer(JEditBuffer buffer) {
        if (!buffer.insideCompoundEdit()) {
            buffer.writeLock();
            buffer.beginCompoundEdit();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toggleRangeComment(JEditBuffer buffer, int offset) {
        String commentStart = buffer.getContextSensitiveProperty(offset, "commentStart");
        String commentEnd = buffer.getContextSensitiveProperty(offset, "commentEnd");
        if (TextToolsComments.isInRangeComment(buffer, offset)) {
            String preceding = buffer.getText(0, offset);
            String following = buffer.getText(offset, buffer.getLength() - offset);
            int start = preceding.lastIndexOf(commentStart);
            int end = following.indexOf(commentEnd) + offset;
            try {
                TextToolsComments.lockBuffer(buffer);
                buffer.remove(end, commentEnd.length());
                buffer.remove(start, commentStart.length());
            }
            finally {
                TextToolsComments.unlockBuffer(buffer);
            }
        } else {
            int line = buffer.getLineOfOffset(offset);
            String lineTxt = buffer.getLineText(line);
            int start = buffer.getLineStartOffset(line) + StandardUtilities.getLeadingWhiteSpace((String)lineTxt);
            int end = buffer.getLineEndOffset(line) - (StandardUtilities.getTrailingWhiteSpace((String)lineTxt) + 1);
            TextToolsComments.toggleRangeComment(buffer, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int toggleRangeComment(JEditBuffer buffer, int start, int end) {
        String commentStart = buffer.getContextSensitiveProperty(start, "commentStart");
        String commentEnd = buffer.getContextSensitiveProperty(start, "commentEnd");
        StringBuilder buf = new StringBuilder(buffer.getText(start, end - start));
        boolean REMOVE_COMMENT_START = false;
        boolean REMOVE_COMMENT_END = true;
        int LOOK_FOR_COMMENT_END = 2;
        int LOOK_FOR_COMMENT_START = 3;
        int INSERT_COMMENT_START = 4;
        int INSERT_COMMENT_END = 5;
        int state = buf.indexOf(commentStart) == 0 ? 0 : (buf.indexOf(commentEnd) == 0 ? 1 : (TextToolsComments.isInRangeComment(buffer, start) ? 5 : 4));
        int i = 0;
        block11: while (i > -1 && i < buf.length()) {
            switch (state) {
                case 0: {
                    boolean atStart = i == 0;
                    buf.delete(i, i + commentStart.length());
                    state = atStart ? 2 : 5;
                    continue block11;
                }
                case 1: {
                    boolean atStart = i == 0;
                    buf.delete(i, i + commentEnd.length());
                    state = atStart ? 3 : 4;
                    continue block11;
                }
                case 4: {
                    buf.insert(i, commentStart);
                    i += commentStart.length();
                    state = 3;
                    continue block11;
                }
                case 5: {
                    buf.insert(i, commentEnd);
                    i += commentEnd.length();
                    state = 2;
                    continue block11;
                }
                case 2: {
                    i = buf.indexOf(commentEnd, i);
                    if (i == -1) {
                        buf.append(commentStart);
                        continue block11;
                    }
                    state = 1;
                    continue block11;
                }
                case 3: {
                    i = buf.indexOf(commentStart, i);
                    if (i == -1) {
                        buf.append(commentEnd);
                        continue block11;
                    }
                    state = 0;
                    continue block11;
                }
            }
            throw new IllegalStateException("unknown state " + state);
        }
        boolean newEdit = false;
        try {
            newEdit = TextToolsComments.lockBuffer(buffer);
            buffer.remove(start, end - start);
            buffer.insert(start, buf.toString());
            int n = buf.length();
            return n;
        }
        finally {
            if (newEdit) {
                TextToolsComments.unlockBuffer(buffer);
            }
        }
    }

    private static boolean unlockBuffer(JEditBuffer buffer) {
        if (buffer.insideCompoundEdit()) {
            buffer.endCompoundEdit();
            buffer.writeUnlock();
            return true;
        }
        return false;
    }

    private static boolean usesRangeComments(JEditBuffer buffer) {
        return buffer.getStringProperty("commentStart") != null && buffer.getStringProperty("commentEnd") != null;
    }
}

