/*
 * Decompiled with CFR 0.152.
 */
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class TextToolsBlockMove {
    public static final int MOVE_LEFT = 1;
    public static final int MOVE_RIGHT = 2;
    public static final int MOVE_UP = 3;
    public static final int MOVE_DOWN = 4;
    public static boolean debug = false;

    public static void setRectSelection(JEditTextArea ta, Buffer buffer, int startLine, int startColumn, int endLine, int endColumn) {
        int endOffset;
        int selEndCol;
        int startOffset;
        int extraEndVirt;
        int extraStartVirt;
        int[] width;
        block15: {
            if (debug) {
                Log.log((int)1, BeanShell.class, (Object)("Block_Move.33: startLine = " + startLine + ", startColumn = " + startColumn + ", endLine = " + endLine + ", endColumn = " + endColumn));
            }
            if (endLine >= buffer.getLineCount()) {
                endLine = buffer.getLineCount() - 1;
            }
            if (endLine < startLine) {
                startLine = endLine;
            }
            width = new int[1];
            extraStartVirt = 0;
            extraEndVirt = 0;
            int selStartCol = Math.min(startColumn, endColumn);
            startOffset = buffer.getOffsetOfVirtualColumn(startLine, selStartCol, width);
            if (startOffset == -1) {
                int vsler = buffer.getVirtualWidth(startLine, buffer.getLineEndOffset(startLine) - buffer.getLineStartOffset(startLine));
                if (debug) {
                    Log.log((int)1, BeanShell.class, (Object)("Block_Move.45: vsler = " + vsler));
                }
                if (startColumn >= vsler) {
                    extraStartVirt = endColumn - width[0];
                }
                startOffset = buffer.getLineEndOffset(startLine) - 1;
            } else {
                startOffset += buffer.getLineStartOffset(startLine);
            }
            if (debug) {
                Log.log((int)1, BeanShell.class, (Object)("Set_Rect_Selection.17: width = " + width[0] + ", startOffset = " + startOffset + ", extraStartVirt = " + extraStartVirt));
            }
            selEndCol = extraStartVirt > 0 ? selStartCol : Math.max(startColumn, endColumn);
            try {
                endOffset = buffer.getOffsetOfVirtualColumn(endLine, selEndCol, width);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                endOffset = buffer.getLength();
                if (!debug) break block15;
                Log.log((int)1, BeanShell.class, (Object)("Block_Move.66: endOffset = " + endOffset));
            }
        }
        if (endOffset == -1) {
            extraEndVirt = selEndCol - width[0];
            endOffset = buffer.getLineEndOffset(endLine) - 1;
        } else {
            endOffset += buffer.getLineStartOffset(endLine);
        }
        if (debug) {
            Log.log((int)1, BeanShell.class, (Object)("Set_Rect_Selection.28: width = " + width[0] + ", endOffset = " + endOffset + ", extraEndVirt = " + extraEndVirt));
        }
        if (extraStartVirt == 0) {
            ta.resizeSelection(startOffset, endOffset, extraEndVirt, true);
        } else {
            ta.resizeSelection(endOffset, startOffset, extraStartVirt, true);
        }
    }

    public static void blockMove(View view, JEditTextArea textArea, Buffer buffer, int direction) {
        if (textArea.getSelectionCount() == 0) {
            view.getStatus().setMessageAndClear(jEdit.getProperty((String)"view.status.textTools.selection-required"));
        } else {
            int oldIndent = buffer.getIndentSize();
            buffer.setIntegerProperty("indentSize", 1);
            Selection[] sels = textArea.getSelection();
            boolean overwrite = false;
            boolean cont = true;
            buffer.beginCompoundEdit();
            block17: for (int i = sels.length - 1; i >= 0 && cont; --i) {
                Selection currSel = sels[i];
                int currStartLine = currSel.getStartLine();
                int currEndLine = currSel.getEndLine();
                if (currSel instanceof Selection.Range) {
                    if (currSel.getEnd() == textArea.getLineStartOffset(currEndLine)) {
                        --currEndLine;
                    }
                    int[] selLines = new int[currEndLine - currStartLine + 1];
                    for (int lc = currStartLine; lc <= currEndLine; ++lc) {
                        selLines[lc - currStartLine] = lc;
                    }
                    if (direction == 2) {
                        buffer.shiftIndentRight(selLines);
                        continue;
                    }
                    if (direction != 1) continue;
                    buffer.shiftIndentLeft(selLines);
                    continue;
                }
                boolean skipSelection = false;
                boolean moveExceedsBuffer = false;
                int vssr = ((Selection.Rect)currSel).getStartColumn((JEditBuffer)buffer);
                int vesr = ((Selection.Rect)currSel).getEndColumn((JEditBuffer)buffer);
                int selWidth = vesr - vssr;
                if (debug) {
                    Log.log((int)1, BeanShell.class, (Object)("Block_Move.121: selWidth = " + selWidth));
                }
                switch (direction) {
                    case 3: {
                        if (currStartLine == 0 || vssr == vesr) {
                            skipSelection = true;
                            break;
                        }
                        --currStartLine;
                        break;
                    }
                    case 4: {
                        if (vssr == vesr) {
                            skipSelection = true;
                            break;
                        }
                        if (++currEndLine < buffer.getLineCount()) break;
                        moveExceedsBuffer = true;
                        currEndLine = buffer.getLineCount();
                        break;
                    }
                    case 1: {
                        if (vssr != 0) break;
                        skipSelection = true;
                    }
                }
                if (skipSelection) continue;
                int[] sso = new int[currEndLine - currStartLine + 1];
                int[] eso = new int[currEndLine - currStartLine + 1];
                int lin = currStartLine;
                int j = 0;
                while (lin <= currEndLine) {
                    if (lin < currEndLine || direction != 4) {
                        sso[j] = currSel.getStart((JEditBuffer)buffer, lin);
                        eso[j] = currSel.getEnd((JEditBuffer)buffer, lin);
                        if (debug) {
                            Log.log((int)1, BeanShell.class, (Object)("Block_Move.148: sso[j] = " + sso[j] + ", eso[j] = " + eso[j]));
                        }
                    }
                    ++lin;
                    ++j;
                }
                String lastLine = "";
                int lastWidth = 0;
                if (debug) {
                    Log.log((int)1, BeanShell.class, (Object)("Block_Move_Left.118: vssr = " + vssr + ", vesr = " + vesr));
                }
                block20: for (int lin2 = currEndLine; lin2 >= currStartLine; --lin2) {
                    if (debug) {
                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.157: lin = " + lin2));
                    }
                    int slo = 0;
                    int elo = 0;
                    int velr = 0;
                    int rsso = 0;
                    int reso = 0;
                    if (!moveExceedsBuffer) {
                        slo = buffer.getLineStartOffset(lin2);
                        elo = buffer.getLineEndOffset(lin2);
                        velr = buffer.getVirtualWidth(lin2, elo - slo - 1) + 1;
                        rsso = sso[lin2 - currStartLine];
                        reso = eso[lin2 - currStartLine];
                    }
                    switch (direction) {
                        case 3: {
                            int vslsr1;
                            String insLine = lastLine;
                            int insWidth = lastWidth;
                            if (vssr < velr) {
                                lastLine = buffer.getText(rsso, reso - rsso);
                                lastWidth = vesr < velr ? vesr - vssr : buffer.getVirtualWidth(lin2, reso - slo) - vssr;
                            } else {
                                lastLine = "";
                                lastWidth = 0;
                            }
                            if (debug) {
                                Log.log((int)1, BeanShell.class, (Object)("Block_Move.163: lastLine = " + lastLine + ", lastWidth = " + lastWidth));
                            }
                            if (debug) {
                                Log.log((int)1, BeanShell.class, (Object)("Block_Move.167: insLine = " + insLine + ", insWidth = " + insWidth));
                            }
                            if (vssr >= velr && insWidth <= 0) continue block20;
                            int leftTabOffset = 0;
                            int fillNbrWs = 0;
                            if (vssr >= velr) {
                                fillNbrWs = vssr - buffer.getVirtualWidth(lin2, reso - slo);
                            } else if (lin2 == currStartLine) {
                                if (vssr > 0 && buffer.getText(rsso - 1, 1).charAt(0) == '\t') {
                                    leftTabOffset = 1;
                                    vslsr1 = buffer.getVirtualWidth(lin2, rsso - slo - 1);
                                    fillNbrWs = vssr - vslsr1;
                                }
                                if (vesr < velr && buffer.getText(reso - 1, 1).charAt(0) == '\t') {
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.238: insWidth = " + insWidth));
                                    }
                                    insWidth -= buffer.getVirtualWidth(lin2, reso - slo) - vesr;
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.240: insWidth = " + insWidth + ", buffer.getVirtualWidth(lin,reso-slo) = " + buffer.getVirtualWidth(lin2, reso - slo) + ", vesr = " + vesr));
                                    }
                                }
                            }
                            String fillLeft = fillNbrWs > 0 ? StandardUtilities.createWhiteSpace((int)fillNbrWs, (int)0) : "";
                            String fillRight = insWidth < selWidth ? StandardUtilities.createWhiteSpace((int)(selWidth - insWidth), (int)0) : "";
                            if (debug) {
                                Log.log((int)1, BeanShell.class, (Object)("Block_Move.181: fillLeft = " + fillLeft + ", fillRight = " + fillRight + ", selWidth = " + selWidth));
                            }
                            buffer.remove(rsso - leftTabOffset, reso - rsso + leftTabOffset);
                            buffer.insert(rsso - leftTabOffset, fillLeft + insLine + fillRight);
                            continue block20;
                        }
                        case 4: {
                            int vslsr1;
                            if (lin2 == currStartLine) {
                                lastLine = "";
                                lastWidth = 0;
                            } else {
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)("Block_Move.233: buffer.getLineEndOffset(lin-1) = " + buffer.getLineEndOffset(lin2 - 1) + ", buffer.getLineStartOffset(lin-1) = " + buffer.getLineStartOffset(lin2 - 1)));
                                }
                                int pvelr = buffer.getVirtualWidth(lin2 - 1, buffer.getLineEndOffset(lin2 - 1) - 1 - buffer.getLineStartOffset(lin2 - 1)) + 1;
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)"Block_Move.236");
                                }
                                int prsso = sso[lin2 - 1 - currStartLine];
                                int preso = eso[lin2 - 1 - currStartLine];
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)("Block_Move.222: pvelr = " + pvelr + ", prsso = " + prsso + ", preso = " + preso));
                                }
                                if (vssr < pvelr) {
                                    lastLine = buffer.getText(prsso, preso - prsso);
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.226: lastLine = " + lastLine));
                                    }
                                    lastWidth = vesr < pvelr ? vesr - vssr : buffer.getVirtualWidth(lin2 - 1, preso - buffer.getLineStartOffset(lin2 - 1)) - vssr;
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.231: lastWidth = " + lastWidth));
                                    }
                                } else {
                                    lastLine = "";
                                    lastWidth = 0;
                                }
                            }
                            if (debug) {
                                Log.log((int)1, BeanShell.class, (Object)("Block_Move.280: lastLine = " + lastLine + ", lastWidth = " + lastWidth));
                            }
                            if (moveExceedsBuffer) {
                                rsso = buffer.getLength();
                                String fillLeft = System.getProperty("line.separator") + StandardUtilities.createWhiteSpace((int)vssr, (int)0);
                                if (lastWidth > 0) {
                                    buffer.insert(rsso, fillLeft + lastLine);
                                }
                                moveExceedsBuffer = false;
                                continue block20;
                            }
                            if (lin2 == currEndLine) {
                                int[] width = new int[1];
                                rsso = buffer.getOffsetOfVirtualColumn(lin2, vssr, width);
                                rsso = rsso == -1 ? elo - 1 : (rsso += slo);
                                reso = buffer.getOffsetOfVirtualColumn(lin2, vesr, width);
                                reso = reso == -1 ? elo - 1 : (reso += slo);
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)("Block_Move.301: rsso = " + rsso + ", reso = " + reso + ", elo = " + elo));
                                }
                            }
                            if (vssr >= velr && lastWidth <= 0) continue block20;
                            int leftTabOffset = 0;
                            int fillNbrWs = 0;
                            if (vssr >= velr) {
                                fillNbrWs = vssr - buffer.getVirtualWidth(lin2, reso - slo);
                            } else if (lin2 == currEndLine) {
                                if (vssr > 0 && buffer.getText(rsso - 1, 1).charAt(0) == '\t') {
                                    leftTabOffset = 1;
                                    vslsr1 = buffer.getVirtualWidth(lin2, rsso - slo - 1);
                                    fillNbrWs = vssr - vslsr1;
                                }
                                if (vesr < velr && buffer.getText(reso - 1, 1).charAt(0) == '\t') {
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.238: lastWidth = " + lastWidth));
                                    }
                                    lastWidth -= buffer.getVirtualWidth(lin2, reso - slo) - vesr;
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move.240: lastWidth = " + lastWidth + ", buffer.getVirtualWidth(lin,reso-slo) = " + buffer.getVirtualWidth(lin2, reso - slo) + ", vesr = " + vesr));
                                    }
                                }
                            }
                            String fillLeft = fillNbrWs > 0 ? StandardUtilities.createWhiteSpace((int)fillNbrWs, (int)0) : "";
                            String fillRight = lastWidth < selWidth ? StandardUtilities.createWhiteSpace((int)(selWidth - lastWidth), (int)0) : "";
                            if (debug) {
                                Log.log((int)1, BeanShell.class, (Object)("Block_Move.181: fillLeft = " + fillLeft + ", fillRight = " + fillRight + ", selWidth = " + selWidth));
                            }
                            buffer.remove(rsso - leftTabOffset, reso - rsso + leftTabOffset);
                            buffer.insert(rsso - leftTabOffset, fillLeft + lastLine + fillRight);
                            continue block20;
                        }
                        case 2: {
                            if (vesr + 1 < velr) {
                                if (!overwrite && !Character.isWhitespace(buffer.getText(reso, 1).charAt(0))) {
                                    if (debug) {
                                        Log.log((int)1, BeanShell.class, (Object)("Block_Move_Right.52: buffer.getText(reso,1).charAt(0) = " + buffer.getText(reso, 1).charAt(0)));
                                    }
                                    overwrite = true;
                                }
                                int insNbrWs = 0;
                                if (buffer.getText(reso, 1).charAt(0) == '\t') {
                                    insNbrWs = buffer.getVirtualWidth(lin2, reso - slo + 1) - vesr - 1;
                                }
                                buffer.remove(reso, 1);
                                if (insNbrWs > 0) {
                                    if (insNbrWs == 1) {
                                        buffer.insert(reso, " ");
                                    } else {
                                        buffer.insert(reso, StandardUtilities.createWhiteSpace((int)insNbrWs, (int)0));
                                    }
                                }
                            }
                            if (vssr >= velr) continue block20;
                            buffer.insert(rsso, " ");
                            if (!debug) continue block20;
                            Log.log((int)1, BeanShell.class, (Object)("Block_Move_Right.239.insert at: rsso = " + rsso));
                            continue block20;
                        }
                        case 1: {
                            if (vssr <= 0) continue block20;
                            if (vesr + 1 < velr) {
                                buffer.insert(reso, " ");
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)("Block_Move_Left.257.insert at: rsso = " + rsso));
                                }
                            }
                            if (vssr >= velr) continue block20;
                            if (!overwrite && !Character.isWhitespace(buffer.getText(rsso - 1, 1).charAt(0))) {
                                if (debug) {
                                    Log.log((int)1, BeanShell.class, (Object)("Block_Move_Left.52: buffer.getText(reso,1).charAt(0) = " + buffer.getText(reso, 1).charAt(0)));
                                }
                                overwrite = true;
                            }
                            int insNbrWs = 0;
                            if (buffer.getText(rsso - 1, 1).charAt(0) == '\t') {
                                insNbrWs = vssr - buffer.getVirtualWidth(lin2, rsso - slo - 1) - 1;
                            }
                            if (insNbrWs > 0) {
                                buffer.remove(rsso - 1, 1);
                                buffer.insert(rsso - 1, StandardUtilities.createWhiteSpace((int)insNbrWs, (int)0));
                                continue block20;
                            }
                            buffer.remove(rsso - 1, 1);
                        }
                    }
                }
                if (sels.length == 1) {
                    textArea.selectNone();
                } else {
                    textArea.removeFromSelection(currSel);
                }
                switch (direction) {
                    case 3: {
                        TextToolsBlockMove.setRectSelection(textArea, buffer, currStartLine, vssr, currEndLine - 1, vesr);
                        continue block17;
                    }
                    case 4: {
                        TextToolsBlockMove.setRectSelection(textArea, buffer, currStartLine + 1, vssr, currEndLine, vesr);
                        continue block17;
                    }
                    case 2: {
                        TextToolsBlockMove.setRectSelection(textArea, buffer, currStartLine, vssr + 1, currEndLine, vesr + 1);
                        continue block17;
                    }
                    case 1: {
                        if (vssr <= 0) continue block17;
                        TextToolsBlockMove.setRectSelection(textArea, buffer, currStartLine, vssr - 1, currEndLine, vesr - 1);
                    }
                }
            }
            buffer.endCompoundEdit();
            buffer.setIntegerProperty("indentSize", oldIndent);
        }
    }
}

