/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class TextToolsBlockHandling {
    public static void doBlockAction(View view, int incrementValue, int insertValue, String insertText, boolean overwriteBlock, boolean increment, boolean leadingZeros) {
        int selEnd;
        int selBegin;
        BeanShellUtility bsu = new BeanShellUtility(view);
        JEditTextArea textArea = view.getTextArea();
        boolean trace = true;
        Buffer buffer = view.getBuffer();
        Selection[] sel = textArea.getSelection();
        int selCount = textArea.getSelectionCount();
        if (selCount == 0) {
            selBegin = bsu.getVisibleRow(textArea.getCaretPosition());
            selEnd = selBegin + insertText.length();
            textArea.goToBufferEnd(true);
        } else {
            selBegin = ((Selection.Rect)sel[0]).getStartColumn((JEditBuffer)buffer);
            selEnd = ((Selection.Rect)sel[0]).getEndColumn((JEditBuffer)buffer);
        }
        if (selCount == 1 && sel[0].getStartLine() == sel[0].getEndLine()) {
            if (trace) {
                Log.log((int)1, TextToolsBlockHandling.class, (Object)"only one selection line");
            }
            textArea.setCaretPosition(sel[0].getStart());
            textArea.goToBufferEnd(true);
        }
        int targetLen = selEnd - selBegin;
        if (!increment && overwriteBlock) {
            if (insertText.length() < targetLen) {
                insertText = insertText + StandardUtilities.createWhiteSpace((int)(targetLen - insertText.length()), (int)0);
            } else if (insertText.length() > targetLen) {
                insertText = insertText.substring(0, targetLen);
            }
        }
        String nullsBlanksString = null;
        int currentIncValue = insertValue;
        if (increment) {
            if (leadingZeros) {
                StringBuilder nulBuf = new StringBuilder("0000000000");
                for (int s = 10; s < targetLen; s += 10) {
                    nulBuf.append("0000000000");
                }
                nullsBlanksString = nulBuf.toString();
            } else {
                nullsBlanksString = StandardUtilities.createWhiteSpace((int)targetLen, (int)0);
            }
        }
        int[] selLines = textArea.getSelectedLines();
        String sourceString = insertText;
        textArea.selectNone();
        StringBuilder blankBuf = new StringBuilder("          ");
        buffer.beginCompoundEdit();
        ArrayList<Selection.Range> targetSelection = new ArrayList<Selection.Range>();
        for (int i = 0; i < selLines.length; ++i) {
            int newEndSelection;
            int newBeginSelection;
            boolean isWithTabs = false;
            if (buffer.getLineText(selLines[i]).indexOf("\t") != -1) {
                isWithTabs = true;
                bsu.selectLine(selLines[i]);
                textArea.tabsToSpaces();
            }
            if (increment) {
                String valString = Integer.toString(currentIncValue);
                String pfxString = targetLen - valString.length() > 0 ? nullsBlanksString.substring(0, targetLen - valString.length()) : "";
                sourceString = currentIncValue < 0 && leadingZeros ? "-" + pfxString + valString.substring(1) : pfxString + valString;
                if (sourceString.length() > targetLen) {
                    sourceString = sourceString.substring(sourceString.length() - targetLen);
                }
            }
            int lineEndOffset = textArea.getLineEndOffset(selLines[i]);
            int insertPos = textArea.getLineStartOffset(selLines[i]) + selBegin;
            int missingBlanks = insertPos - lineEndOffset + 1;
            String prefixString = "";
            if (missingBlanks > 0) {
                while (blankBuf.length() < missingBlanks) {
                    blankBuf.append("          ");
                }
                prefixString = blankBuf.substring(0, missingBlanks);
                insertPos -= missingBlanks;
            }
            if (overwriteBlock && lineEndOffset > 0) {
                int removeDecrement = insertPos + prefixString.length() + sourceString.length() - (lineEndOffset - 1);
                if (removeDecrement < 0) {
                    removeDecrement = 0;
                }
                buffer.remove(insertPos, prefixString.length() + sourceString.length() - removeDecrement);
            }
            buffer.insert(insertPos, prefixString + sourceString);
            if (isWithTabs) {
                bsu.selectLine(selLines[i]);
                textArea.spacesToTabs();
            }
            if ((newBeginSelection = insertPos + prefixString.length()) > buffer.getLength()) {
                newBeginSelection = buffer.getLength();
            }
            if ((newEndSelection = insertPos + prefixString.length() + sourceString.length()) > buffer.getLength()) {
                newEndSelection = buffer.getLength();
            }
            targetSelection.add(new Selection.Range(newBeginSelection, newEndSelection));
            if (!increment) continue;
            currentIncValue += incrementValue;
        }
        Selection[] newSel = new Selection[targetSelection.size()];
        newSel = targetSelection.toArray(newSel);
        textArea.setSelection(newSel);
        buffer.endCompoundEdit();
    }

    String getTempIntProperty(String prop) {
        String ret = jEdit.getProperty((String)prop);
        if (ret == null) {
            return "";
        }
        return ret;
    }
}

