/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.util.Log;

public class JSort
implements Comparator {
    private Vector options = new Vector();
    private boolean deleteDuplicates;
    private boolean dontSort;
    private TreeSet data;

    public JSort() {
        this(false, false);
    }

    public JSort(boolean deleteDuplicates) {
        this(deleteDuplicates, false);
    }

    public JSort(boolean deleteDuplicates, boolean dontSort) {
        this.deleteDuplicates = deleteDuplicates;
        this.dontSort = dontSort;
    }

    public Vector getSortBy() {
        return this.options;
    }

    public void addSortBy(SortBy sortBy) {
        this.options.add(sortBy);
    }

    public void clearSort() {
        this.options = new Vector();
        this.deleteDuplicates = false;
        this.dontSort = false;
    }

    public void addSortConstraint(int startColumn, int endColumn) {
        this.addSortConstraint(startColumn, endColumn, true, false, false, false, false);
    }

    public void addSortConstraint(int startColumn, int endColumn, boolean ascending) {
        this.addSortConstraint(startColumn, endColumn, ascending, false, false, false, false);
    }

    public void addSortConstraint(int startColumn, int endColumn, boolean ascending, boolean ignoreCase) {
        this.addSortConstraint(startColumn, endColumn, ascending, ignoreCase, false, false, false);
    }

    public void addSortConstraint(int startColumn, int endColumn, boolean ascending, boolean ignoreCase, boolean numeric) {
        this.addSortConstraint(startColumn, endColumn, ascending, ignoreCase, numeric, false, false);
    }

    public void addSortConstraint(int startColumn, int endColumn, boolean ascending, boolean ignoreCase, boolean numeric, boolean trimWhitespace, boolean delDupRange) {
        this.addSortBy(new SortBy(--startColumn, endColumn, ascending, ignoreCase, numeric, trimWhitespace, delDupRange));
    }

    public void setDeleteDuplicates(boolean deleteDuplicates) {
        this.deleteDuplicates = deleteDuplicates;
    }

    public boolean getDeleteDuplicates() {
        return this.deleteDuplicates;
    }

    public void setDontSort(boolean dontSort) {
        this.dontSort = dontSort;
    }

    public boolean getDontSort() {
        return this.dontSort;
    }

    public static void shuffle(List list) {
        for (int lastPlace = list.size() - 1; lastPlace > 0; --lastPlace) {
            int randLoc = (int)(Math.random() * (double)(lastPlace + 1));
            Object o = list.set(lastPlace, list.get(randLoc));
            list.set(randLoc, o);
        }
    }

    public void sort(List list) {
        if (this.deleteDuplicates && this.dontSort) {
            ArrayList newList = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                boolean duplicatedFound = false;
                for (int j = 0; j < i && !duplicatedFound; ++j) {
                    if (!list.get(i).toString().equals(list.get(j).toString())) continue;
                    duplicatedFound = true;
                }
                if (duplicatedFound) continue;
                newList.add(list.get(i));
            }
            list.clear();
            list.addAll(newList);
        } else {
            if (this.options.size() == 0) {
                this.addSortConstraint(0, 10000);
            }
            TreeSet ts = new TreeSet(this);
            ts.addAll(list);
            list.clear();
            list.addAll(ts);
        }
    }

    public int compare(Object o1, Object o2) {
        String s1 = o1.toString();
        String s2 = o2.toString();
        if (this.deleteDuplicates && s1.equals(s2)) {
            return 0;
        }
        int retVal = 0;
        for (int i = 0; i < this.options.size(); ++i) {
            String sub2;
            String sub1;
            SortBy sb = (SortBy)this.options.elementAt(i);
            if (sb.startColumn < 0) {
                sb.startColumn = 0;
            }
            if (sb.endColumn == 0) {
                sub1 = s1;
                sub2 = s2;
            } else {
                sub1 = JSort.getCompareStringForSortby(sb, s1);
                sub2 = JSort.getCompareStringForSortby(sb, s2);
            }
            if (sb.trimWhitespace) {
                sub1 = sub1.trim();
                sub2 = sub2.trim();
            }
            retVal = this.compare(sub1, sub2, sb);
            if (TextToolsPlugin.debugTT) {
                Log.log((int)1, BeanShell.class, (Object)("JSort.298: retVal = " + retVal + ", sub1 = " + sub1 + ", sub2 = " + sub2 + ", sb = " + sb));
            }
            if (retVal == 0) {
                if (sb.delDupRange) {
                    return 0;
                }
                if (!this.dontSort) continue;
                return 1;
            }
            if (!this.dontSort) break;
            return 1;
        }
        if (retVal == 0) {
            return 1;
        }
        return retVal;
    }

    public int compare(String str1, String str2, SortBy sortBy) {
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int len = Math.min(char1.length, char2.length);
        int i = 0;
        for (int j = 0; i < len && j < len; ++i, ++j) {
            char ch1 = char1[i];
            char ch2 = char2[j];
            if (sortBy.numeric && Character.isDigit(ch1) && Character.isDigit(ch2) && ch1 != '0' && ch2 != '0') {
                int _i;
                int _j = j + 1;
                for (_i = i + 1; _i < char1.length && Character.isDigit(char1[_i]); ++_i) {
                }
                while (_j < char2.length && Character.isDigit(char2[_j])) {
                    ++_j;
                }
                int len1 = _i - i;
                int len2 = _j - j;
                if (len1 > len2) {
                    if (sortBy.ascending) {
                        return 1;
                    }
                    return -1;
                }
                if (len1 < len2) {
                    if (sortBy.ascending) {
                        return -1;
                    }
                    return 1;
                }
                for (int k = 0; k < len1; ++k) {
                    ch1 = char1[i + k];
                    ch2 = char2[j + k];
                    if (ch1 == ch2) continue;
                    if (sortBy.ascending) {
                        return ch1 - ch2;
                    }
                    return (ch1 - ch2) * -1;
                }
                i = _i - 1;
                j = _j - 1;
                continue;
            }
            if (sortBy.ignoreCase) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            if (ch1 == ch2) continue;
            if (sortBy.ascending) {
                return ch1 - ch2;
            }
            return (ch1 - ch2) * -1;
        }
        if (sortBy.ascending) {
            return char1.length - char2.length;
        }
        return (char1.length - char2.length) * -1;
    }

    private static String getCompareStringForSortby(SortBy sb, String compStr) {
        if (sb.startColumn > compStr.length()) {
            return new String();
        }
        if (sb.endColumn > compStr.length()) {
            return compStr.substring(sb.startColumn, compStr.length());
        }
        return compStr.substring(sb.startColumn, sb.endColumn);
    }

    public class SortBy {
        public int startColumn;
        public int endColumn;
        public boolean ascending;
        public boolean ignoreCase;
        public boolean numeric;
        public boolean trimWhitespace;
        public boolean delDupRange;

        public SortBy(int startColumn, int endColumn, boolean ascending, boolean ignoreCase, boolean numeric, boolean trimWhitespace, boolean delDupRange) {
            this.startColumn = startColumn;
            this.endColumn = endColumn;
            this.ascending = ascending;
            this.ignoreCase = ignoreCase;
            this.numeric = numeric;
            this.trimWhitespace = trimWhitespace;
            this.delDupRange = delDupRange;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("startColumn = ").append(this.startColumn).append(" endColumn = ").append(this.endColumn).append(" ascending = ").append(this.ascending).append(" ignoreCase = ").append(this.ignoreCase).append(" numeric = ").append(this.numeric).append(" trimWhitespace = ").append(this.trimWhitespace).append(" delDupRange = ").append(this.delDupRange);
            return sb.toString();
        }
    }
}

