/*
 * Decompiled with CFR 0.152.
 */
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class BeanShellUtility {
    View view;
    JEditTextArea textArea;
    JEditBuffer buffer;

    public BeanShellUtility(View view) {
        this.view = view;
        this.textArea = view.getTextArea();
        this.buffer = view.getBuffer();
    }

    public int getRow(int bufferPosition) {
        int lineNbr = this.textArea.getLineOfOffset(bufferPosition);
        int startLineOffset = this.textArea.getLineStartOffset(lineNbr);
        return bufferPosition - startLineOffset;
    }

    public static int getRow(View view, int bufferPosition) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.getRow(bufferPosition);
    }

    public int getVisibleRow(int bufferPosition) {
        int lineNbr = this.textArea.getLineOfOffset(bufferPosition);
        return BeanShellUtility.getVisiblePosition(this.buffer.getTabSize(), this.getRow(bufferPosition), this.textArea.getLineText(lineNbr));
    }

    public static int getVisibleRow(View view, int bufferPosition) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.getVisibleRow(bufferPosition);
    }

    public int goToLineRow(int line, int row, boolean select) {
        int caret = this.textArea.getCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(line) + row;
        if (select) {
            this.textArea.extendSelection(caret, newCaret);
        }
        this.textArea.moveCaretPosition(newCaret, true);
        return newCaret;
    }

    public static int goToLineRow(View view, int line, int row, boolean select) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.goToLineRow(line, row, select);
    }

    void selectLine(int lineNbr) {
        this.textArea.setSelection((Selection)new Selection.Range(this.textArea.getLineStartOffset(lineNbr), this.textArea.getLineEndOffset(lineNbr) - 1));
    }

    public static int getVisiblePosition(int tabWidth, int realPos, String line) {
        int delta = 0;
        for (int i = 0; i < realPos && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            int spaceNbr = tabWidth * (1 + (i + delta) / tabWidth) - (i + delta);
            delta += spaceNbr - 1;
        }
        return realPos + delta;
    }

    public String getSelectionLine(int lineNbr, Selection currSelection) {
        int startSelectionOffset = currSelection.getStart(this.buffer, lineNbr);
        int endSelectionOffset = currSelection.getEnd(this.buffer, lineNbr);
        return this.textArea.getText(startSelectionOffset, currSelection.getEnd(this.buffer, lineNbr) - startSelectionOffset);
    }

    public String getSelectionLine(View view, int lineNbr, Selection currSelection) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.getSelectionLine(lineNbr, currSelection);
    }

    public int getSelectionVisibleStartColumn(int lineNbr, Selection currSelection) {
        int startLineOffset = this.textArea.getLineStartOffset(lineNbr);
        int startSelectionOffset = currSelection.getStart(this.buffer, lineNbr);
        return BeanShellUtility.getVisiblePosition(this.buffer.getTabSize(), startSelectionOffset - startLineOffset, this.textArea.getLineText(lineNbr));
    }

    public static int getSelectionVisibleStartColumn(View view, int lineNbr, Selection currSelection) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.getSelectionVisibleStartColumn(lineNbr, currSelection);
    }

    int getSelectionVisibleEndColumn(int lineNbr, Selection currSelection) {
        int startLineOffset = this.textArea.getLineStartOffset(lineNbr);
        int endSelectionOffset = currSelection.getEnd(this.buffer, lineNbr);
        return BeanShellUtility.getVisiblePosition(this.buffer.getTabSize(), endSelectionOffset - startLineOffset, this.textArea.getLineText(lineNbr));
    }

    public static int getSelectionVisibleEndColumn(View view, int lineNbr, Selection currSelection) {
        BeanShellUtility bsu = new BeanShellUtility(view);
        return bsu.getSelectionVisibleEndColumn(lineNbr, currSelection);
    }

    public static String MiscUtilities_createWhiteSpace(int len, int tabSize, int lineOffset) {
        StringBuilder buf = new StringBuilder();
        if (tabSize == 0 || len <= 1) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else {
            int leadingCharLen = lineOffset % tabSize;
            if (len + leadingCharLen >= tabSize) {
                len += leadingCharLen;
            }
            int count = len / tabSize;
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }
}

