/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorList;
import errorlist.ErrorSource;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.ImageIcon;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorGutterIcon
extends TextAreaExtension {
    private EditPane editPane;
    private static final int FOLD_MARKER_SIZE = 12;

    public ErrorGutterIcon(EditPane editPane) {
        this.editPane = editPane;
    }

    public String getToolTipText(int x, int y) {
        ErrorSource[] errorSources = ErrorSource.getErrorSources();
        if (!this.editPane.getBuffer().isLoaded()) {
            return null;
        }
        JEditTextArea textArea = this.editPane.getTextArea();
        int offset = textArea.xyToOffset(x, y);
        if (offset == -1) {
            return null;
        }
        int line = textArea.getLineOfOffset(offset);
        StringBuffer errMsg = new StringBuffer();
        for (int i = 0; i < errorSources.length; ++i) {
            ErrorSource.Error[] lineErrors = errorSources[i].getLineErrors(this.editPane.getBuffer().getSymlinkPath(), line, line);
            if (lineErrors == null) continue;
            errMsg.append("<html>");
            for (int j = 0; j < lineErrors.length; ++j) {
                ErrorSource.Error error = lineErrors[j];
                errMsg.append(error.getErrorMessage());
                errMsg.append("<br>");
                for (String extra : error.getExtraMessages()) {
                    errMsg.append("__");
                    errMsg.append(extra);
                    errMsg.append("<br>");
                }
            }
            errMsg.append("</html>");
        }
        if (errMsg.length() > 0) {
            return errMsg.toString();
        }
        return null;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        ErrorSource[] errorSources = ErrorSource.getErrorSources();
        if (errorSources == null) {
            return;
        }
        for (int i = 0; i < errorSources.length; ++i) {
            ErrorSource.Error[] errors = errorSources[i].getLineErrors(this.editPane.getBuffer().getSymlinkPath(), physicalLine, physicalLine);
            if (errors == null) continue;
            boolean isError = false;
            for (int j = 0; j < errors.length; ++j) {
                if (errors[j].getErrorType() != 0) continue;
                isError = true;
                break;
            }
            JEditTextArea textArea = this.editPane.getTextArea();
            ImageIcon icon = isError ? ErrorList.ERROR_ICON : ErrorList.WARNING_ICON;
            int lineHeight = textArea.getPainter().getFontMetrics().getHeight();
            Point iconPos = new Point((12 - icon.getIconWidth()) / 2, y + (lineHeight - icon.getIconHeight()) / 2);
            gfx.drawImage(icon.getImage(), iconPos.x, iconPos.y, null);
        }
    }
}

