/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.TokenStream;

public class Parser {
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    private String encodedSource;
    ScriptOrFnNode currentScriptOrFn;
    Node.Scope currentScope;
    private int nestingOfWith;
    private Hashtable labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private boolean hasReturnValue;
    private int endFlags;

    public Parser(CompilerEnvirons compilerEnv, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnv;
        this.errorReporter = errorReporter;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnv) {
        return new Decompiler();
    }

    void addStrictWarning(String messageId, String messageArg) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg);
        }
    }

    void addWarning(String messageId, String messageArg) {
        String message = ScriptRuntime.getMessage1(messageId, messageArg);
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        } else {
            this.errorReporter.warning(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        }
    }

    void addError(String messageId) {
        ++this.syntaxErrorCount;
        String message = ScriptRuntime.getMessage0(messageId);
        this.errorReporter.error(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    void addError(String messageId, String messageArg) {
        ++this.syntaxErrorCount;
        String message = ScriptRuntime.getMessage1(messageId, messageArg);
        this.errorReporter.error(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    RuntimeException reportError(String messageId) {
        this.addError(messageId);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int tt = this.currentFlaggedToken;
        if (tt == 0) {
            tt = this.ts.getToken();
            if (tt == 1) {
                while ((tt = this.ts.getToken()) == 1) {
                }
                tt |= 0x10000;
            }
            this.currentFlaggedToken = tt;
        }
        return tt & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int tt = this.peekToken();
        this.consumeToken();
        return tt;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int ttFlagged = this.currentFlaggedToken;
        this.consumeToken();
        return ttFlagged;
    }

    private boolean matchToken(int toMatch) throws IOException {
        int tt = this.peekToken();
        if (tt != toMatch) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int tt = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            tt = 1;
        }
        return tt;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 38) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int toMatch, String messageId) throws IOException, ParserException {
        if (!this.matchToken(toMatch)) {
            this.reportError(messageId);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    private void pushScope(Node node) {
        Node.Scope scopeNode = (Node.Scope)node;
        if (scopeNode.getParent() != null) {
            throw Kit.codeBug();
        }
        scopeNode.setParent(this.currentScope);
        this.currentScope = scopeNode;
    }

    private void popScope() {
        this.currentScope = this.currentScope.getParent();
    }

    private Node enterLoop(Node loopLabel, boolean doPushScope) {
        Node loop = this.nf.createLoopNode(loopLabel, this.ts.getLineno());
        if (this.loopSet == null) {
            this.loopSet = new ObjArray();
            if (this.loopAndSwitchSet == null) {
                this.loopAndSwitchSet = new ObjArray();
            }
        }
        this.loopSet.push(loop);
        this.loopAndSwitchSet.push(loop);
        if (doPushScope) {
            this.pushScope(loop);
        }
        return loop;
    }

    private void exitLoop(boolean doPopScope) {
        this.loopSet.pop();
        this.loopAndSwitchSet.pop();
        if (doPopScope) {
            this.popScope();
        }
    }

    private Node enterSwitch(Node switchSelector, int lineno) {
        Node switchNode = this.nf.createSwitch(switchSelector, lineno);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(switchNode);
        return switchNode;
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.pop();
    }

    public ScriptOrFnNode parse(String sourceString, String sourceURI, int lineno) {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, null, sourceString, lineno);
        try {
            return this.parse();
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader sourceReader, String sourceURI, int lineno) throws IOException {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, sourceReader, null, lineno);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        this.currentScope = this.currentScriptOrFn;
        int sourceStartOffset = this.decompiler.getCurrentOffset();
        this.encodedSource = null;
        this.decompiler.addToken(133);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int baseLineno = this.ts.getLineno();
        Node pn = this.nf.createLeaf(126);
        try {
            int tt;
            while ((tt = this.peekToken()) > 0) {
                Node n;
                block8: {
                    if (tt == 106) {
                        this.consumeToken();
                        try {
                            n = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block8;
                        }
                        catch (ParserException e) {
                            break;
                        }
                    }
                    n = this.statement();
                }
                this.nf.addChildToBack(pn, n);
            }
        }
        catch (StackOverflowError ex) {
            String msg = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(msg, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String msg = String.valueOf(this.syntaxErrorCount);
            msg = ScriptRuntime.getMessage1("msg.got.syntax.errors", msg);
            throw this.errorReporter.runtimeError(msg, this.sourceURI, baseLineno, null, 0);
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(baseLineno);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        int sourceEndOffset = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(sourceStartOffset, sourceEndOffset);
        this.nf.initScript(this.currentScriptOrFn, pn);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node pn;
        block10: {
            ++this.nestingOfFunction;
            pn = this.nf.createBlock(this.ts.getLineno());
            try {
                while (true) {
                    Node n;
                    int tt = this.peekToken();
                    switch (tt) {
                        case -1: 
                        case 0: 
                        case 83: {
                            break block10;
                        }
                        case 106: {
                            this.consumeToken();
                            n = this.function(1);
                            break;
                        }
                        default: {
                            n = this.statement();
                        }
                    }
                    this.nf.addChildToBack(pn, n);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int functionType) throws IOException, ParserException {
        int functionSourceEnd;
        Node body;
        String name;
        int syntheticType = functionType;
        int baseLineno = this.ts.getLineno();
        int functionSourceStart = this.decompiler.markFunctionStart(functionType);
        Node memberExprNode = null;
        if (this.matchToken(38)) {
            name = this.ts.getString();
            this.decompiler.addName(name);
            if (!this.matchToken(84)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node memberExprHead = this.nf.createName(name);
                    name = "";
                    memberExprNode = this.memberExprTail(false, memberExprHead);
                }
                this.mustMatchToken(84, "msg.no.paren.parms");
            }
        } else if (this.matchToken(84)) {
            name = "";
        } else {
            name = "";
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                memberExprNode = this.memberExpr(false);
            }
            this.mustMatchToken(84, "msg.no.paren.parms");
        }
        if (memberExprNode != null) {
            syntheticType = 2;
        }
        if (syntheticType != 2 && name.length() > 0) {
            this.defineSymbol(106, name);
        }
        boolean nested = this.insideFunction();
        FunctionNode fnNode = this.nf.createFunction(name);
        if (nested || this.nestingOfWith > 0) {
            fnNode.itsIgnoreDynamicScope = true;
        }
        int functionIndex = this.currentScriptOrFn.addFunction(fnNode);
        ScriptOrFnNode savedScriptOrFn = this.currentScriptOrFn;
        this.currentScriptOrFn = fnNode;
        Node.Scope savedCurrentScope = this.currentScope;
        this.currentScope = fnNode;
        int savedNestingOfWith = this.nestingOfWith;
        this.nestingOfWith = 0;
        Hashtable savedLabelSet = this.labelSet;
        this.labelSet = null;
        ObjArray savedLoopSet = this.loopSet;
        this.loopSet = null;
        ObjArray savedLoopAndSwitchSet = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        boolean savedHasReturnValue = this.hasReturnValue;
        int savedFunctionEndFlags = this.endFlags;
        try {
            this.decompiler.addToken(84);
            if (!this.matchToken(85)) {
                boolean first = true;
                do {
                    if (!first) {
                        this.decompiler.addToken(86);
                    }
                    first = false;
                    this.mustMatchToken(38, "msg.no.parm");
                    String s = this.ts.getString();
                    this.defineSymbol(84, s);
                    this.decompiler.addName(s);
                } while (this.matchToken(86));
                this.mustMatchToken(85, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(85);
            this.mustMatchToken(82, "msg.no.brace.body");
            this.decompiler.addEOL(82);
            body = this.parseFunctionBody();
            this.mustMatchToken(83, "msg.no.brace.after.body");
            if (this.compilerEnv.isStrictMode() && !body.hasConsistentReturnUsage()) {
                String msg = name.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(msg, name);
            }
            if (syntheticType == 2 && name.length() > 0 && this.currentScope.getSymbol(name) == null) {
                this.defineSymbol(106, name);
            }
            this.decompiler.addToken(83);
            functionSourceEnd = this.decompiler.markFunctionEnd(functionSourceStart);
            if (functionType != 2) {
                int tt;
                if (this.compilerEnv.getLanguageVersion() >= 120 && (tt = this.peekTokenOrEOL()) == 106) {
                    this.reportError("msg.no.semi.stmt");
                }
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.hasReturnValue = savedHasReturnValue;
            this.endFlags = savedFunctionEndFlags;
            this.loopAndSwitchSet = savedLoopAndSwitchSet;
            this.loopSet = savedLoopSet;
            this.labelSet = savedLabelSet;
            this.nestingOfWith = savedNestingOfWith;
            this.currentScriptOrFn = savedScriptOrFn;
            this.currentScope = savedCurrentScope;
        }
        fnNode.setEncodedSourceBounds(functionSourceStart, functionSourceEnd);
        fnNode.setSourceName(this.sourceURI);
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.ts.getLineno());
        Node pn = this.nf.initFunction(fnNode, functionIndex, body, syntheticType);
        if (memberExprNode != null) {
            pn = this.nf.createAssignment(87, memberExprNode, pn);
            if (functionType != 2) {
                pn = this.nf.createExprStatementNoReturn(pn, baseLineno);
            }
        }
        return pn;
    }

    private Node statements(Node scope) throws IOException {
        int tt;
        Node pn;
        Node node = pn = scope != null ? scope : this.nf.createBlock(this.ts.getLineno());
        while ((tt = this.peekToken()) > 0 && tt != 83) {
            this.nf.addChildToBack(pn, this.statement());
        }
        return pn;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(84, "msg.no.paren.cond");
        this.decompiler.addToken(84);
        Node pn = this.expr(false);
        this.mustMatchToken(85, "msg.no.paren.after.cond");
        this.decompiler.addToken(85);
        if (pn.getProp(19) == null && (pn.getType() == 8 || pn.getType() == 34 || pn.getType() == 36)) {
            this.addStrictWarning("msg.equal.as.assign", "");
        }
        return pn;
    }

    private Node matchJumpLabelName() throws IOException, ParserException {
        Node label = null;
        int tt = this.peekTokenOrEOL();
        if (tt == 38) {
            this.consumeToken();
            String name = this.ts.getString();
            this.decompiler.addName(name);
            if (this.labelSet != null) {
                label = (Node)this.labelSet.get(name);
            }
            if (label == null) {
                this.reportError("msg.undef.label");
            }
        }
        return label;
    }

    private Node statement() throws IOException {
        try {
            Node pn = this.statementHelper(null);
            if (pn != null) {
                if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "");
                }
                return pn;
            }
        }
        catch (ParserException e) {
            // empty catch block
        }
        int lineno = this.ts.getLineno();
        block5: while (true) {
            int tt = this.peekTokenOrEOL();
            this.consumeToken();
            switch (tt) {
                case -1: 
                case 0: 
                case 1: 
                case 79: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.nf.createExprStatement(this.nf.createName("error"), lineno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node statementHelper(Node statementLabel) throws IOException, ParserException {
        Node pn = null;
        int tt = this.peekToken();
        switch (tt) {
            case 109: {
                this.consumeToken();
                this.decompiler.addToken(109);
                int lineno = this.ts.getLineno();
                Node cond = this.condition();
                this.decompiler.addEOL(82);
                Node ifTrue = this.statement();
                Node ifFalse = null;
                if (this.matchToken(110)) {
                    this.decompiler.addToken(83);
                    this.decompiler.addToken(110);
                    this.decompiler.addEOL(82);
                    ifFalse = this.statement();
                }
                this.decompiler.addEOL(83);
                pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno);
                return pn;
            }
            case 111: {
                this.consumeToken();
                this.decompiler.addToken(111);
                int lineno = this.ts.getLineno();
                this.mustMatchToken(84, "msg.no.paren.switch");
                this.decompiler.addToken(84);
                pn = this.enterSwitch(this.expr(false), lineno);
                try {
                    this.mustMatchToken(85, "msg.no.paren.after.switch");
                    this.decompiler.addToken(85);
                    this.mustMatchToken(82, "msg.no.brace.switch");
                    this.decompiler.addEOL(82);
                    boolean hasDefault = false;
                    block51: while (true) {
                        Node caseExpression;
                        tt = this.nextToken();
                        switch (tt) {
                            case 83: {
                                break block51;
                            }
                            case 112: {
                                this.decompiler.addToken(112);
                                caseExpression = this.expr(false);
                                this.mustMatchToken(100, "msg.no.colon.case");
                                this.decompiler.addEOL(100);
                                break;
                            }
                            case 113: {
                                if (hasDefault) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(113);
                                hasDefault = true;
                                caseExpression = null;
                                this.mustMatchToken(100, "msg.no.colon.case");
                                this.decompiler.addEOL(100);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block51;
                            }
                        }
                        Node block = this.nf.createLeaf(126);
                        while ((tt = this.peekToken()) != 83 && tt != 112 && tt != 113 && tt != 0) {
                            this.nf.addChildToBack(block, this.statement());
                        }
                        this.nf.addSwitchCase(pn, caseExpression, block);
                    }
                    this.decompiler.addEOL(83);
                    this.nf.closeSwitch(pn);
                }
                finally {
                    this.exitSwitch();
                }
                return pn;
            }
            case 114: {
                this.consumeToken();
                this.decompiler.addToken(114);
                Node loop = this.enterLoop(statementLabel, true);
                try {
                    Node cond = this.condition();
                    this.decompiler.addEOL(82);
                    Node body = this.statement();
                    this.decompiler.addEOL(83);
                    pn = this.nf.createWhile(loop, cond, body);
                }
                finally {
                    this.exitLoop(true);
                }
                return pn;
            }
            case 115: {
                this.consumeToken();
                this.decompiler.addToken(115);
                this.decompiler.addEOL(82);
                Node loop = this.enterLoop(statementLabel, true);
                try {
                    Node body = this.statement();
                    this.decompiler.addToken(83);
                    this.mustMatchToken(114, "msg.no.while.do");
                    this.decompiler.addToken(114);
                    Node cond = this.condition();
                    pn = this.nf.createDoWhile(loop, body, cond);
                }
                finally {
                    this.exitLoop(true);
                }
                this.matchToken(79);
                this.decompiler.addEOL(79);
                return pn;
            }
            case 116: {
                this.consumeToken();
                boolean isForEach = false;
                this.decompiler.addToken(116);
                Node loop = this.enterLoop(statementLabel, true);
                try {
                    Node cond;
                    Node init;
                    Node incr = null;
                    if (this.matchToken(38)) {
                        this.decompiler.addName(this.ts.getString());
                        if (this.ts.getString().equals("each")) {
                            isForEach = true;
                        } else {
                            this.reportError("msg.no.paren.for");
                        }
                    }
                    this.mustMatchToken(84, "msg.no.paren.for");
                    this.decompiler.addToken(84);
                    tt = this.peekToken();
                    if (tt == 79) {
                        init = this.nf.createLeaf(125);
                    } else if (tt == 119 || tt == 150) {
                        this.consumeToken();
                        this.decompiler.addToken(tt);
                        init = this.variables(true, true, tt);
                    } else {
                        init = this.expr(true);
                    }
                    if (this.matchToken(51)) {
                        this.decompiler.addToken(51);
                        cond = this.expr(false);
                    } else {
                        this.mustMatchToken(79, "msg.no.semi.for");
                        this.decompiler.addToken(79);
                        cond = this.peekToken() == 79 ? this.nf.createLeaf(125) : this.expr(false);
                        this.mustMatchToken(79, "msg.no.semi.for.cond");
                        this.decompiler.addToken(79);
                        incr = this.peekToken() == 85 ? this.nf.createLeaf(125) : this.expr(false);
                    }
                    this.mustMatchToken(85, "msg.no.paren.for.ctrl");
                    this.decompiler.addToken(85);
                    this.decompiler.addEOL(82);
                    Node body = this.statement();
                    this.decompiler.addEOL(83);
                    pn = incr == null ? this.nf.createForIn(loop, init, cond, body, isForEach) : this.nf.createFor(loop, init, cond, incr, body);
                }
                finally {
                    this.exitLoop(true);
                }
                return pn;
            }
            case 78: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                Node catchblocks = null;
                Node finallyblock = null;
                this.decompiler.addToken(78);
                if (this.peekToken() != 82) {
                    this.reportError("msg.no.brace.try");
                }
                this.decompiler.addEOL(82);
                Node tryblock = this.statement();
                this.decompiler.addEOL(83);
                catchblocks = this.nf.createLeaf(126);
                boolean sawDefaultCatch = false;
                int peek = this.peekToken();
                if (peek == 121) {
                    while (this.matchToken(121)) {
                        if (sawDefaultCatch) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(121);
                        this.mustMatchToken(84, "msg.no.paren.catch");
                        this.decompiler.addToken(84);
                        this.mustMatchToken(38, "msg.bad.catchcond");
                        String varName = this.ts.getString();
                        this.decompiler.addName(varName);
                        Node catchCond = null;
                        if (this.matchToken(109)) {
                            this.decompiler.addToken(109);
                            catchCond = this.expr(false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        this.mustMatchToken(85, "msg.bad.catchcond");
                        this.decompiler.addToken(85);
                        this.mustMatchToken(82, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(82);
                        this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, catchCond, this.statements(null), this.ts.getLineno()));
                        this.mustMatchToken(83, "msg.no.brace.after.body");
                        this.decompiler.addEOL(83);
                    }
                } else if (peek != 122) {
                    this.mustMatchToken(122, "msg.try.no.catchfinally");
                }
                if (this.matchToken(122)) {
                    this.decompiler.addToken(122);
                    this.decompiler.addEOL(82);
                    finallyblock = this.statement();
                    this.decompiler.addEOL(83);
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno);
                return pn;
            }
            case 49: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(49);
                pn = this.nf.createThrow(this.expr(false), lineno);
                break;
            }
            case 117: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(117);
                Node breakStatement = this.matchJumpLabelName();
                if (breakStatement == null) {
                    if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                        this.reportError("msg.bad.break");
                        return null;
                    }
                    breakStatement = (Node)this.loopAndSwitchSet.peek();
                }
                pn = this.nf.createBreak(breakStatement, lineno);
                break;
            }
            case 118: {
                Node loop;
                this.consumeToken();
                int lineno = this.ts.getLineno();
                this.decompiler.addToken(118);
                Node label = this.matchJumpLabelName();
                if (label == null) {
                    if (this.loopSet == null || this.loopSet.size() == 0) {
                        this.reportError("msg.continue.outside");
                        return null;
                    }
                    loop = (Node)this.loopSet.peek();
                } else {
                    loop = this.nf.getLabelLoop(label);
                    if (loop == null) {
                        this.reportError("msg.continue.nonloop");
                        return null;
                    }
                }
                pn = this.nf.createContinue(loop, lineno);
                break;
            }
            case 120: {
                Node body;
                this.consumeToken();
                this.decompiler.addToken(120);
                int lineno = this.ts.getLineno();
                this.mustMatchToken(84, "msg.no.paren.with");
                this.decompiler.addToken(84);
                Node obj = this.expr(false);
                this.mustMatchToken(85, "msg.no.paren.after.with");
                this.decompiler.addToken(85);
                this.decompiler.addEOL(82);
                ++this.nestingOfWith;
                try {
                    body = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(83);
                pn = this.nf.createWith(obj, body, lineno);
                return pn;
            }
            case 119: 
            case 151: {
                this.consumeToken();
                this.decompiler.addToken(tt);
                pn = this.variables(false, true, tt);
                break;
            }
            case 150: {
                this.consumeToken();
                this.decompiler.addToken(150);
                pn = this.peekToken() == 84 ? this.let(true) : this.variables(false, true, tt);
                return pn;
            }
            case 4: 
            case 70: {
                pn = this.returnOrYield(tt, false);
                break;
            }
            case 157: {
                this.consumeToken();
                this.decompiler.addToken(157);
                pn = this.nf.createDebugger(this.ts.getLineno());
                break;
            }
            case 82: {
                this.consumeToken();
                if (statementLabel != null) {
                    this.decompiler.addToken(82);
                }
                Node scope = this.nf.createScopeNode(126, this.ts.getLineno());
                this.pushScope(scope);
                try {
                    this.statements(scope);
                    this.mustMatchToken(83, "msg.no.brace.block");
                    if (statementLabel != null) {
                        this.decompiler.addEOL(83);
                    }
                    Node obj = scope;
                    return obj;
                }
                finally {
                    this.popScope();
                }
            }
            case -1: 
            case 79: {
                this.consumeToken();
                pn = this.nf.createLeaf(125);
                return pn;
            }
            case 106: {
                this.consumeToken();
                pn = this.function(3);
                return pn;
            }
            case 113: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(113);
                int nsLine = this.ts.getLineno();
                if (!this.matchToken(38) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(38) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(87)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(87);
                Node expr = this.expr(false);
                pn = this.nf.createDefaultNamespace(expr, nsLine);
                break;
            }
            case 38: {
                boolean firstLabel;
                int lineno = this.ts.getLineno();
                String name = this.ts.getString();
                this.setCheckForLabel();
                pn = this.expr(false);
                if (pn.getType() != 127) {
                    pn = this.nf.createExprStatement(pn, lineno);
                    break;
                }
                if (this.peekToken() != 100) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(name);
                this.decompiler.addEOL(100);
                if (this.labelSet == null) {
                    this.labelSet = new Hashtable();
                } else if (this.labelSet.containsKey(name)) {
                    this.reportError("msg.dup.label");
                }
                if (statementLabel == null) {
                    firstLabel = true;
                    statementLabel = pn;
                } else {
                    firstLabel = false;
                }
                this.labelSet.put(name, statementLabel);
                try {
                    pn = this.statementHelper(statementLabel);
                }
                finally {
                    this.labelSet.remove(name);
                }
                if (firstLabel) {
                    pn = this.nf.createLabeledStatement(statementLabel, pn);
                }
                return pn;
            }
            default: {
                int lineno = this.ts.getLineno();
                pn = this.expr(false);
                pn = this.nf.createExprStatement(pn, lineno);
                break;
            }
        }
        int ttFlagged = this.peekFlaggedToken();
        switch (ttFlagged & 0xFFFF) {
            case 79: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 83: {
                break;
            }
            default: {
                if ((ttFlagged & 0x10000) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(79);
        return pn;
    }

    private static final boolean nowAllSet(int before, int after, int mask) {
        return (before & mask) != mask && (after & mask) == mask;
    }

    private Node returnOrYield(int tt, boolean exprContext) throws IOException, ParserException {
        Node ret;
        Node e;
        if (!this.insideFunction()) {
            this.reportError(tt == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        this.decompiler.addToken(tt);
        int lineno = this.ts.getLineno();
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 70: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                e = null;
                break;
            }
            default: {
                e = this.expr(false);
            }
        }
        int before = this.endFlags;
        if (tt == 4) {
            if (e == null) {
                this.endFlags |= 2;
            } else {
                this.endFlags |= 4;
                this.hasReturnValue = true;
            }
            ret = this.nf.createReturn(e, lineno);
            if (Parser.nowAllSet(before, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "");
            }
        } else {
            this.endFlags |= 8;
            ret = this.nf.createYield(e, lineno);
            if (!exprContext) {
                ret = new Node(130, ret, lineno);
            }
        }
        if (Parser.nowAllSet(before, this.endFlags, 12)) {
            String name = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (name.length() == 0) {
                this.addError("msg.anon.generator.returns", "");
            } else {
                this.addError("msg.generator.returns", name);
            }
        }
        return ret;
    }

    private Node variables(boolean inFor, boolean inStatement, int declType) throws IOException, ParserException {
        Node result = this.nf.createVariables(inStatement ? declType : 86, this.ts.getLineno());
        boolean first = true;
        do {
            this.mustMatchToken(38, "msg.bad.var");
            String s = this.ts.getString();
            if (!first) {
                this.decompiler.addToken(86);
            }
            first = false;
            this.decompiler.addName(s);
            this.defineSymbol(declType, s);
            Node init = null;
            if (this.matchToken(87)) {
                this.decompiler.addToken(87);
                init = this.assignExpr(inFor);
            }
            if (inStatement) {
                Node name = this.nf.createName(s);
                if (init != null) {
                    this.nf.addChildToBack(name, init);
                }
                this.nf.addChildToBack(result, name);
                continue;
            }
            if (init == null) continue;
            Node string = this.nf.createString(s);
            string.setScope(this.currentScope);
            this.nf.addChildToBack(result, this.nf.createBinary(55, string, init));
        } while (this.matchToken(86));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node let(boolean isStatement) throws IOException, ParserException {
        this.mustMatchToken(84, "msg.no.paren.after.let");
        this.decompiler.addToken(84);
        Node result = this.nf.createScopeNode(150, this.ts.getLineno());
        this.pushScope(result);
        try {
            Node vars = this.variables(false, true, 150);
            this.nf.addChildToBack(result, vars);
            this.mustMatchToken(85, "msg.no.paren.let");
            this.decompiler.addToken(85);
            if (isStatement && this.peekToken() == 82) {
                this.consumeToken();
                this.decompiler.addEOL(82);
                this.nf.addChildToBack(result, this.statements(null));
                this.mustMatchToken(83, "msg.no.curly.let");
                this.decompiler.addToken(83);
            } else {
                result.setType(155);
                this.nf.addChildToBack(result, this.expr(false));
                if (isStatement) {
                    result = this.nf.createExprStatement(result, this.ts.getLineno());
                }
            }
        }
        finally {
            this.popScope();
        }
        return result;
    }

    void defineSymbol(int declType, String name) {
        Node.Scope definingScope = this.currentScope.getDefiningScope(name);
        Node.Symbol symbol = definingScope != null ? definingScope.getSymbol(name) : null;
        boolean error = false;
        if (symbol != null && (symbol.declType == 151 || declType == 151)) {
            error = true;
        } else {
            switch (declType) {
                case 150: {
                    if (symbol != null && definingScope == this.currentScope) {
                        error = symbol.declType == 150;
                    }
                    this.currentScope.putSymbol(name, new Node.Symbol(declType, name));
                    break;
                }
                case 106: 
                case 119: 
                case 151: {
                    if (symbol != null) {
                        if (symbol.declType == 119) {
                            this.addStrictWarning("msg.var.redecl", name);
                            break;
                        }
                        if (symbol.declType != 84) break;
                        this.addStrictWarning("msg.var.hides.arg", name);
                        break;
                    }
                    this.currentScriptOrFn.putSymbol(name, new Node.Symbol(declType, name));
                    break;
                }
                case 84: {
                    if (symbol != null) {
                        this.addWarning("msg.dup.parms", name);
                    }
                    this.currentScriptOrFn.putSymbol(name, new Node.Symbol(declType, name));
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
        }
        if (error) {
            this.addError(symbol.declType == 151 ? "msg.const.redecl" : (symbol.declType == 150 ? "msg.let.redecl" : (symbol.declType == 119 ? "msg.var.redecl" : (symbol.declType == 106 ? "msg.fn.redecl" : "msg.parm.redecl"))), name);
        }
    }

    private Node expr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.assignExpr(inForInit);
        while (this.matchToken(86)) {
            this.decompiler.addToken(86);
            if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "");
            }
            if (this.peekToken() == 70) {
                this.reportError("msg.yield.parenthesized");
            }
            pn = this.nf.createBinary(86, pn, this.assignExpr(inForInit));
        }
        return pn;
    }

    private Node assignExpr(boolean inForInit) throws IOException, ParserException {
        int tt = this.peekToken();
        if (tt == 70) {
            this.consumeToken();
            return this.returnOrYield(tt, true);
        }
        Node pn = this.condExpr(inForInit);
        tt = this.peekToken();
        if (87 <= tt && tt <= 98) {
            this.consumeToken();
            this.decompiler.addToken(tt);
            pn = this.nf.createAssignment(tt, pn, this.assignExpr(inForInit));
        }
        return pn;
    }

    private Node condExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.orExpr(inForInit);
        if (this.matchToken(99)) {
            this.decompiler.addToken(99);
            Node ifTrue = this.assignExpr(false);
            this.mustMatchToken(100, "msg.no.colon.cond");
            this.decompiler.addToken(100);
            Node ifFalse = this.assignExpr(inForInit);
            return this.nf.createCondExpr(pn, ifTrue, ifFalse);
        }
        return pn;
    }

    private Node orExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.andExpr(inForInit);
        if (this.matchToken(101)) {
            this.decompiler.addToken(101);
            pn = this.nf.createBinary(101, pn, this.orExpr(inForInit));
        }
        return pn;
    }

    private Node andExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitOrExpr(inForInit);
        if (this.matchToken(102)) {
            this.decompiler.addToken(102);
            pn = this.nf.createBinary(102, pn, this.andExpr(inForInit));
        }
        return pn;
    }

    private Node bitOrExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitXorExpr(inForInit);
        while (this.matchToken(9)) {
            this.decompiler.addToken(9);
            pn = this.nf.createBinary(9, pn, this.bitXorExpr(inForInit));
        }
        return pn;
    }

    private Node bitXorExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitAndExpr(inForInit);
        while (this.matchToken(10)) {
            this.decompiler.addToken(10);
            pn = this.nf.createBinary(10, pn, this.bitAndExpr(inForInit));
        }
        return pn;
    }

    private Node bitAndExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.eqExpr(inForInit);
        while (this.matchToken(11)) {
            this.decompiler.addToken(11);
            pn = this.nf.createBinary(11, pn, this.eqExpr(inForInit));
        }
        return pn;
    }

    private Node eqExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.relExpr(inForInit);
        block9: while (true) {
            int tt = this.peekToken();
            switch (tt) {
                case 12: 
                case 13: 
                case 45: 
                case 46: {
                    this.consumeToken();
                    int decompilerToken = tt;
                    int parseToken = tt;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (tt) {
                            case 12: {
                                parseToken = 45;
                                break;
                            }
                            case 13: {
                                parseToken = 46;
                                break;
                            }
                            case 45: {
                                decompilerToken = 12;
                                break;
                            }
                            case 46: {
                                decompilerToken = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(decompilerToken);
                    pn = this.nf.createBinary(parseToken, pn, this.relExpr(inForInit));
                    continue block9;
                }
            }
            break;
        }
        return pn;
    }

    private Node relExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.shiftExpr();
        block4: while (true) {
            int tt = this.peekToken();
            switch (tt) {
                case 51: {
                    if (inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 52: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        return pn;
    }

    private Node shiftExpr() throws IOException, ParserException {
        Node pn = this.addExpr();
        block3: while (true) {
            int tt = this.peekToken();
            switch (tt) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Node addExpr() throws IOException, ParserException {
        int tt;
        Node pn = this.mulExpr();
        while ((tt = this.peekToken()) == 21 || tt == 22) {
            this.consumeToken();
            this.decompiler.addToken(tt);
            pn = this.nf.createBinary(tt, pn, this.mulExpr());
        }
        return pn;
    }

    private Node mulExpr() throws IOException, ParserException {
        Node pn = this.unaryExpr();
        block3: while (true) {
            int tt = this.peekToken();
            switch (tt) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int tt = this.peekToken();
        switch (tt) {
            case 26: 
            case 27: 
            case 32: 
            case 123: {
                this.consumeToken();
                this.decompiler.addToken(tt);
                return this.nf.createUnary(tt, this.unaryExpr());
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.nf.createUnary(28, this.unaryExpr());
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr());
            }
            case 103: 
            case 104: {
                this.consumeToken();
                this.decompiler.addToken(tt);
                return this.nf.createIncDec(tt, false, this.memberExpr(true));
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.nf.createUnary(31, this.unaryExpr());
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node pn = this.xmlInitializer();
                    return this.memberExprTail(true, pn);
                }
            }
            default: {
                Node pn = this.memberExpr(true);
                tt = this.peekTokenOrEOL();
                if (tt == 103 || tt == 104) {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    return this.nf.createIncDec(tt, true, pn);
                }
                return pn;
            }
        }
        return this.nf.createName("error");
    }

    private Node xmlInitializer() throws IOException {
        int tt = this.ts.getFirstXMLToken();
        if (tt != 142 && tt != 145) {
            this.reportError("msg.syntax");
            return null;
        }
        Node pnXML = this.nf.createLeaf(30);
        String xml = this.ts.getString();
        boolean fAnonymous = xml.trim().startsWith("<>");
        Node pn = this.nf.createName(fAnonymous ? "XMLList" : "XML");
        this.nf.addChildToBack(pnXML, pn);
        pn = null;
        while (true) {
            switch (tt) {
                case 142: {
                    xml = this.ts.getString();
                    this.decompiler.addName(xml);
                    this.mustMatchToken(82, "msg.syntax");
                    this.decompiler.addToken(82);
                    Node expr = this.peekToken() == 83 ? this.nf.createString("") : this.expr(false);
                    this.mustMatchToken(83, "msg.syntax");
                    this.decompiler.addToken(83);
                    pn = pn == null ? this.nf.createString(xml) : this.nf.createBinary(21, pn, this.nf.createString(xml));
                    int nodeType = this.ts.isXMLAttribute() ? 72 : 73;
                    expr = this.nf.createUnary(nodeType, expr);
                    pn = this.nf.createBinary(21, pn, expr);
                    break;
                }
                case 145: {
                    xml = this.ts.getString();
                    this.decompiler.addName(xml);
                    pn = pn == null ? this.nf.createString(xml) : this.nf.createBinary(21, pn, this.nf.createString(xml));
                    this.nf.addChildToBack(pnXML, pn);
                    return pnXML;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            tt = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node listNode) throws IOException, ParserException {
        boolean matched = this.matchToken(85);
        if (!matched) {
            boolean first = true;
            do {
                if (!first) {
                    this.decompiler.addToken(86);
                }
                first = false;
                if (this.peekToken() == 70) {
                    this.reportError("msg.yield.parenthesized");
                }
                this.nf.addChildToBack(listNode, this.assignExpr(false));
            } while (this.matchToken(86));
            this.mustMatchToken(85, "msg.no.paren.arg");
        }
        this.decompiler.addToken(85);
    }

    private Node memberExpr(boolean allowCallSyntax) throws IOException, ParserException {
        Node pn;
        int tt = this.peekToken();
        if (tt == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            pn = this.nf.createCallOrNew(30, this.memberExpr(false));
            if (this.matchToken(84)) {
                this.decompiler.addToken(84);
                this.argumentList(pn);
            }
            if ((tt = this.peekToken()) == 82) {
                this.nf.addChildToBack(pn, this.primaryExpr());
            }
        } else {
            pn = this.primaryExpr();
        }
        return this.memberExprTail(allowCallSyntax, pn);
    }

    private Node memberExprTail(boolean allowCallSyntax, Node pn) throws IOException, ParserException {
        block12: while (true) {
            int tt = this.peekToken();
            block0 : switch (tt) {
                case 105: 
                case 140: {
                    String s;
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    int memberTypeFlags = 0;
                    if (tt == 140) {
                        this.mustHaveXML();
                        memberTypeFlags = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(38, "msg.no.name.after.dot");
                        s = this.ts.getString();
                        this.decompiler.addName(s);
                        pn = this.nf.createPropertyGet(pn, null, s, memberTypeFlags);
                        break;
                    }
                    tt = this.nextToken();
                    switch (tt) {
                        case 49: {
                            this.decompiler.addName("throw");
                            pn = this.propertyName(pn, "throw", memberTypeFlags);
                            break block0;
                        }
                        case 38: {
                            s = this.ts.getString();
                            this.decompiler.addName(s);
                            pn = this.propertyName(pn, s, memberTypeFlags);
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            pn = this.propertyName(pn, "*", memberTypeFlags);
                            break block0;
                        }
                        case 144: {
                            this.decompiler.addToken(144);
                            pn = this.attributeAccess(pn, memberTypeFlags);
                            break block0;
                        }
                    }
                    this.reportError("msg.no.name.after.dot");
                    break;
                }
                case 143: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(143);
                    pn = this.nf.createDotQuery(pn, this.expr(false), this.ts.getLineno());
                    this.mustMatchToken(85, "msg.no.paren");
                    this.decompiler.addToken(85);
                    break;
                }
                case 80: {
                    this.consumeToken();
                    this.decompiler.addToken(80);
                    pn = this.nf.createElementGet(pn, null, this.expr(false), 0);
                    this.mustMatchToken(81, "msg.no.bracket.index");
                    this.decompiler.addToken(81);
                    break;
                }
                case 84: {
                    if (!allowCallSyntax) break block12;
                    this.consumeToken();
                    this.decompiler.addToken(84);
                    pn = this.nf.createCallOrNew(37, pn);
                    this.argumentList(pn);
                    break;
                }
                default: {
                    break block12;
                }
            }
        }
        return pn;
    }

    private Node attributeAccess(Node pn, int memberTypeFlags) throws IOException {
        memberTypeFlags |= 2;
        int tt = this.nextToken();
        switch (tt) {
            case 38: {
                String s = this.ts.getString();
                this.decompiler.addName(s);
                pn = this.propertyName(pn, s, memberTypeFlags);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                pn = this.propertyName(pn, "*", memberTypeFlags);
                break;
            }
            case 80: {
                this.decompiler.addToken(80);
                pn = this.nf.createElementGet(pn, null, this.expr(false), memberTypeFlags);
                this.mustMatchToken(81, "msg.no.bracket.index");
                this.decompiler.addToken(81);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                pn = this.nf.createPropertyGet(pn, null, "?", memberTypeFlags);
            }
        }
        return pn;
    }

    private Node propertyName(Node pn, String name, int memberTypeFlags) throws IOException, ParserException {
        String namespace = null;
        if (this.matchToken(141)) {
            this.decompiler.addToken(141);
            namespace = name;
            int tt = this.nextToken();
            switch (tt) {
                case 38: {
                    name = this.ts.getString();
                    this.decompiler.addName(name);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    name = "*";
                    break;
                }
                case 80: {
                    this.decompiler.addToken(80);
                    pn = this.nf.createElementGet(pn, namespace, this.expr(false), memberTypeFlags);
                    this.mustMatchToken(81, "msg.no.bracket.index");
                    this.decompiler.addToken(81);
                    return pn;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    name = "?";
                }
            }
        }
        pn = this.nf.createPropertyGet(pn, namespace, name, memberTypeFlags);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayComprehension(String arrayName, Node expr) throws IOException, ParserException {
        Node body;
        if (this.nextToken() != 116) {
            throw Kit.codeBug();
        }
        this.decompiler.addName(" ");
        this.decompiler.addToken(116);
        boolean isForEach = false;
        if (this.matchToken(38)) {
            this.decompiler.addName(this.ts.getString());
            if (this.ts.getString().equals("each")) {
                isForEach = true;
            } else {
                this.reportError("msg.no.paren.for");
            }
        }
        this.mustMatchToken(84, "msg.no.paren.for");
        this.decompiler.addToken(84);
        Node init = null;
        int tt = this.peekToken();
        if (tt == 80 || tt == 82) {
            throw Kit.codeBug();
        }
        if (tt == 38) {
            this.consumeToken();
            this.decompiler.addName(this.ts.getString());
            init = this.nf.createName(this.ts.getString());
            this.defineSymbol(150, this.ts.getString());
        } else {
            this.reportError("msg.bad.var");
        }
        this.mustMatchToken(51, "msg.in.after.for.name");
        this.decompiler.addToken(51);
        Node iterator = this.expr(false);
        this.mustMatchToken(85, "msg.no.paren.for.ctrl");
        this.decompiler.addToken(85);
        tt = this.peekToken();
        if (tt == 116) {
            body = this.arrayComprehension(arrayName, expr);
        } else {
            Node call = this.nf.createCallOrNew(37, this.nf.createPropertyGet(this.nf.createName(arrayName), null, "push", 0));
            call.addChildToBack(expr);
            body = new Node(130, call, expr, this.ts.getLineno());
            if (tt == 109) {
                this.consumeToken();
                this.decompiler.addToken(109);
                int lineno = this.ts.getLineno();
                Node cond = this.condition();
                body = this.nf.createIf(cond, body, null, lineno);
            } else {
                this.mustMatchToken(81, "msg.no.bracket.arg");
                this.decompiler.addToken(81);
            }
        }
        Node loop = this.enterLoop(null, false);
        try {
            Node node = this.nf.createForIn(loop, init, iterator, body, isForEach);
            return node;
        }
        finally {
            this.exitLoop(false);
        }
    }

    private Node primaryExpr() throws IOException, ParserException {
        int ttFlagged = this.nextFlaggedToken();
        int tt = ttFlagged & 0xFFFF;
        switch (tt) {
            case 106: {
                return this.function(2);
            }
            case 80: {
                ObjArray elems = new ObjArray();
                int skipCount = 0;
                this.decompiler.addToken(80);
                boolean after_lb_or_comma = true;
                while (true) {
                    if ((tt = this.peekToken()) == 86) {
                        this.consumeToken();
                        this.decompiler.addToken(86);
                        if (!after_lb_or_comma) {
                            after_lb_or_comma = true;
                            continue;
                        }
                        elems.add(null);
                        ++skipCount;
                        continue;
                    }
                    if (tt == 81) break;
                    if (skipCount == 0 && elems.size() == 1 && tt == 116) {
                        Node scopeNode = this.nf.createScopeNode(154, this.ts.getLineno());
                        this.pushScope(scopeNode);
                        String ARRAY_NAME = "$a";
                        this.defineSymbol(150, "$a");
                        Node expr = (Node)elems.get(0);
                        Node block = this.nf.createBlock(this.ts.getLineno());
                        Node init = new Node(130, this.nf.createAssignment(87, this.nf.createName("$a"), this.nf.createCallOrNew(30, this.nf.createName("Array"))), this.ts.getLineno());
                        block.addChildToBack(init);
                        block.addChildToBack(this.arrayComprehension("$a", expr));
                        scopeNode.addChildToBack(block);
                        scopeNode.addChildToBack(this.nf.createName("$a"));
                        this.popScope();
                        return scopeNode;
                    }
                    if (!after_lb_or_comma) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    elems.add(this.assignExpr(false));
                    after_lb_or_comma = false;
                }
                this.consumeToken();
                this.decompiler.addToken(81);
                return this.nf.createArrayLiteral(elems, skipCount);
            }
            case 82: {
                ObjArray elems = new ObjArray();
                this.decompiler.addToken(82);
                if (!this.matchToken(83)) {
                    boolean first = true;
                    block22: do {
                        if (!first) {
                            this.decompiler.addToken(86);
                        } else {
                            first = false;
                        }
                        tt = this.peekToken();
                        switch (tt) {
                            case 38: 
                            case 40: {
                                Object property;
                                this.consumeToken();
                                String s = this.ts.getString();
                                if (tt == 38) {
                                    if (s.equals("get") && this.peekToken() == 38) {
                                        this.decompiler.addToken(148);
                                        this.consumeToken();
                                        s = this.ts.getString();
                                        this.decompiler.addName(s);
                                        property = ScriptRuntime.getIndexObject(s);
                                        if (this.getterSetterProperty(elems, property, true)) continue block22;
                                        break block22;
                                    }
                                    if (s.equals("set") && this.peekToken() == 38) {
                                        this.decompiler.addToken(149);
                                        this.consumeToken();
                                        s = this.ts.getString();
                                        this.decompiler.addName(s);
                                        property = ScriptRuntime.getIndexObject(s);
                                        if (this.getterSetterProperty(elems, property, false)) continue block22;
                                        break block22;
                                    }
                                    this.decompiler.addName(s);
                                } else {
                                    this.decompiler.addString(s);
                                }
                                property = ScriptRuntime.getIndexObject(s);
                                this.plainProperty(elems, property);
                                break;
                            }
                            case 39: {
                                this.consumeToken();
                                double n = this.ts.getNumber();
                                this.decompiler.addNumber(n);
                                Object property = ScriptRuntime.getIndexObject(n);
                                this.plainProperty(elems, property);
                                break;
                            }
                            case 83: {
                                break block22;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block22;
                            }
                        }
                    } while (this.matchToken(86));
                    this.mustMatchToken(83, "msg.no.brace.prop");
                }
                this.decompiler.addToken(83);
                return this.nf.createObjectLiteral(elems);
            }
            case 150: {
                this.decompiler.addToken(150);
                return this.let(false);
            }
            case 84: {
                this.decompiler.addToken(84);
                Node pn = this.expr(false);
                pn.putProp(19, Boolean.TRUE);
                this.decompiler.addToken(85);
                this.mustMatchToken(85, "msg.no.paren");
                return pn;
            }
            case 144: {
                this.mustHaveXML();
                this.decompiler.addToken(144);
                Node pn = this.attributeAccess(null, 0);
                return pn;
            }
            case 38: {
                String name = this.ts.getString();
                if ((ttFlagged & 0x20000) != 0 && this.peekToken() == 100) {
                    return this.nf.createLabel(this.ts.getLineno());
                }
                this.decompiler.addName(name);
                Node pn = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, name, 0) : this.nf.createName(name);
                return pn;
            }
            case 39: {
                double n = this.ts.getNumber();
                this.decompiler.addNumber(n);
                return this.nf.createNumber(n);
            }
            case 40: {
                String s = this.ts.getString();
                this.decompiler.addString(s);
                return this.nf.createString(s);
            }
            case 24: 
            case 97: {
                this.ts.readRegExp(tt);
                String flags = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String re = this.ts.getString();
                this.decompiler.addRegexp(re, flags);
                int index = this.currentScriptOrFn.addRegexp(re, flags);
                return this.nf.createRegExp(index);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.decompiler.addToken(tt);
                return this.nf.createLeaf(tt);
            }
            case 124: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    private void plainProperty(ObjArray elems, Object property) throws IOException {
        this.mustMatchToken(100, "msg.no.colon.prop");
        this.decompiler.addToken(64);
        elems.add(property);
        elems.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray elems, Object property, boolean isGetter) throws IOException {
        Node f = this.function(2);
        if (f.getType() != 106) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int fnIndex = f.getExistingIntProp(1);
        FunctionNode fn = this.currentScriptOrFn.getFunctionNode(fnIndex);
        if (fn.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        elems.add(property);
        if (isGetter) {
            elems.add(this.nf.createUnary(148, f));
        } else {
            elems.add(this.nf.createUnary(149, f));
        }
        return true;
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

