/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode tree) {
        this.transformCompilationUnit(tree);
        for (int i = 0; i != tree.getFunctionCount(); ++i) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode tree) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean createScopeObjects = tree.getType() != 106 || ((FunctionNode)tree).requiresActivation();
        tree.flattenSymbolTable(!createScopeObjects);
        this.transformCompilationUnit_r(tree, tree, tree, createScopeObjects);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode tree, Node parent, Node.Scope scope, boolean createScopeObjects) {
        Node node = null;
        block14: while (true) {
            Node previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            if (createScopeObjects && (type == 126 || type == 129) && node instanceof Node.Scope) {
                Node.Scope newScope = (Node.Scope)node;
                if (newScope.symbolTable != null) {
                    Node let = new Node(150);
                    for (String name : newScope.symbolTable.keySet()) {
                        let.addChildToBack(new Node(150, Node.newString(38, name)));
                    }
                    newScope.symbolTable = null;
                    Node oldNode = node;
                    node = NodeTransformer.replaceCurrent(parent, previous, node, let);
                    type = node.getType();
                    let.addChildToBack(oldNode);
                }
            }
            switch (type) {
                case 111: 
                case 127: 
                case 129: {
                    this.loops.push(node);
                    this.loopEnds.push(((Node.Jump)node).target);
                    break;
                }
                case 120: {
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 78: {
                    Node.Jump jump = (Node.Jump)node;
                    Node finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 3: 
                case 128: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 4: {
                    Node n;
                    boolean isGenerator;
                    boolean bl = isGenerator = tree.getType() == 106 && ((FunctionNode)tree).isGenerator();
                    if (isGenerator) {
                        node.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    Node unwindBlock = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node unwind;
                        n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype != 78 && elemtype != 120) continue;
                        if (elemtype == 78) {
                            Node jsrtarget;
                            Node.Jump jsrnode = new Node.Jump(132);
                            jsrnode.target = jsrtarget = ((Node.Jump)n).getFinally();
                            unwind = jsrnode;
                        } else {
                            unwind = new Node(3);
                        }
                        if (unwindBlock == null) {
                            unwindBlock = new Node(126, node.getLineno());
                        }
                        unwindBlock.addChildToBack(unwind);
                    }
                    if (unwindBlock == null) break;
                    Node returnNode = node;
                    Node returnExpr = returnNode.getFirstChild();
                    node = NodeTransformer.replaceCurrent(parent, previous, node, unwindBlock);
                    if (returnExpr == null || isGenerator) {
                        unwindBlock.addChildToBack(returnNode);
                        continue block14;
                    }
                    Node store = new Node(131, returnExpr);
                    unwindBlock.addChildToFront(store);
                    returnNode = new Node(62);
                    unwindBlock.addChildToBack(returnNode);
                    this.transformCompilationUnit_r(tree, store, scope, createScopeObjects);
                    continue block14;
                }
                case 117: 
                case 118: {
                    Node n;
                    Node.Jump jump = (Node.Jump)node;
                    Node.Jump jumpStatement = jump.getJumpStatement();
                    if (jumpStatement == null) {
                        Kit.codeBug();
                    }
                    int i = this.loops.size();
                    while (true) {
                        if (i == 0) {
                            throw Kit.codeBug();
                        }
                        if ((n = (Node)this.loops.get(--i)) == jumpStatement) break;
                        int elemtype = n.getType();
                        if (elemtype == 120) {
                            Node leave = new Node(3);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype != 78) continue;
                        Node.Jump tryNode = (Node.Jump)n;
                        Node.Jump jsrFinally = new Node.Jump(132);
                        jsrFinally.target = tryNode.getFinally();
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                    }
                    jump.target = type == 117 ? jumpStatement.target : jumpStatement.getContinue();
                    jump.setType(5);
                    break;
                }
                case 37: {
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    this.visitNew(node, tree);
                    break;
                }
                case 150: 
                case 155: {
                    Node child = node.getFirstChild();
                    if (child.getType() == 150) {
                        boolean createWith = tree.getType() != 106 || ((FunctionNode)tree).requiresActivation();
                        node = this.visitLet(createWith, parent, previous, node);
                        break;
                    }
                }
                case 119: 
                case 151: {
                    Node result = new Node(126);
                    for (Node cursor = node.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                        Node n = cursor;
                        if (n.getType() == 38) continue;
                        Kit.codeBug();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        n.setType(48);
                        n = new Node(type == 151 ? 152 : 8, n, init);
                        Node pop = new Node(130, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 134: {
                    Node.Scope defining = scope.getDefiningScope(node.getString());
                    if (defining == null) break;
                    node.setScope(defining);
                    break;
                }
                case 8: 
                case 31: 
                case 38: 
                case 152: {
                    String name;
                    Node.Scope defining;
                    Node nameSource;
                    Node n;
                    if (createScopeObjects) break;
                    if (type == 38) {
                        nameSource = node;
                    } else {
                        nameSource = node.getFirstChild();
                        if (nameSource.getType() != 48) {
                            if (type == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (nameSource.getScope() != null || (defining = scope.getDefiningScope(name = nameSource.getString())) == null) break;
                    nameSource.setScope(defining);
                    if (type == 38) {
                        node.setType(54);
                        break;
                    }
                    if (type == 8) {
                        node.setType(55);
                        nameSource.setType(40);
                        break;
                    }
                    if (type == 152) {
                        node.setType(153);
                        nameSource.setType(40);
                        break;
                    }
                    if (type == 31) {
                        n = new Node(43);
                        node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(tree, node, node instanceof Node.Scope ? (Node.Scope)node : scope, createScopeObjects);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
    }

    protected Node visitLet(boolean createWith, Node parent, Node previous, Node scopeNode) {
        Node result;
        boolean isExpression;
        Node vars = scopeNode.getFirstChild();
        Node body = vars.getNext();
        scopeNode.removeChild(vars);
        scopeNode.removeChild(body);
        boolean bl = isExpression = scopeNode.getType() == 155;
        if (createWith) {
            result = new Node(isExpression ? 156 : 126);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            int count = 0;
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                ++count;
            }
            Object[] properties = new Object[count];
            Node objectLiteral = new Node(64);
            count = 0;
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                if (v.getType() != 38) {
                    throw Kit.codeBug();
                }
                properties[count++] = ScriptRuntime.getIndexObject(v.getString());
                Node init = v.getFirstChild();
                if (init == null) {
                    init = new Node(123, Node.newNumber(0.0));
                }
                objectLiteral.addChildToBack(init);
            }
            objectLiteral.putProp(12, properties);
            Node newVars = new Node(2, objectLiteral);
            result.addChildToBack(newVars);
            result.addChildToBack(new Node(120, body));
            result.addChildToBack(new Node(3));
        } else {
            result = new Node(isExpression ? 86 : 126);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            Node newVars = new Node(86);
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                if (v.getType() != 38) {
                    throw Kit.codeBug();
                }
                Node stringNode = Node.newString(v.getString());
                stringNode.setScope((Node.Scope)scopeNode);
                Node init = v.getFirstChild();
                if (init == null) {
                    init = new Node(123, Node.newNumber(0.0));
                }
                newVars.addChildToBack(new Node(55, stringNode, init));
            }
            if (isExpression) {
                result.addChildToBack(newVars);
                scopeNode.setType(86);
                result.addChildToBack(scopeNode);
                scopeNode.addChildToBack(body);
            } else {
                result.addChildToBack(new Node(130, newVars));
                scopeNode.setType(126);
                result.addChildToBack(scopeNode);
                scopeNode.addChildrenToBack(body);
            }
        }
        return result;
    }

    private static Node addBeforeCurrent(Node parent, Node previous, Node current, Node toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static Node replaceCurrent(Node parent, Node previous, Node current, Node replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }
}

