/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser.tree;

import com.skrul.jedit.javascript.parser.tree.TreeHandler;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class TreeWalker {
    public static void scopeWalk(ScriptOrFnNode script, TreeHandler handler) {
        handler.startScript(script);
        TreeWalker.scopeWalkNodeChildren(script, script, handler);
        int count = script.getFunctionCount();
        for (int i = 0; i < count; ++i) {
            TreeWalker.scopeWalkFunction(script.getFunctionNode(i), i, handler);
        }
        handler.endScript(script);
    }

    private static void scopeWalkFunction(FunctionNode function, int index, TreeHandler handler) {
        handler.startFunction(function, index);
        TreeWalker.scopeWalkNodeChildren(function, function, handler);
        int count = function.getFunctionCount();
        for (int i = 0; i < count; ++i) {
            TreeWalker.scopeWalkFunction(function.getFunctionNode(i), i, handler);
        }
        handler.endFunction(function);
    }

    private static void scopeWalkNodeChildren(Node node, ScriptOrFnNode scope, TreeHandler handler) {
        for (Node n = node.getFirstChild(); n != null; n = n.getNext()) {
            if (n instanceof Node.Scope) {
                handler.startBlock(n);
            } else {
                handler.startNode(n, scope);
            }
            TreeWalker.scopeWalkNodeChildren(n, scope, handler);
            if (n instanceof Node.Scope) {
                handler.endBlock(n);
                continue;
            }
            handler.endNode(n);
        }
    }

    public static void treeWalk(ScriptOrFnNode script, TreeHandler handler) {
        ArrayList<FunctionNode> functionList = new ArrayList<FunctionNode>();
        int count = script.getFunctionCount();
        for (int i = 0; i < count; ++i) {
            functionList.add(script.getFunctionNode(i));
        }
        TreeWalker.treeWalkChildren(script, handler, functionList);
    }

    private static void treeWalkChildren(Node node, TreeHandler handler, List functionList) {
        for (Node n = node.getFirstChild(); n != null; n = n.getNext()) {
            if (n.getType() == 106) {
                FunctionNode function = (FunctionNode)functionList.remove(0);
                handler.startNode(function, null);
                TreeWalker.treeWalk(function, handler);
                handler.endNode(function);
                continue;
            }
            if (n.getType() == 126) {
                handler.startBlock(n);
                TreeWalker.treeWalkChildren(n, handler, functionList);
                handler.endBlock(n);
                continue;
            }
            handler.startNode(n, null);
            TreeWalker.treeWalkChildren(n, handler, functionList);
            handler.endNode(n);
        }
    }
}

