/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser.tree;

import com.skrul.jedit.javascript.parser.FunctionTag;
import com.skrul.jedit.javascript.parser.ObjectLiteralPropertyTag;
import com.skrul.jedit.javascript.parser.ObjectLiteralTag;
import com.skrul.jedit.javascript.parser.tree.AbstractTreeHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class StructureBuildingTreeHandler
extends AbstractTreeHandler {
    private int level = 0;
    private Stack<DefaultMutableTreeNode> treeNodeStack;
    private Stack<Node> nodeStack;
    private Map<Node, Integer> objectLiteralNextPropertyMap;
    private Buffer buffer;

    public StructureBuildingTreeHandler(Buffer buffer, DefaultMutableTreeNode rootTreeNode) {
        this.buffer = buffer;
        this.treeNodeStack = new Stack();
        this.treeNodeStack.push(rootTreeNode);
        this.nodeStack = new Stack();
        this.objectLiteralNextPropertyMap = new HashMap<Node, Integer>();
    }

    public void startNode(Node node, ScriptOrFnNode scope) {
        Node parentNode;
        super.startNode(node, scope);
        DefaultMutableTreeNode currentTreeNode = this.treeNodeStack.peek();
        boolean found = false;
        if (!this.nodeStack.empty() && (parentNode = this.nodeStack.peek()).getType() == 64) {
            int index = this.objectLiteralNextPropertyMap.get(parentNode);
            Object[] o = (Object[])parentNode.getProp(12);
            Position position = this.buffer.createPosition(this.buffer.getLineStartOffset(this.currentLineNumber));
            ObjectLiteralPropertyTag tag = new ObjectLiteralPropertyTag((String)o[index], position, node.getType());
            DefaultMutableTreeNode mtn = new DefaultMutableTreeNode((Object)tag);
            currentTreeNode.add(mtn);
            this.treeNodeStack.push(mtn);
            this.objectLiteralNextPropertyMap.put(parentNode, new Integer(index + 1));
            if (node.getType() == 64) {
                this.objectLiteralNextPropertyMap.put(node, new Integer(0));
            }
            found = true;
        }
        if (!found) {
            if (node.getType() == 106) {
                FunctionNode function = (FunctionNode)node;
                Log.log((int)1, (Object)this, (Object)("stack size:" + this.nodeStack.size()));
                String name = this.getAssignmentName();
                if (name == null && (name = function.getFunctionName()).equals("")) {
                    name = "(anonymous)";
                }
                Position position = this.buffer.createPosition(this.buffer.getLineStartOffset(function.getBaseLineno()));
                DefaultMutableTreeNode mtn = new DefaultMutableTreeNode((Object)new FunctionTag(name, position));
                if (!name.startsWith("__$")) {
                    currentTreeNode.add(mtn);
                }
                this.treeNodeStack.push(mtn);
            }
            if (node.getType() == 64) {
                String name = this.getAssignmentName();
                if (name == null) {
                    name = "(object literal)";
                }
                Position position = this.buffer.createPosition(this.buffer.getLineStartOffset(this.currentLineNumber));
                DefaultMutableTreeNode mtn = new DefaultMutableTreeNode((Object)new ObjectLiteralTag(name, position));
                currentTreeNode.add(mtn);
                this.treeNodeStack.push(mtn);
                this.objectLiteralNextPropertyMap.put(node, new Integer(0));
                Log.log((int)1, (Object)this, (Object)("put node " + node));
            }
        }
        ++this.level;
        this.nodeStack.push(node);
    }

    public void endNode(Node node) {
        Node parentNode;
        super.endNode(node);
        this.nodeStack.pop();
        --this.level;
        boolean found = false;
        if (!this.nodeStack.empty() && (parentNode = this.nodeStack.peek()).getType() == 64) {
            this.treeNodeStack.pop();
            found = true;
        }
        if (!found) {
            if (node.getType() == 106) {
                this.treeNodeStack.pop();
            }
            if (node.getType() == 64) {
                this.treeNodeStack.pop();
            }
        }
    }

    private String getAssignmentName() {
        Node top = null;
        for (int i = this.nodeStack.size() - 1; i >= 0 && top == null; --i) {
            Node n = (Node)this.nodeStack.get(i);
            if (n.getType() == 126 || n.getType() == 64) {
                return null;
            }
            if (n.getType() != 66 && n.getType() != 34 && n.getType() != 8 && n.getType() != 119) continue;
            top = n;
        }
        if (top == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        this.buildAssignmentName(top, sb);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void buildAssignmentName(Node node, StringBuffer sb) {
        switch (node.getType()) {
            case 66: {
                Node refCall = node.getFirstChild();
                this.buildAssignmentName(refCall.getFirstChild(), sb);
                break;
            }
            case 8: {
                this.buildAssignmentName(node.getFirstChild(), sb);
                break;
            }
            case 34: {
                Node getProp = node.getFirstChild();
                this.buildAssignmentName(getProp, sb);
                this.buildAssignmentName(getProp.getNext(), sb);
                break;
            }
            case 33: {
                Node var = node.getFirstChild();
                this.buildAssignmentName(var, sb);
                this.buildAssignmentName(var.getNext(), sb);
                break;
            }
            case 37: {
                this.buildAssignmentName(node.getFirstChild(), sb);
                break;
            }
            case 119: {
                this.buildAssignmentName(node.getFirstChild(), sb);
                break;
            }
            case 38: 
            case 40: 
            case 48: {
                sb.append(node.getString());
                sb.append(".");
                break;
            }
            case 42: {
                sb.append("this.");
            }
        }
    }
}

