/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser.tree;

import com.skrul.jedit.javascript.parser.tree.AbstractTreeHandler;
import com.skrul.jedit.javascript.parser.tree.ErrorHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class ScopeCheckingTreeHandler
extends AbstractTreeHandler {
    private Stack<ScopeInfo> scopeChain;
    private Set builtins;
    private ErrorHandler errorHandler;

    public ScopeCheckingTreeHandler(ErrorHandler errorHandler, Set builtins) {
        this.errorHandler = errorHandler;
        this.builtins = builtins;
        this.scopeChain = new Stack();
    }

    public void startScript(ScriptOrFnNode script) {
        super.startScript(script);
        this.scopeChain.push(new ScopeInfo(script));
    }

    public void endScript(ScriptOrFnNode script) {
        super.endScript(script);
        this.scopeChain.pop();
    }

    public void startFunction(FunctionNode function, int index) {
        super.startFunction(function, index);
        this.scopeChain.push(new ScopeInfo(function));
    }

    public void endFunction(FunctionNode function) {
        super.endFunction(function);
        this.scopeChain.pop();
    }

    public void startBlock(Node node) {
        super.startBlock(node);
        this.scopeChain.push(new ScopeInfo((Node.Scope)node));
    }

    public void endBlock(Node node) {
        super.endBlock(node);
        this.scopeChain.pop();
    }

    public void startNode(Node node, ScriptOrFnNode scope) {
        super.startNode(node, scope);
        if (node.getType() == 138) {
            Node child = node.getFirstChild();
            if (child != null && child.getType() == 56) {
                this.scopeChain.push(new ScopeInfo(child));
            }
        } else if (node.getType() == 120) {
            this.scopeChain.push(new ScopeInfo(node));
        } else if (node.getType() == 38 || node.getType() == 48) {
            this.checkScopeChain(node.getString());
        }
    }

    public void endNode(Node node) {
        super.endNode(node);
        if (node.getType() == 138) {
            Node child = node.getFirstChild();
            if (child != null && child.getType() == 56) {
                this.scopeChain.pop();
            }
        } else if (node.getType() == 120) {
            this.scopeChain.pop();
        }
    }

    private void checkScopeChain(String name) {
        if (!this.builtins.contains(name)) {
            boolean found = false;
            for (int j = this.scopeChain.size() - 1; j >= 0 && !found; --j) {
                ScopeInfo si = (ScopeInfo)this.scopeChain.get(j);
                if (!si.hasSymbol(name)) continue;
                found = true;
            }
            if (!found) {
                this.errorHandler.error(1, this.currentLineNumber, "name '" + name + "' referenced in scope '" + this.scopeChain.peek().scopeName + "' was not found");
            }
        }
    }

    class ScopeInfo {
        public Node scope;
        public Set<String> symbols = new HashSet<String>();
        public String scopeName;

        public ScopeInfo(ScriptOrFnNode scope) {
            FunctionNode fn;
            String functionName;
            this.scope = scope;
            this.scopeName = scope instanceof FunctionNode ? ((functionName = (fn = (FunctionNode)scope).getFunctionName()).equals("") ? "(anonymous)" : functionName) : "(global)";
            if (scope instanceof Node.Scope) {
                ScriptOrFnNode nodeScope = scope;
                if (nodeScope.symbolTable != null) {
                    Iterator iter = nodeScope.symbolTable.keySet().iterator();
                    while (iter.hasNext()) {
                        this.symbols.add((String)iter.next());
                    }
                }
            }
            if (scope instanceof FunctionNode) {
                this.symbols.add("arguments");
            }
        }

        public ScopeInfo(Node.Scope scope) {
            this.scopeName = "(block)";
            if (scope.symbolTable != null) {
                Iterator iter = scope.symbolTable.keySet().iterator();
                while (iter.hasNext()) {
                    this.symbols.add((String)iter.next());
                }
            }
        }

        public ScopeInfo(Node scope) {
            if (scope.getType() == 56) {
                this.scope = scope;
                this.symbols = new HashSet<String>();
                this.scopeName = "(catch)";
                Node child = scope.getFirstChild();
                if (child != null) {
                    this.symbols.add(child.getString());
                }
            } else if (scope.getType() == 120) {
                this.scope = scope;
                this.scopeName = "(with)";
            } else {
                throw new IllegalArgumentException("Not a scope");
            }
        }

        public boolean hasSymbol(String symbol) {
            return this.symbols.contains(symbol);
        }
    }
}

