/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser.tree;

import com.skrul.jedit.javascript.parser.tree.TreeHandler;
import java.util.Stack;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.Token;

public class DebugTreeHandler
implements TreeHandler {
    private int level = 0;
    private Stack<Integer> lineNumbers = new Stack();

    public DebugTreeHandler() {
        this.lineNumbers.push(new Integer(0));
    }

    public void startNode(Node node, ScriptOrFnNode scope) {
        ++this.level;
        if (node.getType() == 64) {
            this.out("ol");
        }
        if (node.getLineno() != -1) {
            this.lineNumbers.push(new Integer(node.getLineno()));
        }
        this.out("startNode: " + Token.name(node.getType()) + " " + this.nodeString(node));
    }

    public void endNode(Node node) {
        this.out("endNode: " + Token.name(node.getType()) + " " + this.nodeString(node));
        --this.level;
        if (node.getLineno() != -1) {
            this.lineNumbers.pop();
        }
    }

    public void startBlock(Node block) {
        ++this.level;
        this.out("startBlock");
    }

    public void endBlock(Node block) {
        this.out("endBlock");
        --this.level;
    }

    public void startFunction(FunctionNode function, int index) {
        ++this.level;
        this.out("startFunction: " + function.getFunctionName());
    }

    public void endFunction(FunctionNode function) {
        this.out("endFunction: " + function.getFunctionName());
        --this.level;
    }

    public void startScript(ScriptOrFnNode script) {
        this.out("startScript");
    }

    public void endScript(ScriptOrFnNode script) {
        this.out("endScript");
    }

    private void out(String s) {
        for (int i = 0; i < this.level; ++i) {
            System.out.print("  ");
        }
        System.out.println(this.lineNumbers.peek() + ": " + s);
    }

    private String nodeString(Node n) {
        try {
            return n.getString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

