/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser.tree;

import com.skrul.jedit.javascript.parser.tree.TreeHandler;
import java.util.Stack;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class AbstractTreeHandler
implements TreeHandler {
    protected Stack<Integer> lineNumberStack = new Stack();
    protected int currentLineNumber = 0;

    public void startNode(Node node, ScriptOrFnNode scope) {
        System.out.println("startNode");
        this.pushLineNumber(node);
    }

    public void endNode(Node node) {
        this.popLineNumber(node);
    }

    public void startBlock(Node block) {
        System.out.println("startBlock");
        this.pushLineNumber(block);
    }

    public void endBlock(Node block) {
        this.popLineNumber(block);
    }

    public void startFunction(FunctionNode function, int index) {
        System.out.println("startFunction");
        this.pushLineNumber(function);
    }

    public void endFunction(FunctionNode function) {
        this.popLineNumber(function);
    }

    public void startScript(ScriptOrFnNode script) {
        System.out.println("startScript");
        this.pushLineNumber(script);
    }

    public void endScript(ScriptOrFnNode script) {
        this.popLineNumber(script);
    }

    protected void pushLineNumber(Node node) {
        if (node.getLineno() > -1) {
            this.currentLineNumber = node.getLineno();
            this.lineNumberStack.push(new Integer(this.currentLineNumber));
        }
    }

    protected void popLineNumber(Node node) {
        if (node.getLineno() > -1) {
            this.lineNumberStack.pop();
            if (this.lineNumberStack.empty()) {
                this.currentLineNumber = 0;
            } else {
                Integer lineNumber = this.lineNumberStack.peek();
                this.currentLineNumber = lineNumber;
            }
        }
    }
}

