/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser;

import com.skrul.jedit.javascript.parser.AbstractJavaScriptParser;
import com.skrul.jedit.javascript.parser.BufferSettings;
import com.skrul.jedit.javascript.parser.PreprocessorParser;
import errorlist.DefaultErrorSource;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;
import sidekick.SideKickParsedData;

public class XMLJavaScriptParser
extends AbstractJavaScriptParser {
    private static String XBL_NS = "http://www.mozilla.org/xbl";
    private static String XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
    private static String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static Pattern allWhitespace = Pattern.compile("^\\s+$");
    private static Set<String> XUL_ATTRS = new HashSet<String>(Arrays.asList("CheckboxStateChange", "DOMAttrModified", "DOMMenuItemActive", "DOMMenuItemInactive", "DOMMouseScroll", "DOMNodeInserted", "DOMNodeRemoved", "RadioStateChange", "onblur", "onbroadcast", "onchange", "onclick", "onclose", "oncommand", "oncommandupdate", "oncontextmenu", "ondblclick", "ondragdrop", "ondragenter", "ondragexit", "ondraggesture", "ondragover", "onfocus", "oninput", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onoverflow", "onoverflowchanged", "onpopuphidden", "onpopuphiding", "onpopupshowing", "onpopupshown", "onselect", "onsyncfrompreference", "onsynctopreference", "onunderflow", "onunload"));
    private static Set<String> XHTML_ATTRS = new HashSet<String>(Arrays.asList("onload", "onunload", "onchange", "onsubmit", "onreset", "onselect", "onblur", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onclick", "ondblclick", "onmousedown", "onmousemove", "onmouseover", "onmouseout", "onmouseup"));

    public XMLJavaScriptParser() {
        super("skrul-xml-javascript");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        String text;
        SideKickParsedData data = new SideKickParsedData(buffer.getPath());
        BufferSettings settings = new BufferSettings(buffer);
        try {
            buffer.readLock();
            if (settings.handlePreprocessor()) {
                int lineCount = buffer.getLineCount();
                ArrayList<String> lines = new ArrayList<String>(lineCount);
                for (int i = 0; i < lineCount; ++i) {
                    lines.add(buffer.getLineText(i));
                }
                text = PreprocessorParser.parse(lines);
            } else {
                text = buffer.getText(0, buffer.getLength());
            }
        }
        finally {
            buffer.readUnlock();
        }
        Handler handler = new Handler(buffer, errorSource);
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setErrorHandler(handler);
            reader.setContentHandler(handler);
            reader.setEntityResolver(handler);
        }
        catch (SAXException se) {
            se.printStackTrace();
            Log.log((int)9, (Object)this, (Object)se);
        }
        InputSource source = new InputSource();
        source.setCharacterStream(new StringReader(text));
        source.setSystemId(buffer.getPath());
        try {
            reader.parse(source);
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
            ioe.printStackTrace();
            errorSource.addError(0, buffer.getPath(), 0, 0, 0, ioe.toString());
        }
        catch (SAXParseException spe) {
        }
        catch (SAXException se) {
            Log.log((int)9, (Object)this, (Object)se.getException());
            if (se.getMessage() != null) {
                se.printStackTrace();
                errorSource.addError(0, buffer.getPath(), 0, 0, 0, se.getMessage());
            }
        }
        catch (Exception e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
        this.parseJavaScript(handler.code.toString(), 0, buffer, data, errorSource);
        return data;
    }

    public boolean supportsCompletion() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Handler
    extends DefaultHandler2
    implements ErrorHandler {
        private Buffer buffer;
        private DefaultErrorSource errorSource;
        private Locator loc;
        private int codeContainerDepth;
        private StringBuffer codeBuffer;
        private List<String> codeParams;
        private String codeName;
        private int codeStartLine;
        private String xblPropertyName;
        public StringBuffer code;
        private int codeLine;
        private int xulAttrCount;

        Handler(Buffer buffer, DefaultErrorSource errorSource) {
            this.buffer = buffer;
            this.errorSource = errorSource;
            this.codeContainerDepth = 0;
            this.codeBuffer = new StringBuffer();
            this.codeParams = new ArrayList<String>();
            this.codeName = null;
            this.codeStartLine = 0;
            this.xblPropertyName = null;
            this.code = new StringBuffer();
            this.codeLine = 0;
            this.xulAttrCount = 0;
        }

        private boolean ignoreMessage(String message) {
            if (message.startsWith("More pseudo attributes are expected")) {
                return true;
            }
            return message.startsWith("Content is not allowed in prolog");
        }

        private void addError(int type, String uri, int line, String message) {
            if (this.ignoreMessage(message)) {
                return;
            }
            this.errorSource.addError(type, uri, line, 0, 0, message);
        }

        private void appendCode(int line, String buff) {
            while (this.codeLine < line) {
                this.code.append("\n");
                ++this.codeLine;
            }
            if (this.code.charAt(this.code.length() - 1) == '}') {
                this.code.append(';');
            }
            String[] lines = buff.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                this.code.append(lines[i]);
                if (i >= lines.length - 1) continue;
                this.code.append("\n");
                ++this.codeLine;
            }
            if (buff.endsWith("\n")) {
                this.code.append("\n");
                ++this.codeLine;
            }
        }

        private boolean isCodeContainer(String namespaceURI, String lName) {
            if (namespaceURI == XBL_NS && (lName == "constructor" || lName == "destructor" || lName == "method" || lName == "field" || lName == "getter" || lName == "setter" || lName == "handler")) {
                return true;
            }
            return (namespaceURI == XUL_NS || namespaceURI == XHTML_NS) && lName == "script";
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            Log.log((int)1, (Object)this, (Object)("PUBLIC=" + publicId + ", SYSTEM=" + systemId + " cannot be resolved"));
            InputSource dummy = new InputSource(systemId);
            dummy.setPublicId(publicId);
            dummy.setCharacterStream(new StringReader("<!-- -->"));
            return dummy;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.loc = locator;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            int line = this.loc.getLineNumber();
            if (namespaceURI == XBL_NS) {
                String code;
                List<String> param;
                String name;
                if (lName == "handler" && attrs.getIndex("action") >= 0) {
                    name = "xblhandler_" + attrs.getValue("event");
                    param = Arrays.asList("event");
                    code = this.makeCodeBlock(name, param, attrs.getValue("action"));
                    this.appendCode(line - 1, code);
                }
                if (lName == "property" && attrs.getIndex("onget") >= 0) {
                    name = "get_" + attrs.getValue("name");
                    String code2 = this.makeCodeBlock(name, null, attrs.getValue("onget"));
                    this.appendCode(line - 1, code2);
                }
                if (lName == "property" && attrs.getIndex("onset") >= 0) {
                    name = "set_" + attrs.getValue("name");
                    param = Arrays.asList("val");
                    code = this.makeCodeBlock(name, param, attrs.getValue("onset"));
                    this.appendCode(line - 1, code);
                }
            }
            if (namespaceURI == XUL_NS || namespaceURI == XHTML_NS) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String event = attrs.getLocalName(i);
                    if (!XUL_ATTRS.contains(event) && !XHTML_ATTRS.contains(event)) continue;
                    String name = "__$" + event + "_" + this.xulAttrCount;
                    List<String> param = Arrays.asList("event");
                    String code = this.makeCodeBlock(name, param, attrs.getValue(event));
                    this.appendCode(line - 1, code);
                    ++this.xulAttrCount;
                }
            }
            if (this.isCodeContainer(namespaceURI, lName)) {
                if (this.codeContainerDepth == 0) {
                    this.codeStartLine = line;
                    if (namespaceURI == XBL_NS) {
                        if (lName == "constructor" || lName == "destructor") {
                            this.codeName = "xbl_" + lName;
                        }
                        if (lName == "method" || lName == "field") {
                            this.codeName = attrs.getValue("name");
                        }
                        if (lName == "getter") {
                            this.codeName = "get_" + this.xblPropertyName;
                        }
                        if (lName == "setter") {
                            this.codeName = "set_" + this.xblPropertyName;
                            this.codeParams.add("val");
                        }
                        if (lName == "handler") {
                            this.codeName = "xblhandler_" + attrs.getValue("event");
                            this.codeParams.add("event");
                        }
                    }
                }
                ++this.codeContainerDepth;
            }
            if (this.codeContainerDepth > 0 && namespaceURI == XBL_NS && lName == "parameter") {
                this.codeParams.add(attrs.getValue("name"));
            }
            if (namespaceURI == XBL_NS && lName == "property") {
                this.xblPropertyName = attrs.getValue("name");
            }
        }

        @Override
        public void endElement(String namespaceURI, String lName, String qName) throws SAXException {
            if (this.codeContainerDepth > 0 && this.isCodeContainer(namespaceURI, lName)) {
                --this.codeContainerDepth;
                if (this.codeContainerDepth == 0) {
                    String buff = this.codeBuffer.toString();
                    if ((namespaceURI == XUL_NS || namespaceURI == XHTML_NS) && lName == "script") {
                        if (!allWhitespace.matcher(buff).matches()) {
                            this.appendCode(this.codeStartLine + 1, buff);
                        }
                    } else {
                        buff = this.makeCodeBlock(this.codeName, this.codeParams, buff);
                        this.appendCode(this.codeStartLine - 1, buff);
                    }
                    this.codeBuffer = new StringBuffer();
                    this.codeParams.clear();
                    this.codeName = null;
                    this.codeStartLine = 0;
                }
            }
            if (namespaceURI == XBL_NS && lName == "property") {
                this.xblPropertyName = null;
            }
        }

        public String makeCodeBlock(String name, List<String> params, String code) {
            StringBuffer js = new StringBuffer("function ");
            if (name != null) {
                js.append(name);
            }
            js.append("(");
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    js.append(params.get(i));
                    if (i >= params.size() - 1) continue;
                    js.append(",");
                }
            }
            js.append(") {");
            js.append(code);
            js.append("}");
            return js.toString();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.codeContainerDepth > 0) {
                this.codeBuffer.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = this.buffer.getPath();
            }
            this.addError(0, spe.getSystemId(), Math.max(0, spe.getLineNumber() - 1), spe.getMessage());
        }

        @Override
        public void warning(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = this.buffer.getPath();
            }
            this.addError(1, spe.getSystemId(), Math.max(0, spe.getLineNumber() - 1), spe.getMessage());
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXParseException {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = this.buffer.getPath();
            }
            this.addError(0, systemId, Math.max(0, spe.getLineNumber() - 1), spe.getMessage());
        }
    }
}

