/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser;

import com.skrul.jedit.javascript.parser.PreprocessorParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class BuiltinsManager {
    private Set<String> builtins = new HashSet<String>();

    public Set get() {
        return this.builtins;
    }

    public void loadStandard(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/com/skrul/jedit/javascript/builtins/" + name + ".js");
        if (is == null) {
            throw new IOException("Can't find standard '" + name + "'");
        }
        this.loadFromReader(new InputStreamReader(is));
    }

    public void loadInclude(String fileName, boolean handlePreprocessor) throws IOException {
        FileReader fr = new FileReader(fileName);
        if (handlePreprocessor) {
            BufferedReader br = new BufferedReader(fr);
            ArrayList<String> lines = new ArrayList<String>();
            while (br.ready()) {
                lines.add(br.readLine());
            }
            String processed = PreprocessorParser.parse(lines);
            this.loadFromReader(new StringReader(processed));
        } else {
            this.loadFromReader(fr);
        }
    }

    public void addVariable(String name) {
        this.builtins.add(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromReader(Reader r) throws IOException {
        Context cx = Context.enter();
        cx.setLanguageVersion(170);
        try {
            CompilerEnvirons compilerEnv = new CompilerEnvirons();
            compilerEnv.initFromContext(cx);
            Parser p = new Parser(compilerEnv, compilerEnv.getErrorReporter());
            ScriptOrFnNode tree = p.parse(r, "", 0);
            this.builtins.addAll(tree.symbolTable.keySet());
        }
        finally {
            Context.exit();
        }
    }
}

