/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser;

import com.skrul.jedit.javascript.options.PropertyNames;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;

public class BufferSettings
implements PropertyNames {
    private static final String VARLINE_DELIM = "-*-";
    private static final String VAR_STANDARD = "js-standard";
    private static final String VAR_INCLUDE = "js-include";
    private static final String VAR_VAR = "js-var";
    private static final String VAR_PREPROC = "js-preproc";
    private Set<String> standard = new HashSet<String>();
    private Set<String> include = new HashSet<String>();
    private Set<String> var = new HashSet<String>();
    private boolean handlePreprocessor;
    private boolean scopeCheck;
    private boolean allowGetterSetter;

    public BufferSettings(Buffer buffer) {
        String fileName;
        this.standard.add("javascript");
        String builtinsList = jEdit.getProperty((String)"com.skrul.jedit.javascript.builtins");
        if (builtinsList.length() > 0) {
            this.standard.addAll(Arrays.asList(builtinsList.split(" ")));
        }
        int index = 0;
        while ((fileName = jEdit.getProperty((String)("com.skrul.jedit.javascript.import." + index))) != null) {
            this.include.add(fileName);
            ++index;
        }
        this.handlePreprocessor = jEdit.getBooleanProperty((String)"com.skrul.jedit.javascript.handle-preprocessor");
        this.scopeCheck = jEdit.getBooleanProperty((String)"com.skrul.jedit.javascript.scope-check");
        this.allowGetterSetter = jEdit.getBooleanProperty((String)"com.skrul.jedit.javascript.allow-gettersetter");
        String line = buffer.getLineText(0);
        if (line == null) {
            return;
        }
        int startPos = line.indexOf(VARLINE_DELIM);
        if (startPos >= 0) {
            int endPos = line.indexOf(VARLINE_DELIM, startPos + VARLINE_DELIM.length());
            String vars = line.substring(startPos + VARLINE_DELIM.length(), endPos);
            String[] a = vars.split(";");
            for (int i = 0; i < a.length; ++i) {
                String[] b = a[i].split(":", 2);
                if (b.length != 2) continue;
                String name = b[0].trim();
                String[] values = b[1].trim().split(",");
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j].trim();
                    if (name.equals(VAR_STANDARD)) {
                        this.standard.add(value);
                        continue;
                    }
                    if (name.equals(VAR_INCLUDE)) {
                        this.include.add(value);
                        continue;
                    }
                    if (name.equals(VAR_VAR)) {
                        this.var.add(value);
                        continue;
                    }
                    if (!name.equals(VAR_PREPROC)) continue;
                    this.handlePreprocessor = value.equals("true");
                }
            }
        }
    }

    public Set getInclude() {
        return this.include;
    }

    public boolean handlePreprocessor() {
        return this.handlePreprocessor;
    }

    public boolean allowGetterSetter() {
        return this.allowGetterSetter;
    }

    public boolean scopeCheck() {
        return this.scopeCheck;
    }

    public Set getStandard() {
        return this.standard;
    }

    public Set getVar() {
        return this.var;
    }
}

