/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.parser;

import com.skrul.jedit.javascript.options.PropertyNames;
import com.skrul.jedit.javascript.parser.BufferSettings;
import com.skrul.jedit.javascript.parser.BuiltinsManager;
import com.skrul.jedit.javascript.parser.tree.DefaultErrorSourceErrorHandler;
import com.skrul.jedit.javascript.parser.tree.ScopeCheckingTreeHandler;
import com.skrul.jedit.javascript.parser.tree.StructureBuildingTreeHandler;
import com.skrul.jedit.javascript.parser.tree.TreeWalker;
import errorlist.DefaultErrorSource;
import java.io.IOException;
import java.util.Iterator;
import org.gjt.sp.jedit.Buffer;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;

public abstract class AbstractJavaScriptParser
extends SideKickParser
implements PropertyNames {
    public AbstractJavaScriptParser(String serviceName) {
        super(serviceName);
    }

    public boolean supportsCompletion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJavaScript(String text, int line, Buffer buffer, SideKickParsedData data, DefaultErrorSource errorSource) {
        block13: {
            ParserErrorReporter errorReporter = new ParserErrorReporter(errorSource);
            BufferSettings settings = new BufferSettings(buffer);
            Context cx = Context.enter();
            cx.setLanguageVersion(170);
            try {
                CompilerEnvirons compilerEnv = new CompilerEnvirons();
                compilerEnv.initFromContext(cx);
                Parser p = new Parser(compilerEnv, errorReporter);
                try {
                    ScriptOrFnNode tree = p.parse(text, buffer.getPath(), line);
                    StructureBuildingTreeHandler sbth = new StructureBuildingTreeHandler(buffer, data.root);
                    TreeWalker.treeWalk(tree, sbth);
                    if (!settings.scopeCheck()) break block13;
                    BuiltinsManager bm = new BuiltinsManager();
                    try {
                        Iterator i = settings.getStandard().iterator();
                        while (i.hasNext()) {
                            bm.loadStandard((String)i.next());
                        }
                    }
                    catch (IOException e) {
                        errorSource.addError(0, buffer.getPath(), 0, 0, 0, "Standard not found: " + e.getMessage());
                    }
                    String fileName2 = null;
                    try {
                        for (String fileName2 : settings.getInclude()) {
                            bm.loadInclude(fileName2, settings.handlePreprocessor());
                        }
                    }
                    catch (IOException e) {
                        errorSource.addError(0, buffer.getPath(), 0, 0, 0, "File not found '" + fileName2 + "':" + e.getMessage());
                    }
                    catch (EvaluatorException e) {
                        errorSource.addError(0, buffer.getPath(), 0, 0, 0, "Error parsing include file '" + fileName2 + "':" + e.getMessage());
                    }
                    Iterator i = settings.getVar().iterator();
                    while (i.hasNext()) {
                        bm.addVariable((String)i.next());
                    }
                    DefaultErrorSourceErrorHandler errorHandler = new DefaultErrorSourceErrorHandler(errorSource, buffer.getPath());
                    ScopeCheckingTreeHandler treeHandler = new ScopeCheckingTreeHandler(errorHandler, bm.get());
                    TreeWalker.scopeWalk(tree, treeHandler);
                }
                catch (EvaluatorException e) {
                    // empty catch block
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    class ParserErrorReporter
    implements ErrorReporter {
        private DefaultErrorSource errorSource;

        public ParserErrorReporter(DefaultErrorSource errorSource) {
            this.errorSource = errorSource;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.errorSource.addError(1, sourceName, line, 0, 0, message);
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.errorSource.addError(0, sourceName, line, 0, 0, message);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }
}

