/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.options;

import com.skrul.jedit.javascript.options.PropertyNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardScopeTableModel
extends AbstractTableModel
implements PropertyNames {
    private static final long serialVersionUID = 1L;
    private List<String> names = new ArrayList<String>();
    private List<String> labels = new ArrayList<String>();
    private List<Boolean> states = new ArrayList<Boolean>();

    StandardScopeTableModel() {
        String name;
        String builtinsList = jEdit.getProperty((String)"com.skrul.jedit.javascript.builtins");
        List<String> builtins = Arrays.asList(builtinsList.split(" "));
        int i = 0;
        while ((name = jEdit.getProperty((String)("com.skrul.jedit.javascript.standard-builtin." + i + ".name"))) != null) {
            this.names.add(name);
            this.labels.add(jEdit.getProperty((String)("com.skrul.jedit.javascript.standard-builtin." + i + ".label")) + " (" + name + ")");
            this.states.add(new Boolean(builtins.contains(name)));
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.states.get(row);
            }
            case 1: {
                return this.labels.get(row);
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            return;
        }
        switch (col) {
            case 0: {
                this.states.set(row, (Boolean)value);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
        }
        throw new InternalError();
    }

    public void save() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.names.size(); ++i) {
            Boolean selected = this.states.get(i);
            if (!selected.booleanValue()) continue;
            sb.append(this.names.get(i));
            sb.append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        jEdit.setProperty((String)"com.skrul.jedit.javascript.builtins", (String)sb.toString());
    }
}

