/*
 * Decompiled with CFR 0.152.
 */
package com.skrul.jedit.javascript.options;

import com.skrul.jedit.javascript.options.PropertyNames;
import com.skrul.jedit.javascript.options.StandardScopeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class ScopeCheckOptionPane
extends AbstractOptionPane
implements PropertyNames {
    private static final long serialVersionUID = 1L;
    private StandardScopeTableModel model;
    private JList importList;
    private DefaultListModel importListModel;
    private JButton add;
    private JButton remove;
    private JCheckBox scopeCheck;

    public ScopeCheckOptionPane() {
        super("com.skrul.jedit.javascript.scope-check");
    }

    protected void _init() {
        String fileName;
        this.importListModel = new DefaultListModel();
        int i = 0;
        while ((fileName = jEdit.getProperty((String)("com.skrul.jedit.javascript.import." + i))) != null) {
            this.importListModel.addElement(fileName);
            ++i;
        }
        this.scopeCheck = new JCheckBox(jEdit.getProperty((String)"options.com.skrul.jedit.javascript.scope-check"));
        this.addComponent(this.scopeCheck);
        this.scopeCheck.setSelected(jEdit.getBooleanProperty((String)"com.skrul.jedit.javascript.scope-check"));
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.com.skrul.jedit.javascript.builtins")));
        this.addComponent(this.createModesSelector());
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.com.skrul.jedit.javascript.import")));
        this.importList = new JList(this.importListModel);
        this.addComponent(new JScrollPane(this.importList), 2);
        this.importList.addListSelectionListener(new ListHandler());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.addActionListener(new ActionHandler());
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.addActionListener(new ActionHandler());
        buttons.add(this.remove);
        buttons.add(Box.createGlue());
        this.addComponent(buttons);
        this.updateEnabled();
    }

    protected void _save() {
        int i;
        jEdit.setBooleanProperty((String)"com.skrul.jedit.javascript.scope-check", (boolean)this.scopeCheck.isSelected());
        this.model.save();
        for (i = 0; i < this.importListModel.getSize(); ++i) {
            jEdit.setProperty((String)("com.skrul.jedit.javascript.import." + i), (String)((String)this.importListModel.getElementAt(i)));
        }
        jEdit.unsetProperty((String)("com.skrul.jedit.javascript.import." + i));
    }

    private JScrollPane createModesSelector() {
        this.model = new StandardScopeTableModel();
        JTable table = new JTable(this.model);
        table.getTableHeader().setReorderingAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        CheckBoxCellRenderer checkBox = new CheckBoxCellRenderer();
        checkBox.setRequestFocusEnabled(false);
        table.setRowHeight(checkBox.getPreferredSize().height);
        table.getColumnModel().getColumn(1).setPreferredWidth(350);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(checkBox);
        checkBox = new CheckBoxCellRenderer();
        checkBox.setRequestFocusEnabled(false);
        column.setCellEditor(new DefaultCellEditor(checkBox));
        column.setPreferredWidth(checkBox.getPreferredSize().width);
        Dimension d = table.getPreferredSize();
        d.height = Math.min(d.height, 400);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private void updateEnabled() {
        boolean selected = this.importList.getSelectedValue() != null;
        this.remove.setEnabled(selected);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            ScopeCheckOptionPane.this.updateEnabled();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ScopeCheckOptionPane.this.add) {
                String[] files = GUIUtilities.showVFSFileDialog(null, null, (int)0, (boolean)true);
                if (files == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    ScopeCheckOptionPane.this.importListModel.addElement(files[i]);
                }
            } else if (evt.getSource() == ScopeCheckOptionPane.this.remove) {
                ScopeCheckOptionPane.this.importListModel.removeElementAt(ScopeCheckOptionPane.this.importList.getSelectedIndex());
                ScopeCheckOptionPane.this.updateEnabled();
            }
        }
    }

    class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckBoxCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean val = (Boolean)value;
            this.setSelected(val);
            return this;
        }
    }
}

