/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.jsp;

import beauty.beautifiers.Beautifier;
import beauty.beautifiers.CSSBeautifier;
import beauty.beautifiers.DefaultBeautifier;
import beauty.beautifiers.JavaLineBeautifier;
import beauty.parsers.ParserException;
import beauty.parsers.jsp.JspParserConstants;
import beauty.parsers.jsp.JspParserTokenManager;
import beauty.parsers.jsp.ParseException;
import beauty.parsers.jsp.SimpleCharStream;
import beauty.parsers.jsp.Token;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class JspParser
implements JspParserConstants {
    Token t;
    boolean padSlashEnd = false;
    boolean padTagEnd = false;
    boolean wrapAttributes = false;
    String ls = System.getProperty("line.separator");
    char wrapSep = (char)28;
    int indentWidth = 0;
    int tabSize = 0;
    boolean useSoftTabs = true;
    public JspParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[32];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setPadSlashEnd(boolean b) {
        this.padSlashEnd = b;
    }

    public void setPadTagEnd(boolean b) {
        this.padTagEnd = b;
    }

    public void setWrapAttributes(boolean b) {
        this.wrapAttributes = b;
    }

    public void setCollapseBlankLines(boolean b) {
        JspParserTokenManager.collapseBlankLines = b;
    }

    public void setIndentWidth(int i) {
        JspParserTokenManager.setIndentWidth(i);
        this.indentWidth = i;
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
        this.tabSize = size;
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    public void setUseSoftTabs(boolean b) {
        JspParserTokenManager.setUseSoftTabs(b);
        this.useSoftTabs = true;
    }

    public String getText() {
        JspParser jspParser = this;
        return jspParser.token_source.getText();
    }

    public void resetTokenSource() {
        JspParser jspParser = this;
        jspParser.token_source.reset();
    }

    private void add(Token t) {
        JspParserTokenManager.add(t);
    }

    private void add(String s) {
        JspParserTokenManager.add(s);
    }

    private void trim() {
        JspParser jspParser = this;
        jspParser.token_source.trim();
    }

    private void trimNL() {
        JspParser jspParser = this;
        jspParser.token_source.trimNL();
    }

    private void trimNL(String s) {
        JspParserTokenManager.trimNL(s);
    }

    private void trimWhitespace() {
        JspParser jspParser = this;
        jspParser.token_source.trimWhitespace();
    }

    private void write() {
        JspParser jspParser = this;
        jspParser.token_source.write();
    }

    private void writeln() {
        JspParser jspParser = this;
        jspParser.token_source.writeln();
    }

    private void writePre(String s) {
        JspParserTokenManager.writePre(s);
    }

    private String getSpecial(Token token) {
        if (token.specialToken == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Token special = token.specialToken;
        while (special.specialToken != null) {
            special = special.specialToken;
        }
        while (special != null) {
            sb.append(special.image);
            special = special.next;
        }
        String s = sb.toString();
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\t", "");
        StringTokenizer st = new StringTokenizer(s, this.ls, true);
        int count = st.countTokens();
        if (JspParserTokenManager.collapseBlankLines) {
            count = Math.min(2, count);
        }
        sb.setLength(0);
        for (int i = 0; i < count; ++i) {
            sb.append(this.ls);
        }
        return sb.toString();
    }

    public void setLineSeparator(String le) {
        this.ls = le;
        JspParserTokenManager.setLineSeparator(le);
    }

    public void parse() throws ParseException {
        this.CompilationUnit();
    }

    public static void main(String[] args) {
        JspParser parser;
        if (args.length == 0) {
            System.out.println("Jsp Parser:  Reading from standard input . . .");
            parser = new JspParser(System.in);
        } else if (args.length == 1) {
            System.out.println("Jsp Parser:  Reading from file " + args[0] + " . . .");
            try {
                parser = new JspParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("Jsp Parser:  File " + args[0] + " not found.");
                return;
            }
        } else {
            System.out.println("Jsp Parser:  Usage is one of:");
            System.out.println("         java JspParser < inputfile");
            System.out.println("OR");
            System.out.println("         java JspParser inputfile");
            return;
        }
        try {
            parser.CompilationUnit();
            System.out.println("Jsp Parser:  Java program parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println("Jsp Parser:  Encountered errors during parse.");
        }
    }

    public final void CompilationUnit() throws ParseException {
        this.Prolog();
        this.Content();
        this.jj_consume_token(0);
        this.trimWhitespace();
        this.write();
    }

    public final void Prolog() throws ParseException {
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            block18: {
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: 
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block18;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.CommentTag();
                            continue block14;
                        }
                        case 31: {
                            this.JspComment();
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.Declaration();
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            block19: {
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: 
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block19;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.CommentTag();
                            continue block15;
                        }
                        case 31: {
                            this.JspComment();
                            continue block15;
                        }
                    }
                    break;
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.DoctypeDeclaration();
        }
    }

    public final void Content() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 37: {
                this.Text();
                break;
            }
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.ContentElementPossiblyWithText();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 25: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block7;
                }
            }
            this.ContentElementPossiblyWithText();
        }
    }

    public final void ContentElementPossiblyWithText() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.CommentTag();
                break;
            }
            case 25: {
                this.Element();
                break;
            }
            case 30: {
                this.CData();
                break;
            }
            case 31: {
                this.JspComment();
                break;
            }
            case 32: {
                this.JspDeclaration();
                break;
            }
            case 33: {
                this.JspExpression();
                break;
            }
            case 34: {
                this.JspScriptlet();
                break;
            }
            case 35: {
                this.JspDirective();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 37: {
                this.Text();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
    }

    public final void JspDirective() throws ParseException {
        this.t = this.jj_consume_token(35);
        this.writePre(this.getSpecial(this.t));
        this.add(this.t);
        this.t = this.jj_consume_token(38);
        this.trim();
        this.add(" ");
        this.add(this.t);
        this.add(" ");
        this.JspDirectiveAttributes();
        this.t = this.jj_consume_token(42);
        this.trim();
        this.add(this.t);
        this.write();
    }

    public final void JspDirectiveAttributes() throws ParseException {
        boolean haveAttrs = false;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            haveAttrs = this.JspDirectiveAttribute();
            if (!haveAttrs) continue;
            this.add(" ");
        }
    }

    public final boolean JspDirectiveAttribute() throws ParseException {
        boolean added = false;
        this.t = this.jj_consume_token(39);
        this.add(this.t);
        added = true;
        this.t = this.jj_consume_token(40);
        this.add(this.t);
        this.t = this.jj_consume_token(41);
        String s = this.t.image;
        String[] parts = s.split(",");
        if (parts.length > 1) {
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i].trim();
                if (i == 0) {
                    this.add(part + "," + this.ls);
                    continue;
                }
                if (i == parts.length - 1) {
                    this.add(JspParserTokenManager.indent + part + this.ls);
                    continue;
                }
                this.add(JspParserTokenManager.indent + part + "," + this.ls);
            }
        } else {
            this.add(s);
        }
        return added;
    }

    public final void JspScriptlet() throws ParseException {
        Token start = this.jj_consume_token(34);
        Token content = this.jj_consume_token(44);
        Token end = this.jj_consume_token(43);
        String ws = this.getSpecial(start);
        String java = null;
        boolean multiline = false;
        try {
            if (content != null && content.image.trim().length() > 0) {
                JavaLineBeautifier beautifier = new JavaLineBeautifier();
                beautifier.setInitialIndentLevel(JspParserTokenManager.level);
                java = ((Beautifier)beautifier).beautify(content.image.trim());
                if (java == null || java.length() == 0) {
                    return;
                }
                multiline = java.indexOf(this.ls) > 0;
            }
        }
        catch (ParserException pe) {
            throw new ParseException(pe.getMessage());
        }
        if (ws != null && ws.length() > 0) {
            this.writePre(ws);
        } else if (multiline) {
            this.writeln();
        }
        this.add(start);
        if (multiline) {
            this.writeln();
            ++JspParserTokenManager.level;
        }
        if (multiline) {
            this.writePre(java);
            --JspParserTokenManager.level;
        } else {
            this.add(" ");
            this.add(java);
            this.add(" ");
        }
        this.add(end);
        if (multiline) {
            this.writeln();
        } else {
            this.write();
        }
    }

    public final void JspExpression() throws ParseException {
        this.t = this.jj_consume_token(33);
        this.writePre(this.getSpecial(this.t));
        this.add(this.t);
        this.t = this.jj_consume_token(46);
        this.add(this.t);
        this.t = this.jj_consume_token(45);
        this.add(this.t);
        this.writeln();
    }

    public final void JspDeclaration() throws ParseException {
        this.t = this.jj_consume_token(32);
        this.writePre(this.getSpecial(this.t));
        this.add(this.t);
        this.t = this.jj_consume_token(48);
        this.add(this.t);
        this.t = this.jj_consume_token(47);
        this.add(this.t);
        this.writeln();
    }

    public final void JspComment() throws ParseException {
        String[] parts;
        ArrayList<String> lines = new ArrayList<String>();
        this.t = this.jj_consume_token(31);
        this.writePre(this.getSpecial(this.t));
        lines.add(this.t.image);
        this.t = this.jj_consume_token(50);
        String s = this.t.image.trim();
        if (JspParserTokenManager.collapseBlankLines) {
            String lsep = "\r".equals(this.ls) ? "\\r" : ("\r\n".equals(this.ls) ? "\\r\\n" : "\\n");
            String regex = "(([ ]|[\\t])*(" + lsep + ")){2,}";
            s = s.replaceAll(regex, this.ls + this.ls);
        }
        for (String line : parts = s.split(this.ls)) {
            lines.add(line);
        }
        this.t = this.jj_consume_token(49);
        if (lines.size() > 2 && !((String)lines.get(lines.size() - 1)).trim().isEmpty()) {
            lines.add(JspParserTokenManager.indent);
        }
        lines.add(this.t.image);
        StringBuilder sb = new StringBuilder();
        switch (lines.size()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                sb.append((String)lines.get(0));
                sb.append(" ");
                sb.append((String)lines.get(1));
                this.add(sb.toString());
                this.write();
                break;
            }
            case 3: {
                sb.append((String)lines.get(0));
                sb.append(" ");
                sb.append((String)lines.get(1));
                sb.append(" ");
                sb.append((String)lines.get(2));
                this.add(sb.toString());
                this.write();
                break;
            }
            default: {
                this.add((String)lines.get(0));
                this.writeln();
                ++JspParserTokenManager.level;
                for (int i = 1; i < lines.size() - 2; ++i) {
                    this.add((String)lines.get(i));
                    this.writeln();
                }
                --JspParserTokenManager.level;
                this.add((String)lines.get(lines.size() - 1));
                this.write();
            }
        }
    }

    public final void Text() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    this.UnparsedText();
                    break;
                }
                case 36: {
                    this.ElExpression();
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[10] = this.jj_gen;
    }

    public final void UnparsedText() throws ParseException {
        this.t = this.jj_consume_token(37);
        String s = this.t.image;
        if (JspParserTokenManager.collapseBlankLines) {
            String lsep = "\r".equals(this.ls) ? "\\r" : ("\r\n".equals(this.ls) ? "\\r\\n" : "\\n");
            String regex = "(([ ]|[\\t])*(" + lsep + ")){2,}";
            s = s.replaceAll(regex, this.ls + this.ls);
        }
        StringTokenizer st = new StringTokenizer(s, this.ls, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(this.ls)) {
                this.writeln();
                continue;
            }
            this.add(token);
        }
    }

    public final void UnparsedTextNoSingleQuotes() throws ParseException {
        this.t = this.jj_consume_token(73);
        this.add(this.t);
    }

    public final void UnparsedTextNoDoubleQuotes() throws ParseException {
        this.t = this.jj_consume_token(76);
        this.add(this.t);
    }

    public final void ElExpression() throws ParseException {
        this.t = this.jj_consume_token(36);
        this.add(this.t);
    }

    public final void ValueBindingInAttribute() throws ParseException {
        this.t = this.jj_consume_token(70);
        this.add(this.t);
    }

    public final void ElExpressionInAttribute() throws ParseException {
        this.t = this.jj_consume_token(69);
        this.add(this.t);
    }

    public final void CData() throws ParseException {
        this.t = this.jj_consume_token(30);
        this.writePre(this.getSpecial(this.t));
        this.add(this.t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.t = this.jj_consume_token(57);
            this.add(this.t);
        }
        this.t = this.jj_consume_token(58);
        this.add(this.t);
    }

    public final void Element() throws ParseException {
        boolean inPreTag = false;
        this.t = this.jj_consume_token(25);
        String s = this.getSpecial(this.t);
        if (!s.contains(this.ls) && this.getText().length() > 0) {
            this.trimNL();
            this.writeln();
        } else {
            this.writePre(s);
        }
        this.add(this.t);
        Token startTagName = this.jj_consume_token(59);
        String tagName = startTagName.image;
        this.add(startTagName);
        this.Attributes();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 62: {
                this.t = this.jj_consume_token(62);
                this.trimWhitespace();
                if (this.padTagEnd) {
                    this.add(" ");
                }
                this.add(this.t);
                this.write();
                ++JspParserTokenManager.level;
                if ("script".equalsIgnoreCase(startTagName.image)) {
                    this.writeln();
                    this.token_source.SwitchTo(2);
                } else if ("style".equalsIgnoreCase(startTagName.image)) {
                    this.writeln();
                    this.token_source.SwitchTo(1);
                } else if ("pre".equalsIgnoreCase(startTagName.image)) {
                    this.token_source.SwitchTo(0);
                    inPreTag = true;
                    this.trimNL();
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 80: 
                            case 81: {
                                this.HtmlScript();
                                break block4;
                            }
                            case 82: 
                            case 83: {
                                this.HtmlStyle();
                                break block4;
                            }
                            case 84: 
                            case 85: {
                                this.PreTag();
                                break block4;
                            }
                            case 25: 
                            case 27: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: {
                                this.Content();
                                break block4;
                            }
                        }
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                this.t = this.jj_consume_token(26);
                this.writePre(this.getSpecial(this.t));
                --JspParserTokenManager.level;
                this.add(this.t);
                Token endTagName = this.jj_consume_token(59);
                this.add(endTagName);
                if (!tagName.equalsIgnoreCase(endTagName.image)) {
                    throw new ParseException("Mismatch end tag: start tag '" + tagName + "' at " + startTagName.beginLine + ":" + startTagName.beginColumn + " does not match end tag '" + endTagName + "' at " + endTagName.beginLine + ":" + endTagName.beginColumn);
                }
                this.t = this.jj_consume_token(62);
                this.trimWhitespace();
                if (this.padTagEnd) {
                    this.add(" ");
                }
                this.add(this.t);
                this.write();
                break;
            }
            case 64: {
                this.t = this.jj_consume_token(64);
                this.trimWhitespace();
                if (this.padSlashEnd) {
                    this.add(" ");
                }
                this.add(this.t);
                this.write();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Attributes() throws ParseException {
        boolean first = true;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.Attribute(this.wrapAttributes && !first);
            first = false;
            this.add(" ");
        }
        this.trimWhitespace();
        this.write();
    }

    public final void Attribute(boolean onNextLine) throws ParseException {
        this.t = this.jj_consume_token(61);
        if (onNextLine) {
            this.writeln();
            JspParserTokenManager.level += 2;
        } else {
            this.add(" ");
        }
        this.add(this.t);
        this.t = this.jj_consume_token(65);
        this.add(this.t);
        this.AttributeValue();
        if (onNextLine) {
            JspParserTokenManager.level -= 2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void AttributeValue() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.t = this.jj_consume_token(68);
                this.add(this.t);
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: 
                        case 70: 
                        case 71: 
                        case 76: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            ** GOTO lbl23
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            this.UnparsedTextNoDoubleQuotes();
                            continue block26;
                        }
                        case 69: 
                        case 70: 
                        case 71: {
                            this.QuoteIndependentAttributeValueContent();
                            continue block26;
                        }
                    }
                    break;
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl23:
                // 1 sources

                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: {
                        this.t = this.jj_consume_token(75);
                        this.add(this.t);
                        break block0;
                    }
                    case 77: {
                        this.t = this.jj_consume_token(77);
                        this.add(this.t);
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 67: {
                this.t = this.jj_consume_token(67);
                this.add(this.t);
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: 
                        case 70: 
                        case 71: 
                        case 73: {
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            ** GOTO lbl57
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 73: {
                            this.UnparsedTextNoSingleQuotes();
                            continue block27;
                        }
                        case 69: 
                        case 70: 
                        case 71: {
                            this.QuoteIndependentAttributeValueContent();
                            continue block27;
                        }
                    }
                    break;
                }
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl57:
                // 1 sources

                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.t = this.jj_consume_token(72);
                        this.add(this.t);
                        break block0;
                    }
                    case 74: {
                        this.t = this.jj_consume_token(74);
                        this.add(this.t);
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void QuoteIndependentAttributeValueContent() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.ElExpressionInAttribute();
                break;
            }
            case 70: {
                this.ValueBindingInAttribute();
                break;
            }
            case 71: {
                this.JspExpressionInAttribute();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void JspExpressionInAttribute() throws ParseException {
        this.t = this.jj_consume_token(71);
        this.add(this.t);
    }

    public final void CommentTag() throws ParseException {
        String[] parts;
        ArrayList<String> lines = new ArrayList<String>();
        this.t = this.jj_consume_token(27);
        this.writePre(this.getSpecial(this.t));
        lines.add(this.t.image);
        this.t = this.jj_consume_token(79);
        String s = this.t.image;
        for (String line : parts = s.split(this.ls)) {
            lines.add(line);
        }
        this.t = this.jj_consume_token(78);
        if (lines.size() > 2 && !((String)lines.get(lines.size() - 1)).trim().isEmpty()) {
            lines.add(JspParserTokenManager.indent);
        }
        lines.add(this.t.image);
        StringBuilder sb = new StringBuilder();
        switch (lines.size()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                sb.append((String)lines.get(0));
                sb.append(" ");
                sb.append((String)lines.get(1));
                this.add(sb.toString());
                this.write();
                break;
            }
            case 3: {
                sb.append((String)lines.get(0));
                sb.append(" ");
                sb.append((String)lines.get(1));
                sb.append(" ");
                sb.append((String)lines.get(2));
                this.add(sb.toString());
                this.write();
                break;
            }
            default: {
                this.add((String)lines.get(0));
                this.write();
                ++JspParserTokenManager.level;
                for (int i = 1; i < lines.size() - 2; ++i) {
                    this.add((String)lines.get(i));
                    this.writeln();
                }
                --JspParserTokenManager.level;
                this.add((String)lines.get(lines.size() - 1));
                this.write();
            }
        }
    }

    public final void Declaration() throws ParseException {
        this.t = this.jj_consume_token(28);
        this.writePre(this.getSpecial(this.t));
        this.add(this.t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.Attribute(false);
        }
        this.t = this.jj_consume_token(63);
        this.add(this.t);
    }

    public final void DoctypeDeclaration() throws ParseException {
        this.t = this.jj_consume_token(29);
        this.add(this.t);
        this.t = this.jj_consume_token(51);
        this.add(this.t);
        this.t = this.jj_consume_token(52);
        this.add(this.t);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.t = this.jj_consume_token(51);
                this.add(this.t);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: 
            case 54: {
                this.DoctypeExternalId();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.t = this.jj_consume_token(51);
                        this.add(this.t);
                        break block3;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.t = this.jj_consume_token(55);
        this.add(this.t);
    }

    public final void DoctypeExternalId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.t = this.jj_consume_token(54);
                this.add(this.t);
                this.t = this.jj_consume_token(51);
                this.add(this.t);
                this.t = this.jj_consume_token(56);
                this.add(this.t);
                break;
            }
            case 53: {
                this.t = this.jj_consume_token(53);
                this.add(this.t);
                this.t = this.jj_consume_token(51);
                this.add(this.t);
                this.t = this.jj_consume_token(56);
                this.add(this.t);
                this.t = this.jj_consume_token(51);
                this.add(this.t);
                this.t = this.jj_consume_token(56);
                this.add(this.t);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PreTag() throws ParseException {
        StringBuilder sb = new StringBuilder();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.t = this.jj_consume_token(84);
            sb.append(this.t.image);
        }
        this.t = this.jj_consume_token(85);
        this.writePre(sb.toString());
    }

    public final void HtmlScript() throws ParseException {
        Token scriptToken = null;
        Token endToken = null;
        StringBuilder script = new StringBuilder();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 80: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block5;
                }
            }
            scriptToken = this.jj_consume_token(80);
            if (scriptToken == null) continue;
            script.append(scriptToken.image);
        }
        endToken = this.jj_consume_token(81);
        try {
            if (script.length() > 0) {
                DefaultBeautifier beautifier = new DefaultBeautifier("javascript");
                beautifier.setInitialIndentLevel(JspParserTokenManager.level);
                String js = ((Beautifier)beautifier).beautify(script.toString().trim());
                this.writePre(js);
            } else if (scriptToken != null) {
                this.add(scriptToken);
            }
        }
        catch (ParserException pe) {
            throw new ParseException(pe.getMessage());
        }
        if (endToken != null) {
            this.add(endToken);
        }
    }

    public final void HtmlStyle() throws ParseException {
        Token styleToken = null;
        Token endToken = null;
        StringBuilder style = new StringBuilder();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block5;
                }
            }
            styleToken = this.jj_consume_token(82);
            if (styleToken == null) continue;
            style.append(styleToken.image);
        }
        endToken = this.jj_consume_token(83);
        String ws = this.getSpecial(styleToken);
        boolean multiline = false;
        try {
            if (style.length() > 0) {
                CSSBeautifier beautifier = new CSSBeautifier();
                beautifier.setInitialIndentLevel(JspParserTokenManager.level);
                String css = ((Beautifier)beautifier).beautify(style.toString().trim());
                if (css == null || css.length() == 0) {
                    return;
                }
                boolean bl = multiline = css.indexOf(this.ls) > 0;
                if (ws != null && ws.length() > 0) {
                    this.writePre(ws);
                }
                if (multiline) {
                    this.writePre(css);
                } else {
                    this.add(" ");
                    this.add(css);
                    this.add(" ");
                }
                this.add(endToken);
            } else if (styleToken != null) {
                this.add(styleToken);
                if (endToken != null) {
                    this.add(endToken);
                }
            }
        }
        catch (ParserException pe) {
            throw new ParseException(pe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_scan_token(79)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_21() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_22()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_49() {
        return this.jj_3R_52();
    }

    private boolean jj_3_2() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_16());
        this.jj_scanpos = xsp;
        return this.jj_3R_17();
    }

    private boolean jj_3R_48() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_44() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_26() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        return this.jj_3R_25();
    }

    private boolean jj_3_1() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_14());
        this.jj_scanpos = xsp;
        return this.jj_3R_15();
    }

    private boolean jj_3R_43() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_24() {
        if (this.jj_3R_28()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_50()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_41() {
        return this.jj_3R_45();
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(52)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_24()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        Token xsp;
        if (this.jj_scan_token(67)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_38());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_20() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_33() {
        Token xsp;
        if (this.jj_scan_token(68)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_35());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_37()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        Token xsp;
        if (this.jj_scan_token(28)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_20());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_22() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_3R_30();
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_19() {
        return this.jj_3R_26();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-2013265920, -2013265920, -2013265920, -2013265920, -905969664, -905969664, -905969664, 0, 0, 0, 0, 0, -905969664, -905969664, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 63, 15, 15, 48, 128, 48, 48, 0x2000000, 63, 63, 0x40000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 524288, 524288, 0x600000, 0x600000, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3F0000, 0x3F0000, 1, 0, 4320, 4320, 10240, 736, 736, 1280, 24, 224, 0, 0, 0, 0, 0, 0x100000, 65536, 262144};
    }

    public JspParser(InputStream stream) {
        this(stream, null);
    }

    public JspParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JspParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JspParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JspParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JspParser(JspParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JspParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[86];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 32; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 86; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        JspParser.jj_la1_init_0();
        JspParser.jj_la1_init_1();
        JspParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

