/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.json;

import beauty.parsers.json.JavaCharStream;
import beauty.parsers.json.JsonParserConstants;
import beauty.parsers.json.JsonParserTokenManager;
import beauty.parsers.json.ParseException;
import beauty.parsers.json.Token;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class JsonParser
implements JsonParserConstants {
    Token t;
    String lineSep = System.getProperty("line.separator");
    public JsonParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public void setIndentWidth(int i) {
        JsonParserTokenManager.setIndentWidth(i);
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    public void setUseSoftTabs(boolean b) {
        JsonParserTokenManager.setUseSoftTabs(b);
    }

    public String getText() {
        JsonParser jsonParser = this;
        return jsonParser.token_source.getText();
    }

    public void resetTokenSource() {
        JsonParser jsonParser = this;
        jsonParser.token_source.reset();
    }

    private void add(Token t) {
        JsonParserTokenManager.add(t);
    }

    private void add(String s) {
        JsonParserTokenManager.add(s);
    }

    private void trim() {
        JsonParser jsonParser = this;
        jsonParser.token_source.trim();
    }

    private void trimWhitespace() {
        JsonParser jsonParser = this;
        jsonParser.token_source.trimWhitespace();
    }

    private void write() {
        JsonParser jsonParser = this;
        jsonParser.token_source.write();
    }

    private void writeln() {
        JsonParser jsonParser = this;
        jsonParser.token_source.writeln();
    }

    public void setLineSeparator(String le) {
        this.lineSep = le;
        JsonParserTokenManager.setLineSeparator(le);
    }

    public static void main(String[] args) {
        JsonParser parser;
        if (args.length == 0) {
            System.out.println("JSON Parser:  Reading from standard input . . .");
            parser = new JsonParser(System.in);
        } else if (args.length == 1) {
            System.out.println("JSON Parser:  Reading from file " + args[0] + " . . .");
            try {
                parser = new JsonParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("JSON Parser:  File " + args[0] + " not found.");
                return;
            }
        } else {
            System.out.println("JSON Parser:  Usage is one of:");
            System.out.println("         java JsonParser < inputfile");
            System.out.println("OR");
            System.out.println("         java JsonParser inputfile");
            return;
        }
        try {
            parser.enable_tracing();
            parser.parse();
            System.out.println("JSON Parser:  JSON input parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("JSON Parser:  Encountered errors during parse.");
            System.out.println(e.getMessage());
        }
    }

    public final void parse() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.object();
                this.jj_consume_token(0);
                break;
            }
            case 8: {
                this.array();
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.write();
    }

    public final void object() throws ParseException {
        this.jj_consume_token(6);
        this.writeln();
        this.add("{");
        this.writeln();
        ++JsonParserTokenManager.level;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.members();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.t = this.jj_consume_token(7);
        this.writeln();
        --JsonParserTokenManager.level;
        this.add("}");
        if (this.t.next != null && this.t.next.kind != 10) {
            this.writeln();
        }
    }

    public final void array() throws ParseException {
        this.jj_consume_token(8);
        this.add("[");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                this.elements();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        this.add("]");
    }

    public final void members() throws ParseException {
        this.key();
        this.jj_consume_token(11);
        this.add(": ");
        this.value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                this.trimWhitespace();
                this.add(", ");
                this.writeln();
                this.members();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    public final void elements() throws ParseException {
        this.value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                this.add(", ");
                this.elements();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final void value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.string();
                break;
            }
            case 15: {
                this.number();
                break;
            }
            case 6: {
                this.object();
                break;
            }
            case 8: {
                this.array();
                break;
            }
            case 12: {
                this.t = this.jj_consume_token(12);
                this.add(this.t);
                break;
            }
            case 13: {
                this.t = this.jj_consume_token(13);
                this.add(this.t);
                break;
            }
            case 14: {
                this.t = this.jj_consume_token(14);
                this.add(this.t);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void key() throws ParseException {
        this.t = this.jj_consume_token(17);
        this.add(this.t);
    }

    public final void string() throws ParseException {
        this.t = this.jj_consume_token(17);
        this.add(this.t);
    }

    public final void number() throws ParseException {
        this.t = this.jj_consume_token(15);
        this.add(this.t);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{320, 131072, 192832, 1024, 1024, 192832};
    }

    public JsonParser(InputStream stream) {
        this(stream, null);
    }

    public JsonParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JsonParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JsonParser(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[18];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 18; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JsonParser.jj_la1_init_0();
    }
}

