/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.java;

public final class ModifierSet {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;

    public static int visibilityRank(int modifiers) {
        if (ModifierSet.isPublic(modifiers)) {
            return 1;
        }
        if (ModifierSet.isPackage(modifiers)) {
            return 2;
        }
        if (ModifierSet.isProtected(modifiers)) {
            return 3;
        }
        return 4;
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isPackage(int modifiers) {
        return !ModifierSet.isPublic(modifiers) && !ModifierSet.isProtected(modifiers) && !ModifierSet.isPrivate(modifiers);
    }

    public static boolean isStatic(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static boolean isNative(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isStrictfp(int modifiers) {
        return (modifiers & 0x800) != 0;
    }

    public static boolean isSynchronized(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    public static boolean isTransient(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public static boolean isVolatile(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    static int removeModifier(int modifiers, int mod) {
        return modifiers & ~mod;
    }

    public static String toString(int modifiers) {
        StringBuffer sb = new StringBuffer();
        if (ModifierSet.isPublic(modifiers)) {
            sb.append("public ");
        } else if (ModifierSet.isProtected(modifiers)) {
            sb.append("protected ");
        } else if (ModifierSet.isPrivate(modifiers)) {
            sb.append("private ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            sb.append("static ");
        }
        sb.append(ModifierSet.modifiersAsString(modifiers));
        return sb.toString().trim();
    }

    public static String modifiersAsString(int modifiers) {
        if (modifiers == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (ModifierSet.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            sb.append("synchronized ");
        }
        if (ModifierSet.isNative(modifiers)) {
            sb.append("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            sb.append("strictfp ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        return sb.toString().trim();
    }
}

