/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.java;

import beauty.parsers.java.JavaParserConstants;
import beauty.parsers.java.SimpleCharStream;
import beauty.parsers.java.Token;
import beauty.parsers.java.TokenMgrError;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaParserTokenManager
implements JavaParserConstants {
    static StringBuilder b = new StringBuilder();
    static StringBuilder outputBuffer = new StringBuilder();
    static ArrayList a = new ArrayList();
    private static PrintWriter out = null;
    static int level = 0;
    static int indent_width = 4;
    static String indent = "    ";
    static String double_indent = indent + indent;
    static boolean useSoftTabs = true;
    static String ls = System.getProperty("line.separator");
    static char nbsp = (char)29;
    static int bracketStyle = 1;
    static boolean breakElse = false;
    static boolean padParens = false;
    public PrintStream debugStream = System.out;
    static final long[] jjbitVec0 = new long[]{0L, 0L, -1L, -1L};
    static final long[] jjbitVec1 = new long[]{2301339413881290750L, -16384L, 0xFFFFFFFFL, 0x600000000000000L};
    static final long[] jjbitVec3 = new long[]{0L, 0L, 0L, -36028797027352577L};
    static final long[] jjbitVec4 = new long[]{0L, -1L, -1L, -1L};
    static final long[] jjbitVec5 = new long[]{-1L, -1L, 65535L, 0L};
    static final long[] jjbitVec6 = new long[]{-1L, -1L, 0L, 0L};
    static final long[] jjbitVec7 = new long[]{0x3FFFFFFFFFFFL, 0L, 0L, 0L};
    static final int[] jjnextStates = new int[]{74, 75, 77, 42, 43, 44, 50, 51, 52, 55, 56, 57, 15, 68, 70, 1, 3, 0, 1, 3, 73, 84, 85, 31, 32, 34, 17, 19, 61, 63, 66, 8, 11, 10, 12, 15, 31, 32, 36, 34, 42, 43, 44, 45, 47, 15, 46, 47, 15, 45, 50, 51, 52, 55, 56, 57, 15, 65, 64, 8, 80, 81, 83, 87, 88, 90, 11, 10, 13, 14, 20, 25, 26, 28, 33, 35, 37, 42, 43, 46, 45, 48, 49, 50, 51, 53, 54, 55, 56, 58, 59};
    public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, null, null, null, null, null, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", null, null, null, null, null, null, null, null, null, null, null, null, "(", ")", "{", "}", "[", "]", ";", ",", ".", "@", "=", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "||", "&&", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>=", "...", ">>>", ">>", ">", "<>"};
    public static final String[] lexStateNames = new String[]{"DEFAULT"};
    static final long[] jjtoToken = new long[]{9223372036854775297L, 576460752303422696L};
    static final long[] jjtoSkip = new long[]{510L, 0L};
    static final long[] jjtoSpecial = new long[]{508L, 0L};
    protected SimpleCharStream input_stream;
    private final int[] jjrounds = new int[91];
    private final int[] jjstateSet = new int[182];
    private final StringBuilder jjimage;
    private StringBuilder image = this.jjimage = new StringBuilder();
    private int jjimageLen;
    private int lengthOfMatch;
    protected char curChar;
    int curLexState = 0;
    int defaultLexState = 0;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;

    static void reset() {
        b = new StringBuilder();
        outputBuffer = new StringBuilder();
        a.clear();
        level = 0;
    }

    static String getText() {
        return outputBuffer.toString();
    }

    static void setLineSeparator(String le) {
        ls = le;
    }

    static void setBracketStyle(int style) {
        bracketStyle = style;
    }

    static void setIndentWidth(int w) {
        indent_width = w;
        if (indent_width <= 0) {
            indent_width = 4;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < w; ++i) {
            sb.append(' ');
        }
        indent = sb.toString();
        double_indent = indent + indent;
    }

    static void setUseSoftTabs(boolean b) {
        useSoftTabs = b;
        if (b) {
            JavaParserTokenManager.setIndentWidth(indent_width);
        } else {
            indent = "\t";
            double_indent = "\t\t";
        }
    }

    static void setBreakElse(boolean b) {
        breakElse = b;
    }

    static void setPadParens(boolean pad) {
        padParens = pad;
    }

    static void add(Token t) {
        if (t != null) {
            a.add(t);
        }
    }

    static void add(String s) {
        if (s != null) {
            a.add(s);
        }
    }

    static void trim() {
        if (a.size() == 0) {
            return;
        }
        Object o = a.get(a.size() - 1);
        StringBuilder sb = new StringBuilder();
        if (o instanceof Token) {
            sb.append(((Token)o).image);
        } else {
            sb.append((String)o);
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        a.set(a.size() - 1, sb.toString());
    }

    static boolean trimNL() {
        boolean trimmed = false;
        if (outputBuffer.length() > 0 && outputBuffer.charAt(outputBuffer.length() - 1) == '\n') {
            outputBuffer.deleteCharAt(outputBuffer.length() - 1);
            trimmed = true;
        }
        if (outputBuffer.length() > 0 && outputBuffer.charAt(outputBuffer.length() - 1) == '\r') {
            outputBuffer.deleteCharAt(outputBuffer.length() - 1);
            trimmed = true;
        }
        return trimmed;
    }

    static void trimNL(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && (sb.charAt(sb.length() - 1) == '\r' || sb.charAt(sb.length() - 1) == '\n')) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    static String trimStart(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    static String trimStart(String s, int max) {
        StringBuilder sb = new StringBuilder(s);
        for (int trimmed = 0; sb.length() > 0 && Character.isWhitespace(sb.charAt(0)) && trimmed < max; ++trimmed) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    static void trimWhitespace() {
        for (int i = a.size() - 1; i >= 0; --i) {
            Object o = a.get(i);
            StringBuilder sb = new StringBuilder();
            if (o instanceof Token) {
                sb.append(((Token)o).image);
            } else {
                sb.append((String)o);
            }
            while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (sb.length() != 0) {
                a.set(i, sb.toString());
                break;
            }
            a.remove(i);
        }
        if (a.size() == 0) {
            while (outputBuffer.length() > 0 && Character.isWhitespace(outputBuffer.charAt(outputBuffer.length() - 1))) {
                outputBuffer.deleteCharAt(outputBuffer.length() - 1);
            }
        }
    }

    static void write() {
        try {
            int i;
            b.setLength(0);
            ArrayList<String> list = new ArrayList<String>();
            String s = new String("");
            for (i = 0; i < a.size(); ++i) {
                Object o = a.get(i);
                if (o instanceof Token) {
                    Token token = (Token)o;
                    if (token.kind == 70) {
                        s = s.replaceAll("[ ]+", " ");
                        list.add(s);
                        s = new String("");
                        list.add(token.image);
                        continue;
                    }
                    s = s + ((Token)o).image;
                    s = s.replaceAll("[ ]+", " ");
                    continue;
                }
                s = s + (String)o;
                s = s.replaceAll("[\u001d]", " ");
                s = s.replaceAll("[ ]+", " ");
            }
            for (i = 0; i < list.size(); ++i) {
                b.append((String)list.get(i));
            }
            b.append(s);
            s = b.toString();
            String maybe_blank = new String(s);
            if (maybe_blank.trim().length() == 0) {
                if (s.length() >= ls.length()) {
                    s = s.substring(0, s.length() - ls.length());
                }
                s = s.replaceAll(" ", "");
                s = s.replaceAll("\t", "");
                outputBuffer.append(s);
                a.clear();
                return;
            }
            if (!(s.startsWith(" else") || s.startsWith(" catch") || s.startsWith(" finally") || s.startsWith(" ^while") || s.startsWith(" {") || JavaParserTokenManager.endsWith(outputBuffer, "else") || JavaParserTokenManager.endsWith(outputBuffer, "else "))) {
                s = s.trim();
                for (int i2 = 0; i2 < level; ++i2) {
                    s = indent + s;
                }
            }
            if (s.startsWith(" ^while")) {
                b.deleteCharAt(1);
                s = b.toString();
            }
            if (!JavaParserTokenManager.endsWith(outputBuffer, "\n") && !JavaParserTokenManager.endsWith(outputBuffer, "\r")) {
                s = JavaParserTokenManager.trimStart(s);
            }
            if (s.startsWith(" ") && JavaParserTokenManager.endsWith(outputBuffer, " ")) {
                s = s.substring(1);
            }
            if (!(s.startsWith(" ") || s.startsWith(";") || JavaParserTokenManager.endsWith(outputBuffer, " ") || JavaParserTokenManager.endsWith(outputBuffer, "\r") || JavaParserTokenManager.endsWith(outputBuffer, "\n") || outputBuffer.length() <= 0)) {
                outputBuffer.append(" ");
            }
            String startParen = padParens ? "( " : "(";
            String endParen = padParens ? " )" : ")";
            s = s.replaceAll("[(][ ]", startParen);
            s = s.replaceAll("[ ][)]", endParen);
            s = s.replaceAll("[(]\\s+[)]", "()");
            s = s.replaceAll("[\\^][)]", ")");
            s = s.replaceAll("\\s+[,]", ",");
            s = s.replaceAll("\\s+[;]", ";");
            outputBuffer.append(s);
            a.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void writeln() {
        JavaParserTokenManager.write();
        JavaParserTokenManager.trimNL();
        outputBuffer.append(ls);
    }

    static int countWrapSep(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\u001c') continue;
            ++count;
        }
        return count;
    }

    static String[] wrapLines(String s) {
        if (s.length() <= 80) {
            return new String[]{s};
        }
        int wc = JavaParserTokenManager.countWrapSep(s);
        if (wc > 0) {
            int possible;
            int[] break_points = new int[wc];
            int offset = 0;
            for (int i = 0; i < wc; ++i) {
                int index;
                break_points[i] = index = s.indexOf(28, offset);
                offset = index + 1;
            }
            int first_break = -1;
            for (int i = 0; i < break_points.length && (possible = break_points[i]) <= 80; ++i) {
                first_break = possible;
            }
            if (first_break == -1) {
                first_break = s.length();
            }
            int ws_length = 0;
            for (int i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
                ++ws_length;
            }
            String leading_ws = s.substring(0, ws_length);
            String head = s.substring(0, first_break);
            String tail = s.substring(first_break);
            return new String[]{head, leading_ws + double_indent + tail};
        }
        return null;
    }

    static boolean endsWith(StringBuilder sb, String s) {
        if (sb == null && s == null) {
            return true;
        }
        if (sb == null && s != null) {
            return false;
        }
        if (sb.length() < s.length()) {
            return false;
        }
        String end = sb.substring(sb.length() - s.length());
        return end.equals(s);
    }

    static void writeJavadocComment(String s) {
        String[] lines = s.split(ls);
        String line = lines[0].trim();
        for (int j = 0; j < level; ++j) {
            line = indent + line;
        }
        outputBuffer.append(line);
        for (int i = 1; i < lines.length; ++i) {
            outputBuffer.append(ls);
            line = lines[i].trim();
            line = line.startsWith("*") ? " " + line : " * " + line;
            for (int j = 0; j < level; ++j) {
                line = indent + line;
            }
            outputBuffer.append(line);
        }
    }

    static void writeBlockComment(String s) {
        int j;
        String[] lines = s.split(ls);
        String line = lines[0].trim();
        for (j = 0; j < level; ++j) {
            line = indent + line;
        }
        outputBuffer.append(line);
        for (int i = 1; i < lines.length - 1; ++i) {
            outputBuffer.append(ls);
            line = lines[i];
            outputBuffer.append(line);
        }
        if (lines.length > 1) {
            outputBuffer.append(ls);
            line = lines[lines.length - 1].trim();
            for (j = 0; j < level; ++j) {
                line = indent + line;
            }
            outputBuffer.append(line);
        }
    }

    static void writeEndOfLineComment(String s) {
        Pattern p;
        Matcher m;
        String line = s.trim();
        if (line.startsWith("//") && (m = (p = Pattern.compile("(//+)(.*?)")).matcher(line)).matches()) {
            String start = m.group(1);
            line = m.group(2).trim();
            line = start + " " + line;
        }
        for (int j = 0; j < level; ++j) {
            line = indent + line;
        }
        outputBuffer.append(line).append(ls);
    }

    public void setDebugStream(PrintStream ds) {
        this.debugStream = ds;
    }

    private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x402000000000L) != 0L) {
                    return 73;
                }
                if ((active1 & 0x40000000040000L) != 0L) {
                    return 10;
                }
                if ((active0 & 0x3FFFFFFFFFFFFE00L) != 0L) {
                    this.jjmatchedKind = 71;
                    return 40;
                }
                return -1;
            }
            case 1: {
                if ((active0 & 0x3FFFFFFEFF9FFE00L) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 71;
                        this.jjmatchedPos = 1;
                    }
                    return 40;
                }
                if ((active0 & 0x100600000L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 2: {
                if ((active0 & 0x3BFFFECEBFDFFE00L) != 0L) {
                    if (this.jjmatchedPos != 2) {
                        this.jjmatchedKind = 71;
                        this.jjmatchedPos = 2;
                    }
                    return 40;
                }
                if ((active0 & 0x400013040000000L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 3: {
                if ((active0 & 0xA20024081816000L) != 0L) {
                    return 40;
                }
                if ((active0 & 0x31DFFCAE3E5E9E00L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 3;
                    return 40;
                }
                return -1;
            }
            case 4: {
                if ((active0 & 0x111B7CAE02580E00L) != 0L) {
                    if (this.jjmatchedPos != 4) {
                        this.jjmatchedKind = 71;
                        this.jjmatchedPos = 4;
                    }
                    return 40;
                }
                if ((active0 & 0x20C480003C069000L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 5: {
                if ((active0 & 0x11121C2A12180A00L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 5;
                    return 40;
                }
                if ((active0 & 0x89608400400400L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 6: {
                if ((active0 & 0x1112102A00080200L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 6;
                    return 40;
                }
                if ((active0 & 0xC0012100800L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 7: {
                if ((active0 & 0x1002000000080200L) != 0L) {
                    return 40;
                }
                if ((active0 & 0x110102A00000000L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 7;
                    return 40;
                }
                return -1;
            }
            case 8: {
                if ((active0 & 0x10000A00000000L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 8;
                    return 40;
                }
                if ((active0 & 0x100102000000000L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 9: {
                if ((active0 & 0x10000000000000L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 9;
                    return 40;
                }
                if ((active0 & 0xA00000000L) != 0L) {
                    return 40;
                }
                return -1;
            }
            case 10: {
                if ((active0 & 0x10000000000000L) != 0L) {
                    this.jjmatchedKind = 71;
                    this.jjmatchedPos = 10;
                    return 40;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_0(int pos, long active0, long active1) {
        return this.jjMoveNfa_0(this.jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
    }

    private int jjStopAtPos(int pos, int kind) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        return pos + 1;
    }

    private int jjMoveStringLiteralDfa0_0() {
        switch (this.curChar) {
            case '!': {
                this.jjmatchedKind = 86;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x20000000L);
            }
            case '%': {
                this.jjmatchedKind = 105;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x4000000000000L);
            }
            case '&': {
                this.jjmatchedKind = 102;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x800080000000L);
            }
            case '(': {
                return this.jjStopAtPos(0, 74);
            }
            case ')': {
                return this.jjStopAtPos(0, 75);
            }
            case '*': {
                this.jjmatchedKind = 100;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x200000000000L);
            }
            case '+': {
                this.jjmatchedKind = 98;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x80100000000L);
            }
            case ',': {
                return this.jjStopAtPos(0, 81);
            }
            case '-': {
                this.jjmatchedKind = 99;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x100200000000L);
            }
            case '.': {
                this.jjmatchedKind = 82;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x40000000000000L);
            }
            case '/': {
                this.jjmatchedKind = 101;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x400000000000L);
            }
            case ':': {
                return this.jjStopAtPos(0, 89);
            }
            case ';': {
                return this.jjStopAtPos(0, 80);
            }
            case '<': {
                this.jjmatchedKind = 85;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x408040008000000L);
            }
            case '=': {
                this.jjmatchedKind = 84;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x4000000L);
            }
            case '>': {
                this.jjmatchedKind = 121;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x1B0000010000000L);
            }
            case '?': {
                return this.jjStopAtPos(0, 88);
            }
            case '@': {
                return this.jjStopAtPos(0, 83);
            }
            case '[': {
                return this.jjStopAtPos(0, 78);
            }
            case ']': {
                return this.jjStopAtPos(0, 79);
            }
            case '^': {
                this.jjmatchedKind = 104;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x2000000000000L);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa1_0(1536L, 0L);
            }
            case 'b': {
                return this.jjMoveStringLiteralDfa1_0(14336L, 0L);
            }
            case 'c': {
                return this.jjMoveStringLiteralDfa1_0(1032192L, 0L);
            }
            case 'd': {
                return this.jjMoveStringLiteralDfa1_0(0x700000L, 0L);
            }
            case 'e': {
                return this.jjMoveStringLiteralDfa1_0(0x3800000L, 0L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa1_0(0x7C000000L, 0L);
            }
            case 'g': {
                return this.jjMoveStringLiteralDfa1_0(0x80000000L, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa1_0(0x3F00000000L, 0L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa1_0(0x4000000000L, 0L);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa1_0(0x38000000000L, 0L);
            }
            case 'p': {
                return this.jjMoveStringLiteralDfa1_0(0x3C0000000000L, 0L);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa1_0(0x400000000000L, 0L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa1_0(8866461766385664L, 0L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa1_0(0x7E0000000000000L, 0L);
            }
            case 'v': {
                return this.jjMoveStringLiteralDfa1_0(0x1800000000000000L, 0L);
            }
            case 'w': {
                return this.jjMoveStringLiteralDfa1_0(0x2000000000000000L, 0L);
            }
            case '{': {
                return this.jjStopAtPos(0, 76);
            }
            case '|': {
                this.jjmatchedKind = 103;
                return this.jjMoveStringLiteralDfa1_0(0L, 0x1000040000000L);
            }
            case '}': {
                return this.jjStopAtPos(0, 77);
            }
            case '~': {
                return this.jjStopAtPos(0, 87);
            }
        }
        return this.jjMoveNfa_0(6, 0);
    }

    private int jjMoveStringLiteralDfa1_0(long active0, long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(0, active0, active1);
            return 1;
        }
        switch (this.curChar) {
            case '&': {
                if ((active1 & 0x80000000L) == 0L) break;
                return this.jjStopAtPos(1, 95);
            }
            case '+': {
                if ((active1 & 0x100000000L) == 0L) break;
                return this.jjStopAtPos(1, 96);
            }
            case '-': {
                if ((active1 & 0x200000000L) == 0L) break;
                return this.jjStopAtPos(1, 97);
            }
            case '.': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0L, active1, 0x40000000000000L);
            }
            case '<': {
                if ((active1 & 0x40000000000L) != 0L) {
                    this.jjmatchedKind = 106;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_0(active0, 0L, active1, 0x8000000000000L);
            }
            case '=': {
                if ((active1 & 0x4000000L) != 0L) {
                    return this.jjStopAtPos(1, 90);
                }
                if ((active1 & 0x8000000L) != 0L) {
                    return this.jjStopAtPos(1, 91);
                }
                if ((active1 & 0x10000000L) != 0L) {
                    return this.jjStopAtPos(1, 92);
                }
                if ((active1 & 0x20000000L) != 0L) {
                    return this.jjStopAtPos(1, 93);
                }
                if ((active1 & 0x80000000000L) != 0L) {
                    return this.jjStopAtPos(1, 107);
                }
                if ((active1 & 0x100000000000L) != 0L) {
                    return this.jjStopAtPos(1, 108);
                }
                if ((active1 & 0x200000000000L) != 0L) {
                    return this.jjStopAtPos(1, 109);
                }
                if ((active1 & 0x400000000000L) != 0L) {
                    return this.jjStopAtPos(1, 110);
                }
                if ((active1 & 0x800000000000L) != 0L) {
                    return this.jjStopAtPos(1, 111);
                }
                if ((active1 & 0x1000000000000L) != 0L) {
                    return this.jjStopAtPos(1, 112);
                }
                if ((active1 & 0x2000000000000L) != 0L) {
                    return this.jjStopAtPos(1, 113);
                }
                if ((active1 & 0x4000000000000L) == 0L) break;
                return this.jjStopAtPos(1, 114);
            }
            case '>': {
                if ((active1 & 0x100000000000000L) != 0L) {
                    this.jjmatchedKind = 120;
                    this.jjmatchedPos = 1;
                } else if ((active1 & 0x400000000000000L) != 0L) {
                    return this.jjStopAtPos(1, 122);
                }
                return this.jjMoveStringLiteralDfa2_0(active0, 0L, active1, 0xB0000000000000L);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa2_0(active0, 4947869483008L, active1, 0L);
            }
            case 'b': {
                return this.jjMoveStringLiteralDfa2_0(active0, 512L, active1, 0L);
            }
            case 'e': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x410000100000L, active1, 0L);
            }
            case 'f': {
                if ((active0 & 0x100000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(1, 32, 40);
            }
            case 'h': {
                return this.jjMoveStringLiteralDfa2_0(active0, 2369034141485301760L, active1, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x18000000L, active1, 0L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x20820000L, active1, 0L);
            }
            case 'm': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x600000000L, active1, 0L);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa2_0(active0, 240534945792L, active1, 0L);
            }
            case 'o': {
                if ((active0 & 0x200000L) != 0L) {
                    this.jjmatchedKind = 21;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_0(active0, 1729382535014385664L, active1, 0L);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa2_0(active0, 504429546544566272L, active1, 0L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa2_0(active0, 1024L, active1, 0L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x3000000000000L, active1, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x4220000000000L, active1, 0L);
            }
            case 'w': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x8000000000000L, active1, 0L);
            }
            case 'x': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x2000000L, active1, 0L);
            }
            case 'y': {
                return this.jjMoveStringLiteralDfa2_0(active0, 0x10000000002000L, active1, 0L);
            }
            case '|': {
                if ((active1 & 0x40000000L) == 0L) break;
                return this.jjStopAtPos(1, 94);
            }
        }
        return this.jjStartNfa_0(0, active0, active1);
    }

    private int jjMoveStringLiteralDfa2_0(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_0(0, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(1, active0, active1);
            return 2;
        }
        switch (this.curChar) {
            case '.': {
                if ((active1 & 0x40000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 118);
            }
            case '=': {
                if ((active1 & 0x8000000000000L) != 0L) {
                    return this.jjStopAtPos(2, 115);
                }
                if ((active1 & 0x10000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 116);
            }
            case '>': {
                if ((active1 & 0x80000000000000L) != 0L) {
                    this.jjmatchedKind = 119;
                    this.jjmatchedPos = 2;
                }
                return this.jjMoveStringLiteralDfa3_0(active0, 0L, active1, 0x20000000000000L);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x101000000030000L, active1, 0L);
            }
            case 'b': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x200000000000L, active1, 0L);
            }
            case 'c': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x40000000000L, active1, 0L);
            }
            case 'e': {
                return this.jjMoveStringLiteralDfa3_0(active0, 4096L, active1, 0L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x100000L, active1, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x2828080000000000L, active1, 0L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa3_0(active0, 1152923703697211392L, active1, 0L);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa3_0(active0, 4503874908717056L, active1, 0L);
            }
            case 'o': {
                return this.jjMoveStringLiteralDfa3_0(active0, 158330211272704L, active1, 0L);
            }
            case 'p': {
                return this.jjMoveStringLiteralDfa3_0(active0, 0x4000600000000L, active1, 0L);
            }
            case 'r': {
                if ((active0 & 0x40000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(2, 30, 40);
                }
                return this.jjMoveStringLiteralDfa3_0(active0, 0xC2000000000000L, active1, 0L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa3_0(active0, 34368144896L, active1, 0L);
            }
            case 't': {
                if ((active0 & 0x1000000000L) != 0L) {
                    this.jjmatchedKind = 36;
                    this.jjmatchedPos = 2;
                }
                return this.jjMoveStringLiteralDfa3_0(active0, 71058120024064L, active1, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa3_0(active0, 144115188096827392L, active1, 0L);
            }
            case 'w': {
                if ((active0 & 0x10000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(2, 40, 40);
            }
            case 'y': {
                if ((active0 & 0x400000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(2, 58, 40);
            }
        }
        return this.jjStartNfa_0(1, active0, active1);
    }

    private int jjMoveStringLiteralDfa3_0(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_0(1, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(2, active0, active1);
            return 3;
        }
        switch (this.curChar) {
            case '=': {
                if ((active1 & 0x20000000000000L) == 0L) break;
                return this.jjStopAtPos(3, 117);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa4_0(active0, 1152921505547423744L, active1, 0L);
            }
            case 'b': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x400000L, active1, 0L);
            }
            case 'c': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x10000000008000L, active1, 0L);
            }
            case 'd': {
                if ((active0 & 0x800000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(3, 59, 40);
            }
            case 'e': {
                if ((active0 & 0x2000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 13, 40);
                }
                if ((active0 & 0x4000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 14, 40);
                }
                if ((active0 & 0x800000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 23, 40);
                }
                if ((active0 & 0x200000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 57, 40);
                }
                return this.jjMoveStringLiteralDfa4_0(active0, 0x4002002000400L, active1, 0L);
            }
            case 'g': {
                if ((active0 & 0x4000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(3, 38, 40);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x2008000000000L, active1, 0L);
            }
            case 'k': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x40000000000L, active1, 0L);
            }
            case 'l': {
                if ((active0 & 0x20000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 41, 40);
                }
                return this.jjMoveStringLiteralDfa4_0(active0, 0x2000200200000800L, active1, 0L);
            }
            case 'm': {
                if ((active0 & 0x1000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(3, 24, 40);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x100000000000000L, active1, 0L);
            }
            case 'o': {
                if ((active0 & 0x80000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 31, 40);
                }
                return this.jjMoveStringLiteralDfa4_0(active0, 0xC0000400000000L, active1, 0L);
            }
            case 'r': {
                if ((active0 & 0x10000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 16, 40);
                }
                return this.jjMoveStringLiteralDfa4_0(active0, 0x800000000000L, active1, 0L);
            }
            case 's': {
                if ((active0 & 0x20000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(3, 53, 40);
                }
                return this.jjMoveStringLiteralDfa4_0(active0, 0x4060000L, active1, 0L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa4_0(active0, 2550901336703488L, active1, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x400000000000L, active1, 0L);
            }
            case 'v': {
                return this.jjMoveStringLiteralDfa4_0(active0, 0x80000000000L, active1, 0L);
            }
        }
        return this.jjStartNfa_0(2, active0, active1);
    }

    private int jjMoveStringLiteralDfa4_0(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_0(2, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(3, active0, 0L);
            return 4;
        }
        switch (this.curChar) {
            case 'a': {
                return this.jjMoveStringLiteralDfa5_0(active0, 0xC0800000000L);
            }
            case 'c': {
                return this.jjMoveStringLiteralDfa5_0(active0, 0xA000000000000L);
            }
            case 'e': {
                if ((active0 & 0x4000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 26, 40);
                }
                if ((active0 & 0x2000000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 61, 40);
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 17600775981056L);
            }
            case 'h': {
                if ((active0 & 0x8000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 15, 40);
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 0x10000000000000L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa5_0(active0, 316659349323776L);
            }
            case 'k': {
                if ((active0 & 0x1000L) == 0L) break;
                return this.jjStartNfaWithStates_0(4, 12, 40);
            }
            case 'l': {
                if ((active0 & 0x8000000L) != 0L) {
                    this.jjmatchedKind = 27;
                    this.jjmatchedPos = 4;
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 0x10400000L);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa5_0(active0, 0x2000000L);
            }
            case 'r': {
                if ((active0 & 0x4000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 50, 40);
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 70523363001856L);
            }
            case 's': {
                if ((active0 & 0x20000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 17, 40);
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 0x100000000000000L);
            }
            case 't': {
                if ((active0 & 0x40000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 18, 40);
                }
                if ((active0 & 0x20000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 29, 40);
                }
                if ((active0 & 0x800000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(4, 47, 40);
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 0x1000000000000000L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa5_0(active0, 0x100000L);
            }
            case 'v': {
                return this.jjMoveStringLiteralDfa5_0(active0, 0x8000000000L);
            }
            case 'w': {
                if ((active0 & 0x40000000000000L) != 0L) {
                    this.jjmatchedKind = 54;
                    this.jjmatchedPos = 4;
                }
                return this.jjMoveStringLiteralDfa5_0(active0, 0x80000000000000L);
            }
        }
        return this.jjStartNfa_0(3, active0, 0L);
    }

    private int jjMoveStringLiteralDfa5_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(3, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(4, active0, 0L);
            return 5;
        }
        switch (this.curChar) {
            case 'a': {
                return this.jjMoveStringLiteralDfa6_0(active0, 2560L);
            }
            case 'c': {
                if ((active0 & 0x200000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 45, 40);
                }
                if ((active0 & 0x1000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 48, 40);
                }
                return this.jjMoveStringLiteralDfa6_0(active0, 0x100000000000L);
            }
            case 'd': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x2000000L);
            }
            case 'e': {
                if ((active0 & 0x400000L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 22, 40);
                }
                if ((active0 & 0x8000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(5, 39, 40);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x2000000000L);
            }
            case 'g': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
            }
            case 'h': {
                if ((active0 & 0x8000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(5, 51, 40);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x1100000000000000L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x10100000L);
            }
            case 'm': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x200000000L);
            }
            case 'n': {
                if ((active0 & 0x400000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 46, 40);
                }
                return this.jjMoveStringLiteralDfa6_0(active0, 0x800080000L);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa6_0(active0, 0x10000000000000L);
            }
            case 's': {
                if ((active0 & 0x80000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(5, 55, 40);
            }
            case 't': {
                if ((active0 & 0x400L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 10, 40);
                }
                if ((active0 & 0x400000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(5, 34, 40);
                }
                return this.jjMoveStringLiteralDfa6_0(active0, 0x2080000000000L);
            }
        }
        return this.jjStartNfa_0(4, active0, 0L);
    }

    private int jjMoveStringLiteralDfa6_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(4, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(5, active0, 0L);
            return 6;
        }
        switch (this.curChar) {
            case 'a': {
                return this.jjMoveStringLiteralDfa7_0(active0, 0x2000000000L);
            }
            case 'c': {
                return this.jjMoveStringLiteralDfa7_0(active0, 0x800000200L);
            }
            case 'e': {
                if ((active0 & 0x40000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(6, 42, 40);
                }
                if ((active0 & 0x80000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(6, 43, 40);
                }
                return this.jjMoveStringLiteralDfa7_0(active0, 0x100000200000000L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa7_0(active0, 0x2000000000000L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa7_0(active0, 0x1000000000000000L);
            }
            case 'n': {
                if ((active0 & 0x800L) == 0L) break;
                return this.jjStartNfaWithStates_0(6, 11, 40);
            }
            case 'o': {
                return this.jjMoveStringLiteralDfa7_0(active0, 0x10000000000000L);
            }
            case 's': {
                if ((active0 & 0x2000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(6, 25, 40);
            }
            case 't': {
                if ((active0 & 0x100000L) != 0L) {
                    return this.jjStartNfaWithStates_0(6, 20, 40);
                }
                return this.jjMoveStringLiteralDfa7_0(active0, 0x100000000000L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa7_0(active0, 524288L);
            }
            case 'y': {
                if ((active0 & 0x10000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(6, 28, 40);
            }
        }
        return this.jjStartNfa_0(5, active0, 0L);
    }

    private int jjMoveStringLiteralDfa7_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(5, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(6, active0, 0L);
            return 7;
        }
        switch (this.curChar) {
            case 'c': {
                return this.jjMoveStringLiteralDfa8_0(active0, 0x2000000000L);
            }
            case 'e': {
                if ((active0 & 0x80000L) != 0L) {
                    return this.jjStartNfaWithStates_0(7, 19, 40);
                }
                if ((active0 & 0x1000000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(7, 60, 40);
                }
                return this.jjMoveStringLiteralDfa8_0(active0, 0x100800000000L);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa8_0(active0, 0x110000200000000L);
            }
            case 'p': {
                if ((active0 & 0x2000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(7, 49, 40);
            }
            case 't': {
                if ((active0 & 0x200L) == 0L) break;
                return this.jjStartNfaWithStates_0(7, 9, 40);
            }
        }
        return this.jjStartNfa_0(6, active0, 0L);
    }

    private int jjMoveStringLiteralDfa8_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(6, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(7, active0, 0L);
            return 8;
        }
        switch (this.curChar) {
            case 'd': {
                if ((active0 & 0x100000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(8, 44, 40);
            }
            case 'e': {
                if ((active0 & 0x2000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(8, 37, 40);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa9_0(active0, 0x10000000000000L);
            }
            case 'o': {
                return this.jjMoveStringLiteralDfa9_0(active0, 0x800000000L);
            }
            case 't': {
                if ((active0 & 0x100000000000000L) != 0L) {
                    return this.jjStartNfaWithStates_0(8, 56, 40);
                }
                return this.jjMoveStringLiteralDfa9_0(active0, 0x200000000L);
            }
        }
        return this.jjStartNfa_0(7, active0, 0L);
    }

    private int jjMoveStringLiteralDfa9_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(7, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(8, active0, 0L);
            return 9;
        }
        switch (this.curChar) {
            case 'f': {
                if ((active0 & 0x800000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(9, 35, 40);
            }
            case 's': {
                if ((active0 & 0x200000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(9, 33, 40);
            }
            case 'z': {
                return this.jjMoveStringLiteralDfa10_0(active0, 0x10000000000000L);
            }
        }
        return this.jjStartNfa_0(8, active0, 0L);
    }

    private int jjMoveStringLiteralDfa10_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(8, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(9, active0, 0L);
            return 10;
        }
        switch (this.curChar) {
            case 'e': {
                return this.jjMoveStringLiteralDfa11_0(active0, 0x10000000000000L);
            }
        }
        return this.jjStartNfa_0(9, active0, 0L);
    }

    private int jjMoveStringLiteralDfa11_0(long old0, long active0) {
        if ((active0 &= old0) == 0L) {
            return this.jjStartNfa_0(9, old0, 0L);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(10, active0, 0L);
            return 11;
        }
        switch (this.curChar) {
            case 'd': {
                if ((active0 & 0x10000000000000L) == 0L) break;
                return this.jjStartNfaWithStates_0(11, 52, 40);
            }
        }
        return this.jjStartNfa_0(10, active0, 0L);
    }

    private int jjStartNfaWithStates_0(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_0(state, pos + 1);
    }

    private int jjMoveNfa_0(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 91;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                long l = 1L << this.curChar;
                block123: do {
                    switch (this.jjstateSet[--i]) {
                        case 73: {
                            if (this.curChar == '*') {
                                this.jjCheckNAddTwoStates(86, 87);
                            } else if (this.curChar == '/') {
                                this.jjCheckNAddStates(0, 2);
                            }
                            if (this.curChar != '*') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 78;
                            break;
                        }
                        case 6: {
                            if ((0x3FF000000000000L & l) != 0L) {
                                this.jjCheckNAddStates(3, 12);
                            } else if ((0x2400L & l) != 0L) {
                                if (kind > 2) {
                                    kind = 2;
                                }
                                this.jjCheckNAddStates(13, 16);
                            } else if ((0x100000200L & l) != 0L) {
                                this.jjCheckNAddStates(17, 19);
                            } else if (this.curChar == '/') {
                                this.jjAddStates(20, 22);
                            } else if (this.curChar == '$') {
                                if (kind > 71) {
                                    kind = 71;
                                }
                                this.jjCheckNAdd(40);
                            } else if (this.curChar == '\"') {
                                this.jjCheckNAddStates(23, 25);
                            } else if (this.curChar == '\'') {
                                this.jjAddStates(26, 27);
                            } else if (this.curChar == '.') {
                                this.jjCheckNAdd(10);
                            }
                            if ((0x3FE000000000000L & l) != 0L) {
                                if (kind > 62) {
                                    kind = 62;
                                }
                                this.jjCheckNAddTwoStates(7, 8);
                                break;
                            }
                            if (this.curChar == '\r') {
                                this.jjCheckNAddTwoStates(69, 2);
                                break;
                            }
                            if (this.curChar == '0') {
                                if (kind > 62) {
                                    kind = 62;
                                }
                                this.jjCheckNAddStates(28, 31);
                                break;
                            }
                            if (this.curChar == '\t') {
                                if (kind > 5) {
                                    kind = 5;
                                }
                                this.jjCheckNAdd(5);
                                break;
                            }
                            if (this.curChar != ' ') break;
                            if (kind > 4) {
                                kind = 4;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 0: {
                            if ((0x100000200L & l) == 0L) break;
                            this.jjCheckNAddStates(17, 19);
                            break;
                        }
                        case 1: {
                            if ((0x2400L & l) == 0L) continue block123;
                            if (kind > 3) {
                                kind = 3;
                            }
                            this.jjCheckNAddTwoStates(1, 3);
                            break;
                        }
                        case 2: {
                            if (this.curChar != '\n') continue block123;
                            if (kind > 3) {
                                kind = 3;
                            }
                            this.jjCheckNAddTwoStates(1, 3);
                            break;
                        }
                        case 3: {
                            if (this.curChar != '\r') break;
                            this.jjCheckNAdd(2);
                            break;
                        }
                        case 4: {
                            if (this.curChar != ' ') continue block123;
                            if (kind > 4) {
                                kind = 4;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 5: {
                            if (this.curChar != '\t') continue block123;
                            if (kind > 5) {
                                kind = 5;
                            }
                            this.jjCheckNAdd(5);
                            break;
                        }
                        case 7: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddTwoStates(7, 8);
                            break;
                        }
                        case 9: {
                            if (this.curChar != '.') break;
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 10: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddStates(32, 35);
                            break;
                        }
                        case 13: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(14);
                            break;
                        }
                        case 14: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddTwoStates(14, 15);
                            break;
                        }
                        case 16: {
                            if (this.curChar != '\'') break;
                            this.jjAddStates(26, 27);
                            break;
                        }
                        case 17: {
                            if ((0xFFFFFF7FFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 18: {
                            if (this.curChar != '\'' || kind <= 69) continue block123;
                            kind = 69;
                            break;
                        }
                        case 21: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 22;
                            break;
                        }
                        case 22: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 23;
                            break;
                        }
                        case 23: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 24;
                            break;
                        }
                        case 24: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 25: {
                            if ((0x8400000000L & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 26: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(27, 18);
                            break;
                        }
                        case 27: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 28: {
                            if ((0xF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 29;
                            break;
                        }
                        case 29: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 30: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 31: {
                            if ((0xFFFFFFFBFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 33: {
                            if ((0x8400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 34: {
                            if (this.curChar != '\"' || kind <= 70) continue block123;
                            kind = 70;
                            break;
                        }
                        case 35: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(36, 39);
                            break;
                        }
                        case 36: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 37: {
                            if ((0xF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 38;
                            break;
                        }
                        case 38: {
                            if ((0xFF000000000000L & l) == 0L) break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 39: {
                            if (this.curChar != '$') continue block123;
                            if (kind > 71) {
                                kind = 71;
                            }
                            this.jjCheckNAdd(40);
                            break;
                        }
                        case 40: {
                            if ((0x3FF001000000000L & l) == 0L) continue block123;
                            if (kind > 71) {
                                kind = 71;
                            }
                            this.jjCheckNAdd(40);
                            break;
                        }
                        case 41: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(3, 12);
                            break;
                        }
                        case 43: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(40, 42);
                            break;
                        }
                        case 44: {
                            if (this.curChar != '.') continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddStates(43, 45);
                            break;
                        }
                        case 45: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddStates(46, 49);
                            break;
                        }
                        case 48: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(49);
                            break;
                        }
                        case 49: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddTwoStates(49, 15);
                            break;
                        }
                        case 51: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(50, 52);
                            break;
                        }
                        case 53: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(54);
                            break;
                        }
                        case 54: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 67) {
                                kind = 67;
                            }
                            this.jjCheckNAddTwoStates(54, 15);
                            break;
                        }
                        case 56: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(53, 56);
                            break;
                        }
                        case 58: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(59);
                            break;
                        }
                        case 59: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(59, 15);
                            break;
                        }
                        case 60: {
                            if (this.curChar != '0') continue block123;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddStates(28, 31);
                            break;
                        }
                        case 62: {
                            if ((0x3FF000000000000L & l) == 0L) continue block123;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddTwoStates(62, 8);
                            break;
                        }
                        case 64: {
                            if ((0x3000000000000L & l) == 0L) continue block123;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddStates(57, 59);
                            break;
                        }
                        case 66: {
                            if ((0xFF000000000000L & l) == 0L) continue block123;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddTwoStates(66, 8);
                            break;
                        }
                        case 67: {
                            if ((0x2400L & l) == 0L) continue block123;
                            if (kind > 2) {
                                kind = 2;
                            }
                            this.jjCheckNAddStates(13, 16);
                            break;
                        }
                        case 68: {
                            if ((0x2400L & l) == 0L) continue block123;
                            if (kind > 2) {
                                kind = 2;
                            }
                            this.jjCheckNAddTwoStates(68, 70);
                            break;
                        }
                        case 69: {
                            if (this.curChar != '\n') continue block123;
                            if (kind > 2) {
                                kind = 2;
                            }
                            this.jjCheckNAddTwoStates(68, 70);
                            break;
                        }
                        case 70: {
                            if (this.curChar != '\r') break;
                            this.jjCheckNAdd(69);
                            break;
                        }
                        case 71: {
                            if (this.curChar != '\r') break;
                            this.jjCheckNAddTwoStates(69, 2);
                            break;
                        }
                        case 72: {
                            if (this.curChar != '/') break;
                            this.jjAddStates(20, 22);
                            break;
                        }
                        case 74: {
                            if ((0xFFFFFFFFFFFFDBFFL & l) == 0L) break;
                            this.jjCheckNAddStates(0, 2);
                            break;
                        }
                        case 75: {
                            if ((0x2400L & l) == 0L || kind <= 6) continue block123;
                            kind = 6;
                            break;
                        }
                        case 76: {
                            if (this.curChar != '\n' || kind <= 6) continue block123;
                            kind = 6;
                            break;
                        }
                        case 77: {
                            if (this.curChar != '\r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 76;
                            break;
                        }
                        case 78: {
                            if (this.curChar != '*') break;
                            this.jjCheckNAddTwoStates(79, 80);
                            break;
                        }
                        case 79: {
                            if ((0xFFFFFBFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(79, 80);
                            break;
                        }
                        case 80: {
                            if (this.curChar != '*') break;
                            this.jjCheckNAddStates(60, 62);
                            break;
                        }
                        case 81: {
                            if ((0xFFFF7BFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(82, 80);
                            break;
                        }
                        case 82: {
                            if ((0xFFFFFBFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(82, 80);
                            break;
                        }
                        case 83: {
                            if (this.curChar != '/' || kind <= 7) continue block123;
                            kind = 7;
                            break;
                        }
                        case 84: {
                            if (this.curChar != '*') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 78;
                            break;
                        }
                        case 85: {
                            if (this.curChar != '*') break;
                            this.jjCheckNAddTwoStates(86, 87);
                            break;
                        }
                        case 86: {
                            if ((0xFFFFFBFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(86, 87);
                            break;
                        }
                        case 87: {
                            if (this.curChar != '*') break;
                            this.jjCheckNAddStates(63, 65);
                            break;
                        }
                        case 88: {
                            if ((0xFFFF7BFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(89, 87);
                            break;
                        }
                        case 89: {
                            if ((0xFFFFFBFFFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(89, 87);
                            break;
                        }
                        case 90: {
                            if (this.curChar != '/' || kind <= 8) continue block123;
                            kind = 8;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                long l = 1L << (this.curChar & 0x3F);
                block124: do {
                    switch (this.jjstateSet[--i]) {
                        case 6: 
                        case 40: {
                            if ((0x7FFFFFE87FFFFFEL & l) == 0L) continue block124;
                            if (kind > 71) {
                                kind = 71;
                            }
                            this.jjCheckNAdd(40);
                            break;
                        }
                        case 8: {
                            if ((0x100000001000L & l) == 0L || kind <= 62) continue block124;
                            kind = 62;
                            break;
                        }
                        case 11: {
                            if (this.curChar != '_') break;
                            this.jjAddStates(66, 67);
                            break;
                        }
                        case 12: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(68, 69);
                            break;
                        }
                        case 15: {
                            if ((0x5000000050L & l) == 0L || kind <= 67) continue block124;
                            kind = 67;
                            break;
                        }
                        case 17: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 19: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(70, 73);
                            break;
                        }
                        case 20: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 21;
                            break;
                        }
                        case 21: {
                            if ((0x7E00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 22;
                            break;
                        }
                        case 22: {
                            if ((0x7E00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 23;
                            break;
                        }
                        case 23: {
                            if ((0x7E00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 24;
                            break;
                        }
                        case 24: {
                            if ((0x7E00000000L & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 25: {
                            if ((0x14404410000000L & l) == 0L) break;
                            this.jjCheckNAdd(18);
                            break;
                        }
                        case 31: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 32: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(74, 76);
                            break;
                        }
                        case 33: {
                            if ((0x14404410000000L & l) == 0L) break;
                            this.jjCheckNAddStates(23, 25);
                            break;
                        }
                        case 42: {
                            if (this.curChar != '_') break;
                            this.jjAddStates(77, 78);
                            break;
                        }
                        case 46: {
                            if (this.curChar != '_') break;
                            this.jjAddStates(79, 80);
                            break;
                        }
                        case 47: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(81, 82);
                            break;
                        }
                        case 50: {
                            if (this.curChar != '_') break;
                            this.jjAddStates(83, 84);
                            break;
                        }
                        case 52: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(85, 86);
                            break;
                        }
                        case 55: {
                            if (this.curChar != '_') break;
                            this.jjAddStates(87, 88);
                            break;
                        }
                        case 57: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(89, 90);
                            break;
                        }
                        case 61: {
                            if ((0x100000001000000L & l) == 0L) break;
                            this.jjCheckNAdd(62);
                            break;
                        }
                        case 62: {
                            if ((0x7E0000007EL & l) == 0L) continue block124;
                            if (kind > 62) {
                                kind = 62;
                            }
                            this.jjCheckNAddTwoStates(62, 8);
                            break;
                        }
                        case 63: {
                            if ((0x400000004L & l) == 0L) break;
                            this.jjCheckNAdd(64);
                            break;
                        }
                        case 65: {
                            if (this.curChar != '_') break;
                            this.jjCheckNAddTwoStates(65, 64);
                            break;
                        }
                        case 74: {
                            this.jjAddStates(0, 2);
                            break;
                        }
                        case 79: {
                            this.jjCheckNAddTwoStates(79, 80);
                            break;
                        }
                        case 81: 
                        case 82: {
                            this.jjCheckNAddTwoStates(82, 80);
                            break;
                        }
                        case 86: {
                            this.jjCheckNAddTwoStates(86, 87);
                            break;
                        }
                        case 88: 
                        case 89: {
                            this.jjCheckNAddTwoStates(89, 87);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block125: do {
                    switch (this.jjstateSet[--i]) {
                        case 6: 
                        case 40: {
                            if (!JavaParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block125;
                            if (kind > 71) {
                                kind = 71;
                            }
                            this.jjCheckNAdd(40);
                            break;
                        }
                        case 17: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 18;
                            break;
                        }
                        case 31: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(23, 25);
                            break;
                        }
                        case 74: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(0, 2);
                            break;
                        }
                        case 79: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddTwoStates(79, 80);
                            break;
                        }
                        case 81: 
                        case 82: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddTwoStates(82, 80);
                            break;
                        }
                        case 86: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddTwoStates(86, 87);
                            break;
                        }
                        case 88: 
                        case 89: {
                            if (!JavaParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddTwoStates(89, 87);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 91 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec0[i2] & l2) != 0L;
            }
        }
        return false;
    }

    private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec3[i2] & l2) != 0L;
            }
            case 48: {
                return (jjbitVec4[i2] & l2) != 0L;
            }
            case 49: {
                return (jjbitVec5[i2] & l2) != 0L;
            }
            case 51: {
                return (jjbitVec6[i2] & l2) != 0L;
            }
            case 61: {
                return (jjbitVec7[i2] & l2) != 0L;
            }
        }
        return (jjbitVec1[i1] & l1) != 0L;
    }

    public JavaParserTokenManager(SimpleCharStream stream) {
        this.input_stream = stream;
    }

    public JavaParserTokenManager(SimpleCharStream stream, int lexState) {
        this(stream);
        this.SwitchTo(lexState);
    }

    public void ReInit(SimpleCharStream stream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.input_stream = stream;
        this.ReInitRounds();
    }

    private void ReInitRounds() {
        this.jjround = -2147483647;
        int i = 91;
        while (i-- > 0) {
            this.jjrounds[i] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(SimpleCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void SwitchTo(int lexState) {
        if (lexState >= 1 || lexState < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
        }
        this.curLexState = lexState;
    }

    protected Token jjFillToken() {
        String im = jjstrLiteralImages[this.jjmatchedKind];
        String curTokenImage = im == null ? this.input_stream.GetImage() : im;
        int beginLine = this.input_stream.getBeginLine();
        int beginColumn = this.input_stream.getBeginColumn();
        int endLine = this.input_stream.getEndLine();
        int endColumn = this.input_stream.getEndColumn();
        Token t = Token.newToken(this.jjmatchedKind);
        t.kind = this.jjmatchedKind;
        t.image = curTokenImage;
        t.beginLine = beginLine;
        t.endLine = endLine;
        t.beginColumn = beginColumn;
        t.endColumn = endColumn;
        return t;
    }

    public Token getNextToken() {
        Token specialToken = null;
        int curPos = 0;
        while (true) {
            Token matchedToken;
            try {
                this.curChar = this.input_stream.BeginToken();
            }
            catch (IOException e) {
                this.jjmatchedKind = 0;
                matchedToken = this.jjFillToken();
                matchedToken.specialToken = specialToken;
                return matchedToken;
            }
            this.image = this.jjimage;
            this.image.setLength(0);
            this.jjimageLen = 0;
            try {
                this.input_stream.backup(0);
                while (this.curChar <= '\f' && (0x1000L & 1L << this.curChar) != 0L) {
                    this.curChar = this.input_stream.BeginToken();
                }
            }
            catch (IOException e1) {
                continue;
            }
            this.jjmatchedKind = Integer.MAX_VALUE;
            this.jjmatchedPos = 0;
            curPos = this.jjMoveStringLiteralDfa0_0();
            if (this.jjmatchedKind == Integer.MAX_VALUE) break;
            if (this.jjmatchedPos + 1 < curPos) {
                this.input_stream.backup(curPos - this.jjmatchedPos - 1);
            }
            if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                matchedToken = this.jjFillToken();
                matchedToken.specialToken = specialToken;
                this.TokenLexicalActions(matchedToken);
                return matchedToken;
            }
            if ((jjtoSpecial[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                matchedToken = this.jjFillToken();
                if (specialToken == null) {
                    specialToken = matchedToken;
                } else {
                    matchedToken.specialToken = specialToken;
                    specialToken = specialToken.next = matchedToken;
                }
                this.SkipLexicalActions(matchedToken);
                continue;
            }
            this.SkipLexicalActions(null);
        }
        int error_line = this.input_stream.getEndLine();
        int error_column = this.input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
            this.input_stream.readChar();
            this.input_stream.backup(1);
        }
        catch (IOException e1) {
            EOFSeen = true;
            String string = error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            if (this.curChar == '\n' || this.curChar == '\r') {
                ++error_line;
                error_column = 0;
            }
            ++error_column;
        }
        if (!EOFSeen) {
            this.input_stream.backup(1);
            error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
        }
        throw new TokenMgrError(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
    }

    void SkipLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 2: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                String s = matchedToken.image;
                int n = 0;
                int r = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) == 'n') {
                        ++n;
                        continue;
                    }
                    ++r;
                }
                int cnt = Math.max(n, r);
                if ((cnt = Math.min(2, cnt)) <= 0) break;
                while (cnt >= 0) {
                    JavaParserTokenManager.add(ls);
                    --cnt;
                }
                JavaParserTokenManager.write();
                break;
            }
            case 3: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                String b = matchedToken.image;
                b = b.replaceAll(" ", "");
                b = b.replaceAll("\t", "");
                int bn = 0;
                int br = 0;
                for (int i = 0; i < b.length(); ++i) {
                    if (b.charAt(i) == 'n') {
                        ++bn;
                        continue;
                    }
                    ++br;
                }
                int bcnt = Math.max(bn, br);
                if ((bcnt = Math.min(2, bcnt)) <= 0) break;
                while (bcnt >= 0) {
                    JavaParserTokenManager.add(ls);
                    --bcnt;
                }
                JavaParserTokenManager.write();
                break;
            }
            case 4: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                JavaParserTokenManager.add(matchedToken);
                break;
            }
            case 5: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                for (int i = 0; i < matchedToken.image.length() * 8; ++i) {
                    JavaParserTokenManager.add(" ");
                }
                break;
            }
            case 6: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                JavaParserTokenManager.writeEndOfLineComment(matchedToken.image);
                break;
            }
            case 7: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                JavaParserTokenManager.writeJavadocComment(matchedToken.image);
                break;
            }
            case 8: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                JavaParserTokenManager.writeBlockComment(matchedToken.image);
                break;
            }
        }
    }

    void TokenLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 119: {
                this.image.append(jjstrLiteralImages[119]);
                this.lengthOfMatch = jjstrLiteralImages[119].length();
                matchedToken.kind = 121;
                ((Token.GTToken)matchedToken).realKind = 119;
                this.input_stream.backup(2);
                break;
            }
            case 120: {
                this.image.append(jjstrLiteralImages[120]);
                this.lengthOfMatch = jjstrLiteralImages[120].length();
                matchedToken.kind = 121;
                ((Token.GTToken)matchedToken).realKind = 120;
                this.input_stream.backup(1);
                break;
            }
        }
    }

    private void jjCheckNAdd(int state) {
        if (this.jjrounds[state] != this.jjround) {
            this.jjstateSet[this.jjnewStateCnt++] = state;
            this.jjrounds[state] = this.jjround;
        }
    }

    private void jjAddStates(int start, int end) {
        do {
            this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private void jjCheckNAddTwoStates(int state1, int state2) {
        this.jjCheckNAdd(state1);
        this.jjCheckNAdd(state2);
    }

    private void jjCheckNAddStates(int start, int end) {
        do {
            this.jjCheckNAdd(jjnextStates[start]);
        } while (start++ != end);
    }
}

