/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.html;

class MarginWriter {
    protected int tabStop;
    protected int curPosition;
    protected int leftMargin;
    protected int rightMargin;
    StringBuilder sb = null;
    protected char[] spaces = new char[256];
    protected String lineSeparator = System.getProperty("line.separator");

    public MarginWriter() {
        this.sb = new StringBuilder();
        for (int i = 0; i < this.spaces.length; ++i) {
            this.spaces[i] = 32;
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    public void print(String s) {
        if (s == null) {
            s = "";
        }
        if (this.curPosition == 0 && this.leftMargin > 0) {
            this.sb.append(this.spaces, 0, this.leftMargin);
            this.curPosition = this.leftMargin;
        }
        this.sb.append(s);
        this.curPosition += s.length();
    }

    public void printAutoWrap(String s) {
        if (s == null) {
            s = "";
        }
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
        }
        this.print(s);
    }

    public void printAutoWrap(String s, int hanging) {
        if (s == null) {
            s = "";
        }
        if (this.curPosition > this.leftMargin && this.curPosition + s.length() > this.rightMargin) {
            this.println();
            this.sb.append(this.spaces, 0, hanging + this.leftMargin);
            this.curPosition = this.leftMargin + hanging;
        }
        this.print(s);
    }

    public void println() {
        this.curPosition = 0;
        this.sb.append(this.lineSeparator);
    }

    public void printAttr(String s) {
        if (s == null) {
            s = "";
        }
        this.sb.append(this.spaces, 0, this.leftMargin);
        this.print(s);
    }

    public void printlnSoft() {
        if (this.curPosition > 0) {
            this.println();
        }
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getCurPosition() {
        return this.curPosition == 0 ? this.leftMargin : this.curPosition;
    }

    public void setCurPosition(int p) {
        this.curPosition = p >= 0 ? p : 0;
    }

    public void setLineSeparator(String ls) {
        this.lineSeparator = ls;
    }
}

