/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.html;

import beauty.parsers.html.HtmlCollector;
import beauty.parsers.html.HtmlDocument;
import beauty.parsers.html.HtmlFormatter;
import beauty.parsers.html.HtmlParserConstants;
import beauty.parsers.html.HtmlParserTokenManager;
import beauty.parsers.html.HtmlScrubber;
import beauty.parsers.html.ParseException;
import beauty.parsers.html.SimpleCharStream;
import beauty.parsers.html.Token;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class HtmlParser
implements HtmlParserConstants {
    static final String NL = System.getProperty("line.separator");
    public HtmlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[18];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private static String getTokenText(Token first, Token cur) {
        StringBuffer sb = new StringBuffer();
        Token t = first;
        while (t != cur.next) {
            if (t.specialToken != null) {
                Token tt = t.specialToken;
                while (tt.specialToken != null) {
                    tt = tt.specialToken;
                }
                while (tt != null) {
                    sb.append(tt.image);
                    tt = tt.next;
                }
            }
            sb.append(t.image);
            t = t.next;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ParseException {
        if (args.length == 0) {
            return;
        }
        try {
            String filename = args[0];
            HtmlParser parser = new HtmlParser(new FileReader(filename));
            HtmlDocument document = parser.HtmlDocument();
            document.setLineSeparator("\n");
            document.accept(new HtmlCollector());
            document.accept(new HtmlScrubber(58));
            HtmlFormatter formatter = new HtmlFormatter();
            formatter.setRightMargin(1024);
            formatter.setLineSeparator("\n");
            formatter.setIndent(3);
            document.accept(formatter);
            System.out.println(formatter.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public final HtmlDocument HtmlDocument() throws ParseException {
        HtmlDocument.ElementSequence s = this.ElementSequence();
        this.jj_consume_token(0);
        return new HtmlDocument(s);
    }

    public final HtmlDocument.ElementSequence ElementSequence() throws ParseException {
        HtmlDocument.ElementSequence s = new HtmlDocument.ElementSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            HtmlDocument.HtmlElement h = this.Element();
            s.addElement(h);
        }
        return s;
    }

    public final HtmlDocument.HtmlElement Element() throws ParseException {
        if (this.jj_2_1(2)) {
            HtmlDocument.HtmlElement e = this.Tag();
            return e;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                HtmlDocument.HtmlElement e = this.EndTag();
                return e;
            }
            case 19: {
                HtmlDocument.Comment e = this.CommentTag();
                return e;
            }
            case 20: {
                HtmlDocument.Comment e = this.DeclTag();
                return e;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        if (this.jj_2_2(3)) {
            HtmlDocument.HtmlElement e = this.ScriptletBlock();
            return e;
        }
        if (this.jj_2_3(2)) {
            HtmlDocument.HtmlElement e = this.ScriptBlock();
            return e;
        }
        if (this.jj_2_4(2)) {
            HtmlDocument.HtmlElement e = this.StyleBlock();
            return e;
        }
        if (this.jj_2_5(2)) {
            this.jj_consume_token(16);
            Token text = this.jj_consume_token(26);
            return new HtmlDocument.Text("<" + text.image);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                Token text = this.jj_consume_token(21);
                return new HtmlDocument.Text(text.image);
            }
            case 22: {
                this.jj_consume_token(22);
                return new HtmlDocument.BlankLines();
            }
            case 15: {
                this.jj_consume_token(15);
                return new HtmlDocument.Newline();
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final HtmlDocument.Attribute Attribute() throws ParseException {
        String value = null;
        Token t = this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                value = this.AttributeValue();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if (value == null) {
            return new HtmlDocument.Attribute(t.image);
        }
        return new HtmlDocument.Attribute(t.image, value);
    }

    public final String AttributeValue() throws ParseException {
        StringBuffer content = new StringBuffer();
        Token t = null;
        Object inner_tag = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    this.jj_consume_token(36);
                    block27: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 42: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: {
                                break;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                break block27;
                            }
                        }
                        t = this.QuoteIndependentAttributeValueContent();
                        if (t != null) {
                            content.append(t.image);
                            continue;
                        }
                        if (inner_tag == null) continue;
                        content.append(inner_tag.toString());
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            this.jj_consume_token(41);
                            break;
                        }
                        case 43: {
                            t = this.jj_consume_token(43);
                            content.append(t.image.substring(0, 1));
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 48: {
                            t = this.jj_consume_token(48);
                            content.append(t.image);
                            break block1;
                        }
                    }
                    this.jj_la1[6] = this.jj_gen;
                    break;
                }
                case 35: {
                    this.jj_consume_token(35);
                    block28: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 39: 
                            case 42: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: {
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                                break block28;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 39: {
                                t = this.jj_consume_token(39);
                                break;
                            }
                            case 42: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: {
                                t = this.QuoteIndependentAttributeValueContent();
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        content.append(t.image);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: {
                            this.jj_consume_token(38);
                            break block1;
                        }
                        case 40: {
                            t = this.jj_consume_token(40);
                            content.append(t.image.substring(0, 1));
                            break block1;
                        }
                    }
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Missing return statement in function");
        }
    }

    public final Token QuoteIndependentAttributeValueContent() throws ParseException {
        try {
            Token t;
            if (this.jj_2_6(2)) {
                t = this.jj_consume_token(44);
            } else if (this.jj_2_7(2)) {
                t = this.jj_consume_token(45);
            } else if (this.jj_2_8(2)) {
                t = this.jj_consume_token(46);
            } else if (this.jj_2_9(2)) {
                t = this.jj_consume_token(47);
            } else if (this.jj_2_10(2)) {
                t = this.jj_consume_token(42);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Missing return statement in function");
        }
    }

    public final HtmlDocument.AttributeList AttributeList() throws ParseException {
        HtmlDocument.AttributeList alist = new HtmlDocument.AttributeList();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            HtmlDocument.Attribute a = this.Attribute();
            alist.addAttribute(a);
        }
        return alist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HtmlDocument.HtmlElement Tag() throws ParseException {
        HtmlDocument.AttributeList alist = null;
        Token firstToken = this.getToken(1);
        HtmlDocument.HtmlElement rtn_tag = null;
        Token st = null;
        try {
            Token et;
            st = this.jj_consume_token(16);
            Token t = this.jj_consume_token(25);
            alist = this.AttributeList();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    et = this.jj_consume_token(29);
                    break;
                }
                case 30: {
                    et = this.jj_consume_token(30);
                    break;
                }
                case 31: {
                    et = this.jj_consume_token(31);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            HtmlDocument.Tag tag = new HtmlDocument.Tag(st.image, t.image, alist, et.image);
            if (st.image.startsWith("<%") || t.image.indexOf(":") > 0) {
                tag.setIsJspTag(true);
            }
            if (et.kind == 31) {
                tag.setEmpty(true);
            }
            rtn_tag = tag;
            return rtn_tag;
        }
        catch (ParseException ex) {
            HtmlDocument.Text tag;
            System.out.println(ex.getMessage());
            this.token_source.SwitchTo(11);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            rtn_tag = tag = new HtmlDocument.Text(s);
            return rtn_tag;
        }
        finally {
            return rtn_tag;
        }
    }

    public final HtmlDocument.ElementSequence BlockContents() throws ParseException {
        HtmlDocument.ElementSequence e;
        StringBuffer s;
        block11: {
            s = new StringBuffer();
            e = new HtmlDocument.ElementSequence();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: 
                    case 59: 
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        if (s.length() > 0) {
                            e.addElement(new HtmlDocument.Text(s.toString()));
                            s.setLength(0);
                        }
                        e.addElement(new HtmlDocument.Newline());
                        continue block8;
                    }
                    case 60: {
                        Token t = this.jj_consume_token(60);
                        s.append(t.image);
                        continue block8;
                    }
                    case 59: {
                        Token t = this.jj_consume_token(59);
                        s.append(t.image);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (s.length() > 0) {
            e.addElement(new HtmlDocument.Text(s.toString()));
        }
        return e;
    }

    public final HtmlDocument.HtmlElement ScriptBlock() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            this.jj_consume_token(16);
            this.jj_consume_token(23);
            HtmlDocument.AttributeList alist = this.AttributeList();
            this.jj_consume_token(29);
            this.token_source.SwitchTo(1);
            HtmlDocument.ElementSequence e = this.BlockContents();
            this.jj_consume_token(56);
            return new HtmlDocument.TagBlock("SCRIPT", alist, e);
        }
        catch (ParseException ex) {
            this.token_source.SwitchTo(11);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.HtmlElement StyleBlock() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            this.jj_consume_token(16);
            this.jj_consume_token(24);
            HtmlDocument.AttributeList alist = this.AttributeList();
            this.jj_consume_token(29);
            this.token_source.SwitchTo(0);
            HtmlDocument.ElementSequence e = this.BlockContents();
            this.jj_consume_token(57);
            return new HtmlDocument.TagBlock("STYLE", alist, e);
        }
        catch (ParseException ex) {
            this.token_source.SwitchTo(11);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.HtmlElement EndTag() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            this.jj_consume_token(18);
            Token t = this.jj_consume_token(25);
            this.jj_consume_token(29);
            HtmlDocument.EndTag tag = new HtmlDocument.EndTag(t.image);
            if (t.image.indexOf(":") > 0) {
                tag.setIsJspTag(true);
            }
            return tag;
        }
        catch (ParseException ex) {
            this.token_source.SwitchTo(11);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.Comment CommentTag() throws ParseException {
        Token comment_start;
        StringBuffer s;
        Token comment_end;
        block13: {
            comment_end = null;
            s = new StringBuffer();
            comment_start = this.jj_consume_token(19);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: 
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: {
                        Token t = this.jj_consume_token(50);
                        s.append(t.image);
                        continue block12;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        s.append(NL);
                        continue block12;
                    }
                    case 52: {
                        Token t = this.jj_consume_token(52);
                        s.append(t.image);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            case 49: {
                comment_end = this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new HtmlDocument.Comment(comment_start.image + s.toString() + (comment_end == null ? "" : comment_end.image));
    }

    public final HtmlDocument.Comment DeclTag() throws ParseException {
        this.jj_consume_token(20);
        Token t = this.jj_consume_token(54);
        this.jj_consume_token(55);
        return new HtmlDocument.Comment(t.image);
    }

    public final HtmlDocument.HtmlElement ScriptletBlock() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            this.jj_consume_token(17);
            String block = this.getScriptletBlock();
            HtmlDocument.ElementSequence e = new HtmlDocument.ElementSequence();
            e.addElement(new HtmlDocument.Text(block));
            this.token_source.SwitchTo(11);
            return new HtmlDocument.JspScriptletBlock(e);
        }
        catch (ParseException ex) {
            this.token_source.SwitchTo(11);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    String getScriptletBlock() throws ParseException {
        StringBuilder sb = new StringBuilder();
        try {
            do {
                sb.append(this.jj_input_stream.readChar());
            } while (sb.length() <= 2 || !sb.substring(sb.length() - 2).equals("%>"));
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }
        catch (Exception exception) {
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private boolean jj_3_4() {
        return this.jj_3R_10();
    }

    private boolean jj_3_3() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_2() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(44);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{8355840, 0x1C0000, 0x608000, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, -536870912, 0, 0, 0, 0, 1};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 1, 62464, 2560, 65536, 62592, 62592, 320, 24, 0, 0, 0x1C000000, 0x1C000000, 0x1C0000, 0x1C0000, 131072};
    }

    public HtmlParser(InputStream stream) {
        this(stream, null);
    }

    public HtmlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new HtmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HtmlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HtmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HtmlParser(HtmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(HtmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[61];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 18; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 61; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        HtmlParser.jj_la1_init_0();
        HtmlParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

