/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.html;

import beauty.parsers.html.HtmlDocument;
import beauty.parsers.html.HtmlVisitor;
import beauty.parsers.html.MarginWriter;
import beauty.parsers.html.TagBlockRenderer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HtmlFormatter
extends HtmlVisitor {
    protected MarginWriter out;
    protected int rightMargin = 80;
    protected int indentSize = 2;
    protected String lineSeparator = System.getProperty("line.separator");
    protected static Set tagsIndentBlock;
    protected static Set tagsNewlineBefore;
    protected static Set tagsPreformatted;
    protected static Set tagsLanguages;
    protected static Set tagsTryMatch;
    protected static final String[] tagsIndentStrings;
    protected static final String[] tagsNewlineBeforeStrings;
    protected static final String[] tagsPreformattedStrings;
    protected static final String[] tagsLanguagesStrings;
    protected static final String[] tagsTryMatchStrings;
    protected TagBlockRenderer blockRenderer = new TagBlockRenderer();
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;
    protected boolean inLanguage;

    public HtmlFormatter() throws Exception {
        this.out = new MarginWriter();
        this.out.setRightMargin(this.rightMargin);
        this.out.setLineSeparator(this.lineSeparator);
    }

    public String toString() {
        return this.out.toString();
    }

    public void setRightMargin(int margin) {
        this.rightMargin = margin;
        this.out.setRightMargin(this.rightMargin);
    }

    public void setIndent(int indent) {
        this.indentSize = indent;
    }

    public void setLineSeparator(String ls) {
        this.lineSeparator = ls;
        this.out.setLineSeparator(this.lineSeparator);
    }

    String trimStart(String s, int max) {
        StringBuilder sb = new StringBuilder(s);
        for (int trimmed = 0; sb.length() > 0 && Character.isWhitespace(sb.charAt(0)) && trimmed < max; ++trimmed) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public void visit(HtmlDocument.TagBlock block) {
        boolean indent;
        String tagName;
        int wasMargin = 0;
        boolean preformat = block.startTag.tagName == null || tagsPreformatted.contains(block.startTag.tagName.toUpperCase());
        boolean haveLanguage = tagsLanguages.contains(block.startTag.tagName.toUpperCase());
        if (haveLanguage && ("SCRIPT".equals((tagName = block.startTag.tagName).toUpperCase()) || "STYLE".equals(tagName.toUpperCase()) || "%".equals(tagName))) {
            try {
                HtmlDocument.ElementSequence elements = block.body;
                StringBuilder sb = new StringBuilder();
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    String s = it.next().toString();
                    s = this.trimStart(s, Integer.MAX_VALUE);
                    sb.append(s);
                    if (s.endsWith(this.lineSeparator)) continue;
                    sb.append(this.lineSeparator);
                }
                String formatted = sb.toString();
                String[] lines = formatted.split(this.lineSeparator);
                elements = new HtmlDocument.ElementSequence(lines.length * 2);
                elements.addElement(new HtmlDocument.Newline());
                for (String line : lines) {
                    elements.addElement(new HtmlDocument.Text(line));
                    elements.addElement(new HtmlDocument.Newline());
                }
                block.body = elements;
            }
            catch (Exception pe) {
                // empty catch block
            }
        }
        if (block.startTag.tagName != null && tagsTryMatch.contains(block.startTag.tagName.toUpperCase())) {
            this.blockRenderer.start();
            this.blockRenderer.setTargetWidth(this.out.getRightMargin() - this.out.getLeftMargin());
            this.blockRenderer.visit(block);
            this.blockRenderer.finish();
            if (!this.blockRenderer.hasBlownTarget()) {
                if (preformat) {
                    this.out.print(this.blockRenderer.getString());
                } else {
                    this.out.printAutoWrap(this.blockRenderer.getString());
                }
                this.previousElement = block.endTag;
                return;
            }
        }
        boolean bl = indent = block.startTag.tagName != null && tagsIndentBlock.contains(block.startTag.tagName.toUpperCase()) || block.startTag.isJspTag && block.startTag.tagEnd.equals(">");
        if (preformat) {
            wasMargin = this.out.getLeftMargin();
            this.out.setLeftMargin(0);
            this.visit(block.startTag);
            this.inPreBlock = true;
            this.visit(block.body);
            this.inPreBlock = false;
            this.out.setLeftMargin(wasMargin);
            this.visit(block.endTag);
        } else if (haveLanguage) {
            this.visit(block.startTag);
            this.inLanguage = true;
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.visit(block.body);
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
            this.inLanguage = false;
            this.visit(block.endTag);
        } else if (indent) {
            this.out.printlnSoft();
            this.visit(block.startTag);
            this.out.printlnSoft();
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.visit(block.body);
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
            this.out.printlnSoft();
            this.visit(block.endTag);
            this.out.printlnSoft();
            this.inPreBlock = false;
        } else {
            this.visit(block.startTag);
            this.visit(block.body);
            this.visit(block.endTag);
        }
    }

    public void visit(HtmlDocument.Tag t) {
        String s = t.toString();
        if (t.tagName != null && tagsNewlineBefore.contains(t.tagName.toUpperCase()) || this.out.getCurPosition() + s.length() > this.out.getRightMargin()) {
            this.out.printlnSoft();
        }
        this.out.print(t.tagStart + (t.tagName == null ? "" : t.tagName));
        int hanging = t.tagName == null ? 0 : t.tagName.length() + 1;
        boolean splitAttrs = false;
        if (splitAttrs) {
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.out.print(this.lineSeparator);
        }
        Iterator it = t.attributeList.attributes.iterator();
        while (it.hasNext()) {
            HtmlDocument.Attribute a = (HtmlDocument.Attribute)it.next();
            if (splitAttrs) {
                this.out.printAttr(a.toString());
                if (!it.hasNext()) continue;
                this.out.print(this.lineSeparator);
                continue;
            }
            this.out.printAutoWrap(" " + a.toString(), hanging);
        }
        if (splitAttrs) {
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
        }
        if (t.isJspTag) {
            this.out.print(" ");
        }
        this.out.print(t.tagEnd);
        if (t.tagEnd.endsWith("%>")) {
            this.out.println();
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.EndTag t) {
        this.out.printAutoWrap(t.toString());
        if (t.tagName == null || tagsNewlineBefore.contains(t.tagName.toUpperCase())) {
            this.out.printlnSoft();
        } else {
            this.out.print(" ");
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Comment c) {
        this.out.print(c.toString());
        this.previousElement = c;
    }

    public void visit(HtmlDocument.Text t) {
        if (this.inPreBlock || this.inLanguage) {
            this.out.print(t.text);
        } else {
            t.text = t.text.replaceAll("[ ]+", " ");
            int start = 0;
            while (start < t.text.length()) {
                int index = t.text.indexOf(32, start) + 1;
                if (index == 0) {
                    index = t.text.length();
                }
                this.out.printAutoWrap(t.text.substring(start, index));
                start = index;
            }
        }
        this.previousElement = t;
    }

    public void visit(HtmlDocument.Newline n) {
        if (this.inPreBlock) {
            this.out.print(this.lineSeparator);
        } else if (this.inLanguage) {
            this.out.println();
        } else if (this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment || this.previousElement instanceof HtmlDocument.Newline) {
            this.out.printlnSoft();
        } else if (this.previousElement instanceof HtmlDocument.Text) {
            this.out.print(" ");
        }
        this.previousElement = n;
    }

    public void visit(HtmlDocument.BlankLines b) {
        if (!(this.previousElement instanceof HtmlDocument.BlankLines)) {
            this.out.println();
        }
        this.previousElement = b;
    }

    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
        this.inLanguage = false;
    }

    public void finish() {
    }

    static {
        int i;
        tagsIndentBlock = new HashSet();
        tagsNewlineBefore = new HashSet();
        tagsPreformatted = new HashSet();
        tagsLanguages = new HashSet();
        tagsTryMatch = new HashSet();
        tagsIndentStrings = new String[]{"TABLE", "TR", "TD", "TH", "FORM", "HTML", "HEAD", "BODY", "SELECT", "OL", "UL", "LI", "DIV", "SPAN", "P", "H1", "H2", "H3", "H4", "H5", "H6"};
        tagsNewlineBeforeStrings = new String[]{"P", "H1", "H2", "H3", "H4", "H5", "H6", "BR", "HR", "taglib", "OL", "UL", "LI", "LINK"};
        tagsPreformattedStrings = new String[]{"PRE"};
        tagsLanguagesStrings = new String[]{"SCRIPT", "STYLE", "%"};
        tagsTryMatchStrings = new String[]{"A", "I", "B", "EM", "FONT", "TT"};
        for (i = 0; i < tagsIndentStrings.length; ++i) {
            tagsIndentBlock.add(tagsIndentStrings[i]);
        }
        for (i = 0; i < tagsNewlineBeforeStrings.length; ++i) {
            tagsNewlineBefore.add(tagsNewlineBeforeStrings[i]);
        }
        for (i = 0; i < tagsPreformattedStrings.length; ++i) {
            tagsPreformatted.add(tagsPreformattedStrings[i]);
        }
        for (i = 0; i < tagsLanguagesStrings.length; ++i) {
            tagsLanguages.add(tagsLanguagesStrings[i]);
        }
        for (i = 0; i < tagsTryMatchStrings.length; ++i) {
            tagsTryMatch.add(tagsTryMatchStrings[i]);
        }
    }
}

