/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.html;

import beauty.parsers.html.HtmlVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HtmlDocument {
    ElementSequence elements;
    static String NL = System.getProperty("line.separator");

    public HtmlDocument(ElementSequence s) {
        this.elements = s;
    }

    public void setLineSeparator(String ls) {
        NL = ls;
    }

    public void accept(HtmlVisitor v) {
        v.visit(this);
    }

    private static String dequote(String s) {
        if (s == null) {
            return "";
        }
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static class AttributeList {
        public List attributes = new ArrayList();

        public void addAttribute(Attribute a) {
            this.attributes.add(a);
        }

        public boolean contains(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public boolean hasValue(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name) || !attribute.hasValue) continue;
                return true;
            }
            return false;
        }

        public String getValue(String name) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(name) || !attribute.hasValue) continue;
                return HtmlDocument.dequote(attribute.value);
            }
            return null;
        }
    }

    public static class Attribute {
        public String name;
        public String value;
        public boolean hasValue;

        public Attribute(String n) {
            this.name = n;
            this.hasValue = false;
        }

        public Attribute(String n, String v) {
            this.name = n;
            this.value = v;
            this.hasValue = v != null && !v.isEmpty();
        }

        public int getLength() {
            return this.hasValue ? this.name.length() + 1 + this.value.length() : this.name.length();
        }

        public String toString() {
            return this.hasValue ? this.name + "=" + this.quote(this.value) : this.name;
        }

        public String quote(String s) {
            if (s == null) {
                return "";
            }
            if (!s.startsWith("\"")) {
                s = "\"" + s;
            }
            if (!s.endsWith("\"")) {
                s = s + "\"";
            }
            return s;
        }
    }

    public static class Annotation
    extends HtmlElement {
        String type;
        String text;

        public Annotation(String type, String text) {
            this.type = type;
            this.text = text;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 14 + this.type.length() + this.text.length();
        }

        public String toString() {
            return "<!--NOTE(" + this.type + ") " + this.text + "-->";
        }
    }

    public static class ElementSequence {
        private List elements;

        public ElementSequence(int n) {
            this.elements = new ArrayList(n);
        }

        public ElementSequence() {
            this.elements = new ArrayList();
        }

        public void addElement(HtmlElement o) {
            this.elements.add(o);
        }

        public int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            return this.elements.iterator();
        }

        public void setElements(List coll) {
            this.elements.clear();
            this.elements.addAll(coll);
        }
    }

    public static class BlankLines
    extends HtmlElement {
        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return (NL + NL).length();
        }

        public String toString() {
            return NL + NL;
        }
    }

    public static class Newline
    extends HtmlElement {
        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return NL.length();
        }

        public String toString() {
            return NL;
        }
    }

    public static class Text
    extends HtmlElement {
        public String text;

        public Text(String t) {
            this.text = t;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return this.text.length();
        }

        public String toString() {
            return this.text;
        }
    }

    public static class JspComment
    extends HtmlElement {
        public String comment;

        public JspComment(String c) {
            this.comment = c;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 4 + this.comment.length();
        }

        public String toString() {
            return "<" + this.comment + ">";
        }
    }

    public static class Comment
    extends HtmlElement {
        public String comment;

        public Comment(String c) {
            this.comment = c;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.comment.length();
        }

        public String toString() {
            return this.comment;
        }
    }

    public static class JspScriptletEndTag
    extends EndTag {
        public JspScriptletEndTag() {
            super("%");
        }

        public int getLength() {
            return 2;
        }

        public String toString() {
            return "%>";
        }
    }

    public static class JspScriptletStartTag
    extends Tag {
        public JspScriptletStartTag() {
            super("%", null);
            this.tagStart = "<";
            this.tagEnd = "";
        }

        public int getLength() {
            return 2;
        }

        public String toString() {
            return "<%";
        }
    }

    public static class JspScriptletBlock
    extends TagBlock {
        public JspScriptletBlock(ElementSequence b) {
            super("", null, b);
            this.startTag = new JspScriptletStartTag();
            this.endTag = new JspScriptletEndTag();
        }

        public String toString() {
            return "";
        }
    }

    public static class TagBlock
    extends HtmlElement {
        public Tag startTag;
        public EndTag endTag;
        public ElementSequence body;

        public TagBlock(String name, AttributeList aList, ElementSequence b) {
            this.startTag = new Tag(name, aList);
            this.endTag = new EndTag(name);
            this.body = b;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public String toString() {
            return this.startTag.toString();
        }
    }

    public static class EndTag
    extends HtmlElement {
        public String tagName;
        public boolean isJspTag = false;

        public EndTag(String t) {
            this.tagName = t;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.tagName.length();
        }

        public void setIsJspTag(boolean b) {
            this.isJspTag = b;
        }

        public String toString() {
            return "</" + this.tagName + ">";
        }
    }

    public static class Tag
    extends HtmlElement {
        public String tagStart = "<";
        public String tagName;
        public AttributeList attributeList;
        public String tagEnd = ">";
        public boolean emptyTag = false;
        public boolean isJspTag = false;

        public Tag(String name, AttributeList a) {
            this.tagName = name;
            if (a == null) {
                a = new AttributeList();
            }
            this.attributeList = a;
        }

        public Tag(String tagStart, String name, AttributeList a, String tagEnd) {
            if (tagStart != null) {
                this.tagStart = tagStart;
            }
            this.tagName = name;
            if (a == null) {
                a = new AttributeList();
            }
            this.attributeList = a;
            this.tagEnd = tagEnd;
        }

        public void setEmpty(boolean b) {
            this.emptyTag = b;
        }

        public void accept(HtmlVisitor v) {
            v.visit(this);
        }

        public boolean hasAttribute(String name) {
            return this.attributeList.contains(name);
        }

        public boolean hasAttributeValue(String name) {
            return this.attributeList.hasValue(name);
        }

        public String getAttributeValue(String name) {
            return this.attributeList.getValue(name);
        }

        public void setIsJspTag(boolean b) {
            this.isJspTag = b;
        }

        public int getLength() {
            int length = 0;
            for (Attribute attribute : this.attributeList.attributes) {
                length += 1 + attribute.getLength();
            }
            return length + this.tagName.length() + 2 + (this.emptyTag ? 1 : 0);
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.tagStart);
            s.append(this.tagName);
            for (Attribute attribute : this.attributeList.attributes) {
                s.append(' ');
                s.append(attribute.toString());
            }
            s.append(this.tagEnd);
            return s.toString();
        }
    }

    public static abstract class HtmlElement {
        public abstract void accept(HtmlVisitor var1);
    }
}

