/*
 * Decompiled with CFR 0.152.
 */
package beauty.parsers.html;

import beauty.parsers.html.HtmlDocument;
import beauty.parsers.html.HtmlParser;
import beauty.parsers.html.HtmlVisitor;
import beauty.parsers.html.ParseException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class HtmlDebugDumper
extends HtmlVisitor {
    protected PrintWriter out;

    public HtmlDebugDumper(OutputStream os) {
        this.out = new PrintWriter(os);
    }

    public void finish() {
        this.out.flush();
    }

    public void visit(HtmlDocument.Tag t) {
        this.out.print("Tag(" + t + ")");
    }

    public void visit(HtmlDocument.EndTag t) {
        this.out.print("Tag(" + t + ")");
    }

    public void visit(HtmlDocument.Comment c) {
        this.out.print("Comment(" + c + ")");
    }

    public void visit(HtmlDocument.Text t) {
        this.out.print(t);
    }

    public void visit(HtmlDocument.Newline n) {
        this.out.println("-NL-");
    }

    public void visit(HtmlDocument.BlankLines b) {
        this.out.println("-BLANK LINE-");
    }

    public void visit(HtmlDocument.Annotation a) {
        this.out.print(a);
    }

    public void visit(HtmlDocument.TagBlock bl) {
        this.out.print("<BLOCK>");
        this.visit(bl.startTag);
        this.visit(bl.body);
        this.visit(bl.endTag);
        this.out.print("</BLOCK>");
    }

    public static void main(String[] args) throws ParseException {
        HtmlParser parser = new HtmlParser(System.in);
        HtmlDocument doc = parser.HtmlDocument();
        doc.accept(new HtmlDebugDumper(System.out));
    }
}

