/*
 * Decompiled with CFR 0.152.
 */
package beauty.options;

import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

class MyTableModel
extends AbstractTableModel {
    private Vector modes;
    public static final String BEAUTIFIER_NONE = "none";

    MyTableModel() {
        Mode[] modes = jEdit.getModes();
        this.modes = new Vector(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            this.modes.addElement(new Entry(modes[i].getName()));
        }
        Collections.sort(this.modes);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.modes.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int row, int col) {
        Entry modeBeautifier = (Entry)this.modes.elementAt(row);
        switch (col) {
            case 0: {
                return modeBeautifier.mode;
            }
            case 1: {
                return modeBeautifier.beautifier;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry modeBeautifier = (Entry)this.modes.elementAt(row);
        switch (col) {
            case 1: {
                modeBeautifier.beautifier = (String)value;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty((String)"options.beauty.beautifiers.mode");
            }
            case 1: {
                return jEdit.getProperty((String)"options.beauty.beautifiers.beautifier");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.modes.size(); ++i) {
            ((Entry)this.modes.elementAt(i)).save();
        }
    }

    class Entry
    implements Comparable {
        String mode;
        String beautifier = null;

        Entry(String mode) {
            this.mode = mode;
            this.beautifier = jEdit.getProperty((String)("mode." + this.mode + ".beauty.beautifier"));
        }

        void save() {
            if (this.beautifier == MyTableModel.BEAUTIFIER_NONE) {
                jEdit.resetProperty((String)("mode." + this.mode + ".beauty.beautifier"));
            } else {
                jEdit.setProperty((String)("mode." + this.mode + ".beauty.beautifier"), (String)this.beautifier);
            }
        }

        public int compareTo(Object a) {
            return this.mode.compareToIgnoreCase(((Entry)a).mode);
        }
    }
}

