/*
 * Decompiled with CFR 0.152.
 */
package beauty.options;

import beauty.BeautyPlugin;
import beauty.beautifiers.Constants;
import ise.java.awt.KappaLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

public class CustomBeautifierOptionPane
extends AbstractOptionPane {
    private JComboBox modeSelector;
    private JCheckBox prePadFunctions;
    private JCheckBox prePadDigits;
    private JCheckBox prePadOperators;
    private JCheckBox postPadFunctions;
    private JCheckBox postPadDigits;
    private JCheckBox postPadOperators;
    private JCheckBox labelOnSeparateLine;
    private JCheckBox prePadKeywords1;
    private JCheckBox postPadKeywords1;
    private JCheckBox prePadKeywords2;
    private JCheckBox postPadKeywords2;
    private JCheckBox prePadKeywords3;
    private JCheckBox postPadKeywords3;
    private JCheckBox prePadKeywords4;
    private JCheckBox postPadKeywords4;
    private JTextField prePadCharacters;
    private JTextField postPadCharacters;
    private JTextField dontPrePadCharacters;
    private JTextField dontPostPadCharacters;
    private JTextField preInsertLineCharacters;
    private JTextField postInsertLineCharacters;
    private JCheckBox collapseBlankLines;
    private JCheckBox collapseLinearWhitespace;
    private JCheckBox usejEditIndenter;
    private JTextField indentOpenBrackets;
    private JTextField indentCloseBrackets;
    private JTextField unalignedOpenBrackets;
    private JTextField unalignedCloseBrackets;
    private JTextField indentNextLine;
    private JTextField unindentThisLine;
    private JTextField electricKeys;
    private JCheckBox lineUpClosingBracket;
    private JCheckBox doubleBracketIndent;
    private Properties modeProperties;
    private Mode currentMode = null;

    public CustomBeautifierOptionPane() {
        super("beauty.custom");
    }

    public void _init() {
        this.currentMode = jEdit.getActiveView().getBuffer().getMode();
        this.loadProperties(this.currentMode.getName());
        this.installComponents();
        this.installListeners();
    }

    private void loadProperties(String modeName) {
        this.modeProperties = BeautyPlugin.getCustomModeProperties(modeName);
    }

    private void installComponents() {
        this.setLayout((LayoutManager)new KappaLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel description = new JLabel(jEdit.getProperty((String)"beauty.msg.<html><b>Create_a_custom_beautifier_for_a_mode", (String)"<html><b>Create a custom beautifier for a mode"));
        JLabel mode_label = new JLabel(jEdit.getProperty((String)"beauty.msg.Mode>_", (String)"Mode: "));
        Mode[] modes = jEdit.getModes();
        Arrays.sort(modes, new Comparator<Mode>(){

            @Override
            public int compare(Mode a, Mode b) {
                return a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
            }
        });
        this.modeSelector = new JComboBox<Mode>(modes);
        this.modeSelector.setSelectedItem(this.currentMode);
        JPanel modePanel = new JPanel((LayoutManager)new KappaLayout());
        modePanel.add((Component)mode_label, "0, 0, 1, 1, W, w, 0");
        modePanel.add((Component)this.modeSelector, "1, 0, 1, 1, 0, w, 3");
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(jEdit.getProperty((String)"beauty.msg.Padding", (String)"Padding"), this.createPaddingPanel());
        tabs.add(jEdit.getProperty((String)"beauty.msg.Indenting", (String)"Indenting"), this.createIndentingPanel());
        this.add(description, "0, 0, 1, 1, W, w, 2");
        this.add(KappaLayout.createVerticalStrut((int)6), "0, 1");
        this.add(modePanel, "0, 2, 1, 1, W, w, 2");
        this.add(KappaLayout.createVerticalStrut((int)3), "0, 3");
        this.add(tabs, "0, 4, 1, 1, 0, wh, 2");
        this.setComponentValues();
    }

    private JPanel createIndentingPanel() {
        JPanel panel = new JPanel((LayoutManager)new KappaLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.usejEditIndenter = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Use_jEdit_indenter_for_this_mode", (String)"Use jEdit indenter for this mode"));
        this.indentOpenBrackets = new JTextField();
        this.indentCloseBrackets = new JTextField();
        this.unalignedOpenBrackets = new JTextField();
        this.unalignedCloseBrackets = new JTextField();
        this.indentNextLine = new JTextField();
        this.unindentThisLine = new JTextField();
        this.electricKeys = new JTextField();
        this.lineUpClosingBracket = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Line_up_closing_bracket", (String)"Line up closing bracket"));
        this.doubleBracketIndent = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Double_bracket_indent", (String)"Double bracket indent"));
        panel.add((Component)this.usejEditIndenter, "0, 0, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Indent_open_brackets>", (String)"Indent open brackets:")), "0, 1, 1, 1, W, w, 2");
        panel.add((Component)this.indentOpenBrackets, "0, 2, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Indent_close_brackets>", (String)"Indent close brackets:")), "0, 3, 1, 1, W, w, 2");
        panel.add((Component)this.indentCloseBrackets, "0, 4, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Unaligned_open_brackets>", (String)"Unaligned open brackets:")), "0, 5, 1, 1, W, w, 2");
        panel.add((Component)this.unalignedOpenBrackets, "0, 6, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Unaligned_close_brackets>", (String)"Unaligned close brackets:")), "0, 7, 1, 1, W, w, 2");
        panel.add((Component)this.unalignedCloseBrackets, "0, 8, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Indent_next_line>", (String)"Indent next line:")), "0, 9, 1, 1, W, w, 2");
        panel.add((Component)this.indentNextLine, "0, 10, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Unindent_this_line>", (String)"Unindent this line:")), "0, 11, 1, 1, W, w, 2");
        panel.add((Component)this.unindentThisLine, "0, 12, 1, 1, W, w, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Electric_keys>", (String)"Electric keys:")), "0, 13, 1, 1, W, w, 2");
        panel.add((Component)this.electricKeys, "0, 14, 1, 1, W, w, 2");
        panel.add((Component)this.lineUpClosingBracket, "0, 15, 1, 1, W, w, 2");
        panel.add((Component)this.doubleBracketIndent, "0, 16, 1, 1, W, w, 2");
        return panel;
    }

    private JPanel createPaddingPanel() {
        JPanel panel = new JPanel((LayoutManager)new KappaLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.prePadFunctions = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadDigits = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadOperators = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadKeywords1 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadKeywords2 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadKeywords3 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.prePadKeywords4 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.before", (String)"before"));
        this.postPadFunctions = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadDigits = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadOperators = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadKeywords1 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadKeywords2 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadKeywords3 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.postPadKeywords4 = new JCheckBox(jEdit.getProperty((String)"beauty.msg.after", (String)"after"));
        this.labelOnSeparateLine = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Label_on_separate_line", (String)"Label on separate line"));
        this.prePadCharacters = new JTextField();
        this.postPadCharacters = new JTextField();
        this.dontPrePadCharacters = new JTextField();
        this.dontPostPadCharacters = new JTextField();
        this.preInsertLineCharacters = new JTextField();
        this.postInsertLineCharacters = new JTextField();
        this.collapseBlankLines = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Collapse_multiple_blank_lines", (String)"Collapse multiple blank lines"));
        this.collapseLinearWhitespace = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Collapse_linear_whitespace", (String)"Collapse linear whitespace"));
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_functions", (String)"Pad functions")), "0, 4, 1, 1, W, w, 2");
        panel.add((Component)this.prePadFunctions, "1, 4, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadFunctions, "2, 4, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_operators", (String)"Pad operators")), "0, 5, 1, 1, W, w, 2");
        panel.add((Component)this.prePadOperators, "1, 5, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadOperators, "2, 5, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_digits", (String)"Pad digits")), "0, 6, 1, 1, W, w, 2");
        panel.add((Component)this.prePadDigits, "1, 6, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadDigits, "2, 6, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_keywords1", (String)"Pad keywords1")), "0, 7, 1, 1, W, w, 2");
        panel.add((Component)this.prePadKeywords1, "1, 7, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadKeywords1, "2, 7, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_keywords2", (String)"Pad keywords2")), "0, 8, 1, 1, W, w, 2");
        panel.add((Component)this.prePadKeywords2, "1, 8, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadKeywords2, "2, 8, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_keywords2", (String)"Pad keywords2")), "0, 9, 1, 1, W, w, 2");
        panel.add((Component)this.prePadKeywords3, "1, 9, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadKeywords3, "2, 9, 1, 1, W, 0, 2");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_keywords4", (String)"Pad keywords4")), "0, 10, 1, 1, W, w, 2");
        panel.add((Component)this.prePadKeywords4, "1, 10, 1, 1, W, 0, 2");
        panel.add((Component)this.postPadKeywords4, "2, 10, 1, 1, W, 0, 2");
        panel.add((Component)this.labelOnSeparateLine, "0, 11, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 12");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_before_these_characters>", (String)"Pad before these characters:")), "0, 13, R, 1, W, w, 2");
        panel.add((Component)this.prePadCharacters, "0, 14, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 15");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Pad_after_these_characters>", (String)"Pad after these characters:")), "0, 16, R, 1, W, w, 2");
        panel.add((Component)this.postPadCharacters, "0, 17, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 18");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Don't_pad_before_these_characters>", (String)"Don't pad before these characters:")), "0, 19, R, 1, W, w, 2");
        panel.add((Component)this.dontPrePadCharacters, "0, 20, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 21");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Don't_pad_after_these_characters>", (String)"Don't pad after these characters:")), "0, 22, R, 1, W, w, 2");
        panel.add((Component)this.dontPostPadCharacters, "0, 23, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 24");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Insert_line_separator_before_these_strings_(separate_with_comma)>", (String)"Insert line separator before these strings (separate with comma):")), "0, 25, R, 1, W, w, 2");
        panel.add((Component)this.preInsertLineCharacters, "0, 26, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 27");
        panel.add((Component)new JLabel(jEdit.getProperty((String)"beauty.msg.Insert_line_separator_after_these_strings_(separate_with_comma)>", (String)"Insert line separator after these strings (separate with comma):")), "0, 28, R, 1, W, w, 2");
        panel.add((Component)this.postInsertLineCharacters, "0, 29, R, 1, W, w, 2");
        panel.add(KappaLayout.createVerticalStrut((int)6), "0, 30");
        panel.add((Component)this.collapseBlankLines, "0, 31, R, 1, W, w, 2");
        panel.add((Component)this.collapseLinearWhitespace, "0, 32, R, 1, W, w, 2");
        return panel;
    }

    private void installListeners() {
        this.modeSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                CustomBeautifierOptionPane.this.updateComponents(ie);
            }
        });
        this.usejEditIndenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CustomBeautifierOptionPane.this.indentOpenBrackets.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.indentCloseBrackets.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.unalignedOpenBrackets.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.unalignedCloseBrackets.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.indentNextLine.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.unindentThisLine.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.electricKeys.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.lineUpClosingBracket.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
                CustomBeautifierOptionPane.this.doubleBracketIndent.setEnabled(CustomBeautifierOptionPane.this.usejEditIndenter.isSelected());
            }
        });
    }

    private boolean getBoolean(String key) {
        String value = this.modeProperties.getProperty(key);
        return "true".equals(value);
    }

    private String getText(String key) {
        String value = this.modeProperties.getProperty(key);
        return value == null ? "" : value;
    }

    public void _save() {
        String name = this.currentMode.getName();
        this.modeProperties.setProperty(Constants.PRE_PAD_FUNCTIONS, this.prePadFunctions.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_DIGITS, this.prePadDigits.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_OPERATORS, this.prePadOperators.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_KEYWORDS1, this.prePadKeywords1.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_KEYWORDS2, this.prePadKeywords2.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_KEYWORDS3, this.prePadKeywords3.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_KEYWORDS4, this.prePadKeywords4.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_FUNCTIONS, this.postPadFunctions.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_DIGITS, this.postPadDigits.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_OPERATORS, this.postPadOperators.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_KEYWORDS1, this.postPadKeywords1.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_KEYWORDS2, this.postPadKeywords2.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_KEYWORDS3, this.postPadKeywords3.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.POST_PAD_KEYWORDS4, this.postPadKeywords4.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.LABEL_ON_SEPARATE_LINE, this.labelOnSeparateLine.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.COLLAPSE_BLANK_LINES, this.collapseBlankLines.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.COLLAPSE_LINEAR_WHITESPACE, this.collapseLinearWhitespace.isSelected() ? "true" : "false");
        this.modeProperties.setProperty(Constants.PRE_PAD_CHARACTERS, this.prePadCharacters.getText());
        this.modeProperties.setProperty(Constants.POST_PAD_CHARACTERS, this.postPadCharacters.getText());
        this.modeProperties.setProperty(Constants.DONT_PRE_PAD_CHARACTERS, this.dontPrePadCharacters.getText());
        this.modeProperties.setProperty(Constants.DONT_POST_PAD_CHARACTERS, this.dontPostPadCharacters.getText());
        this.modeProperties.setProperty(Constants.PRE_INSERT_LINE_CHARACTERS, this.preInsertLineCharacters.getText());
        this.modeProperties.setProperty(Constants.POST_INSERT_LINE_CHARACTERS, this.postInsertLineCharacters.getText());
        this.modeProperties.setProperty(Constants.USE_JEDIT_INDENTER, this.usejEditIndenter.isSelected() ? "true" : "false");
        if (this.usejEditIndenter.isSelected()) {
            this.modeProperties.setProperty(Constants.INDENT_OPEN_BRACKETS, this.indentOpenBrackets.getText());
            this.modeProperties.setProperty(Constants.INDENT_CLOSE_BRACKETS, this.indentCloseBrackets.getText());
            this.modeProperties.setProperty(Constants.UNALIGNED_OPEN_BRACKETS, this.unalignedOpenBrackets.getText());
            this.modeProperties.setProperty(Constants.UNALIGNED_CLOSE_BRACKETS, this.unalignedCloseBrackets.getText());
            this.modeProperties.setProperty(Constants.INDENT_NEXT_LINE, this.indentNextLine.getText());
            this.modeProperties.setProperty(Constants.UNINDENT_THIS_LINE, this.unindentThisLine.getText());
            this.modeProperties.setProperty(Constants.ELECTRIC_KEYS, this.electricKeys.getText());
            this.modeProperties.setProperty(Constants.LINE_UP_CLOSING_BRACKET, this.lineUpClosingBracket.isSelected() ? "true" : "false");
            this.modeProperties.setProperty(Constants.DOUBLE_BRACKET_INDENT, this.doubleBracketIndent.isSelected() ? "true" : "false");
            this.currentMode.setProperty(Constants.INDENT_OPEN_BRACKETS, (Object)this.indentOpenBrackets.getText());
            this.currentMode.setProperty(Constants.INDENT_CLOSE_BRACKETS, (Object)this.indentCloseBrackets.getText());
            this.currentMode.setProperty(Constants.UNALIGNED_OPEN_BRACKETS, (Object)this.unalignedOpenBrackets.getText());
            this.currentMode.setProperty(Constants.UNALIGNED_CLOSE_BRACKETS, (Object)this.unalignedCloseBrackets.getText());
            this.currentMode.setProperty(Constants.INDENT_NEXT_LINE, (Object)this.indentNextLine.getText());
            this.currentMode.setProperty(Constants.UNINDENT_THIS_LINE, (Object)this.unindentThisLine.getText());
            this.currentMode.setProperty(Constants.ELECTRIC_KEYS, (Object)this.electricKeys.getText());
            this.currentMode.setProperty(Constants.LINE_UP_CLOSING_BRACKET, (Object)this.lineUpClosingBracket.isSelected());
            this.currentMode.setProperty(Constants.DOUBLE_BRACKET_INDENT, (Object)this.doubleBracketIndent.isSelected());
        }
        BeautyPlugin.saveProperties(name, this.modeProperties);
        BeautyPlugin.registerServices();
    }

    private void updateComponents(final ItemEvent ie) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CustomBeautifierOptionPane.this.clearComponentValues();
                Mode selectedMode = (Mode)ie.getItem();
                CustomBeautifierOptionPane.this.currentMode = selectedMode;
                CustomBeautifierOptionPane.this.loadProperties(CustomBeautifierOptionPane.this.currentMode.getName());
                CustomBeautifierOptionPane.this.setComponentValues();
            }
        });
    }

    private void clearComponentValues() {
        this.usejEditIndenter.setSelected(false);
        this.prePadFunctions.setSelected(false);
        this.prePadDigits.setSelected(false);
        this.prePadOperators.setSelected(false);
        this.prePadKeywords1.setSelected(false);
        this.prePadKeywords2.setSelected(false);
        this.prePadKeywords3.setSelected(false);
        this.prePadKeywords4.setSelected(false);
        this.postPadFunctions.setSelected(false);
        this.postPadDigits.setSelected(false);
        this.postPadOperators.setSelected(false);
        this.postPadKeywords1.setSelected(false);
        this.postPadKeywords2.setSelected(false);
        this.postPadKeywords3.setSelected(false);
        this.postPadKeywords4.setSelected(false);
        this.labelOnSeparateLine.setSelected(false);
        this.collapseBlankLines.setSelected(false);
        this.collapseLinearWhitespace.setSelected(false);
        this.prePadCharacters.setText("");
        this.postPadCharacters.setText("");
        this.dontPrePadCharacters.setText("");
        this.dontPostPadCharacters.setText("");
        this.preInsertLineCharacters.setText("");
        this.postInsertLineCharacters.setText("");
        this.indentOpenBrackets.setText("");
        this.indentCloseBrackets.setText("");
        this.unalignedOpenBrackets.setText("");
        this.unalignedCloseBrackets.setText("");
        this.indentNextLine.setText("");
        this.unindentThisLine.setText("");
        this.electricKeys.setText("");
        this.lineUpClosingBracket.setSelected(false);
        this.doubleBracketIndent.setSelected(false);
    }

    private void setComponentValues() {
        this.prePadFunctions.setSelected(this.getBoolean(Constants.PRE_PAD_FUNCTIONS));
        this.prePadDigits.setSelected(this.getBoolean(Constants.PRE_PAD_DIGITS));
        this.prePadOperators.setSelected(this.getBoolean(Constants.PRE_PAD_OPERATORS));
        this.prePadKeywords1.setSelected(this.getBoolean(Constants.PRE_PAD_KEYWORDS1));
        this.prePadKeywords2.setSelected(this.getBoolean(Constants.PRE_PAD_KEYWORDS2));
        this.prePadKeywords3.setSelected(this.getBoolean(Constants.PRE_PAD_KEYWORDS3));
        this.prePadKeywords4.setSelected(this.getBoolean(Constants.PRE_PAD_KEYWORDS4));
        this.postPadFunctions.setSelected(this.getBoolean(Constants.POST_PAD_FUNCTIONS));
        this.postPadDigits.setSelected(this.getBoolean(Constants.POST_PAD_DIGITS));
        this.postPadOperators.setSelected(this.getBoolean(Constants.POST_PAD_OPERATORS));
        this.postPadKeywords1.setSelected(this.getBoolean(Constants.POST_PAD_KEYWORDS1));
        this.postPadKeywords2.setSelected(this.getBoolean(Constants.POST_PAD_KEYWORDS2));
        this.postPadKeywords3.setSelected(this.getBoolean(Constants.POST_PAD_KEYWORDS3));
        this.postPadKeywords4.setSelected(this.getBoolean(Constants.POST_PAD_KEYWORDS4));
        this.labelOnSeparateLine.setSelected(this.getBoolean(Constants.LABEL_ON_SEPARATE_LINE));
        this.collapseBlankLines.setSelected(this.getBoolean(Constants.COLLAPSE_BLANK_LINES));
        this.collapseLinearWhitespace.setSelected(this.getBoolean(Constants.COLLAPSE_LINEAR_WHITESPACE));
        this.prePadCharacters.setText(this.getText(Constants.PRE_PAD_CHARACTERS));
        this.postPadCharacters.setText(this.getText(Constants.POST_PAD_CHARACTERS));
        this.dontPrePadCharacters.setText(this.getText(Constants.DONT_PRE_PAD_CHARACTERS));
        this.dontPostPadCharacters.setText(this.getText(Constants.DONT_POST_PAD_CHARACTERS));
        this.preInsertLineCharacters.setText(this.getText(Constants.PRE_INSERT_LINE_CHARACTERS));
        this.postInsertLineCharacters.setText(this.getText(Constants.POST_INSERT_LINE_CHARACTERS));
        this.usejEditIndenter.setSelected(this.getBoolean(Constants.USE_JEDIT_INDENTER));
        this.indentOpenBrackets.setEnabled(this.usejEditIndenter.isSelected());
        this.indentCloseBrackets.setEnabled(this.usejEditIndenter.isSelected());
        this.unalignedOpenBrackets.setEnabled(this.usejEditIndenter.isSelected());
        this.unalignedCloseBrackets.setEnabled(this.usejEditIndenter.isSelected());
        this.indentNextLine.setEnabled(this.usejEditIndenter.isSelected());
        this.unindentThisLine.setEnabled(this.usejEditIndenter.isSelected());
        this.electricKeys.setEnabled(this.usejEditIndenter.isSelected());
        this.lineUpClosingBracket.setEnabled(this.usejEditIndenter.isSelected());
        this.doubleBracketIndent.setEnabled(this.usejEditIndenter.isSelected());
        this.indentOpenBrackets.setText(this.getText(Constants.INDENT_OPEN_BRACKETS));
        this.indentCloseBrackets.setText(this.getText(Constants.INDENT_CLOSE_BRACKETS));
        this.unalignedOpenBrackets.setText(this.getText(Constants.UNALIGNED_OPEN_BRACKETS));
        this.unalignedCloseBrackets.setText(this.getText(Constants.UNALIGNED_CLOSE_BRACKETS));
        this.indentNextLine.setText(this.getText(Constants.INDENT_NEXT_LINE));
        this.unindentThisLine.setText(this.getText(Constants.UNINDENT_THIS_LINE));
        this.electricKeys.setText(this.getText(Constants.ELECTRIC_KEYS));
        this.lineUpClosingBracket.setSelected(this.getBoolean(Constants.LINE_UP_CLOSING_BRACKET));
        this.doubleBracketIndent.setSelected(this.getBoolean(Constants.DOUBLE_BRACKET_INDENT));
    }
}

