/*
 * Decompiled with CFR 0.152.
 */
package beauty.options;

import beauty.options.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.jEdit;

public class BeautifierOptionPane
extends AbstractOptionPane {
    private MyTableModel tableModel;

    public BeautifierOptionPane() {
        super("beauty.beautifiers");
    }

    public void _init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        JLabel description = new JLabel(jEdit.getProperty((String)"beauty.msg.<html><b>Assign_beautifiers_to_modes", (String)"<html><b>Assign beautifiers to modes"));
        topPanel.add("Center", description);
        JPanel centerPanel = new JPanel(new BorderLayout());
        final JCheckBox defaultIndenter = new JCheckBox(jEdit.getProperty((String)"beauty.msg.Use_jEdit_indenter_for_undefined_modes", (String)"Use jEdit indenter for undefined modes"));
        defaultIndenter.setSelected(jEdit.getBooleanProperty((String)"beauty.useBuiltInIndenter", (boolean)true));
        defaultIndenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                jEdit.setBooleanProperty((String)"beauty.useBuiltInIndenter", (boolean)defaultIndenter.isSelected());
            }
        });
        centerPanel.add("North", defaultIndenter);
        centerPanel.add("Center", this.createTableScroller());
        this.add("North", topPanel);
        this.add("Center", centerPanel);
    }

    public void _save() {
        this.tableModel.save();
    }

    private JScrollPane createTableScroller() {
        this.tableModel = this.createModel();
        JTable table = new JTable(this.tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        String[] serviceNames = ServiceManager.getServiceNames((String)"beauty.beautifiers.Beautifier");
        Vector<String> beautifierList = new Vector<String>(serviceNames.length + 2);
        for (int i = 0; i < serviceNames.length; ++i) {
            beautifierList.add(serviceNames[i]);
        }
        Collections.sort(beautifierList, new Comparator(){

            public int compare(Object a, Object b) {
                return a.toString().compareToIgnoreCase(b.toString());
            }
        });
        beautifierList.add(0, "none");
        beautifierList.add(0, null);
        BeautifierCellRenderer comboBox = new BeautifierCellRenderer(beautifierList);
        table.setRowHeight(comboBox.getPreferredSize().height);
        TableColumn column = table.getColumnModel().getColumn(1);
        column.setCellRenderer(comboBox);
        column.setCellEditor(new DefaultCellEditor(new BeautifierCellRenderer(beautifierList)));
        Dimension d = table.getPreferredSize();
        d.height = Math.min(d.height, 50);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private MyTableModel createModel() {
        return new MyTableModel();
    }

    class BeautifierCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        BeautifierCellRenderer(Vector vector) {
            super(vector);
            this.setRequestFocusEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedItem(value);
            return this;
        }
    }
}

