/*
 * Decompiled with CFR 0.152.
 */
package beauty.beautifiers;

import beauty.beautifiers.DefaultBeautifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLineBeautifier
extends DefaultBeautifier {
    private static final Pattern genericPattern = Pattern.compile("\\s*[<]\\s*((\\w([,]\\s*)?)+)\\s*[>]");

    public JavaLineBeautifier() {
        super("java");
    }

    public String beautify(String text) {
        String s = super.beautify(text);
        s = this.adjustGenerics(s);
        s = s.replaceAll("[!]\\s*", "!");
        return s;
    }

    String adjustGenerics(String s) {
        String ls = this.getLineSeparator();
        String[] lines = s.split(ls);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            Matcher m = genericPattern.matcher(line);
            line = m.replaceAll("<$1>");
            sb.append(line).append(ls);
        }
        return sb.toString();
    }
}

