/*
 * Decompiled with CFR 0.152.
 */
package beauty.beautifiers;

import beauty.beautifiers.Beautifier;
import beauty.parsers.ParserException;
import beauty.parsers.java.JavaParser;
import java.io.StringReader;
import org.gjt.sp.jedit.jEdit;

public class JavaBeautifier
extends Beautifier {
    private static JavaParser parser = null;
    private int bracketStyle = 1;
    private boolean breakElse = false;
    private boolean padParens = false;

    public void init() {
        this.bracketStyle = jEdit.getIntegerProperty((String)"beauty.java.bracketStyle", (int)1);
        this.breakElse = jEdit.getBooleanProperty((String)"beauty.java.breakElse", (boolean)false);
        this.padParens = jEdit.getBooleanProperty((String)"beauty.java.padParens", (boolean)false);
    }

    public String beautify(String text) throws ParserException {
        try {
            StringReader is = new StringReader(text);
            if (parser == null) {
                parser = new JavaParser(is);
            } else {
                parser.ReInit(is);
                parser.resetTokenSource();
            }
            parser.setIndentWidth(this.getIndentWidth());
            parser.setTabSize(this.getTabWidth());
            parser.setLineSeparator(this.getLineSeparator());
            parser.setBracketStyle(this.bracketStyle);
            parser.setBreakElse(this.breakElse);
            parser.setPadParens(this.padParens);
            parser.parse();
            text = parser.getText();
            return text;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public void setBracketStyle(int style) {
        this.bracketStyle = style;
    }

    public void setBreakElse(boolean b) {
        this.breakElse = b;
    }

    public void setPadParens(boolean pad) {
        this.padParens = pad;
    }
}

