/*
 * Decompiled with CFR 0.152.
 */
package beauty.beautifiers;

import beauty.beautifiers.Beautifier;
import beauty.parsers.ParserException;
import beauty.parsers.html.HtmlCollector;
import beauty.parsers.html.HtmlDocument;
import beauty.parsers.html.HtmlFormatter;
import beauty.parsers.html.HtmlParser;
import beauty.parsers.html.HtmlScrubber;
import java.io.StringReader;

public class HtmlFormat
extends Beautifier {
    public String beautify(String text) throws ParserException {
        StringReader reader = new StringReader(text);
        HtmlFormatter formatter = null;
        try {
            HtmlParser parser = new HtmlParser(reader);
            HtmlDocument document = parser.HtmlDocument();
            document.setLineSeparator(this.getLineSeparator());
            document.accept(new HtmlCollector());
            int scrubber_params = 42;
            if ("jsp".equals(this.getEditMode())) {
                scrubber_params = 32;
            }
            document.accept(new HtmlScrubber(scrubber_params));
            formatter = new HtmlFormatter();
            if (this.getWrapMode().equals("none")) {
                formatter.setRightMargin(Integer.MAX_VALUE);
            } else {
                formatter.setRightMargin(this.getWrapMargin());
            }
            formatter.setLineSeparator(this.getLineSeparator());
            formatter.setIndent(this.getIndentWidth());
            document.accept(formatter);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        finally {
            reader.close();
        }
        return formatter != null ? formatter.toString() : text;
    }
}

