/*
 * Decompiled with CFR 0.152.
 */
package beauty.beautifiers;

import beauty.BeautyPlugin;
import beauty.PrivilegedAccessor;
import beauty.beautifiers.Beautifier;
import beauty.beautifiers.Constants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeautifier
extends Beautifier {
    private String modeName = null;
    private boolean prePadOperator = false;
    private boolean prePadFunction = false;
    private boolean prePadDigit = false;
    private boolean prePadKeyword1 = false;
    private boolean prePadKeyword2 = false;
    private boolean prePadKeyword3 = false;
    private boolean prePadKeyword4 = false;
    private boolean postPadOperator = false;
    private boolean postPadFunction = false;
    private boolean postPadDigit = false;
    private boolean postPadKeyword1 = false;
    private boolean postPadKeyword2 = false;
    private boolean postPadKeyword3 = false;
    private boolean postPadKeyword4 = false;
    private boolean labelOnSeparateLine = true;
    private String prePadCharacters = "";
    private String postPadCharacters = "";
    private String dontPrePadCharacters = "";
    private String dontPostPadCharacters = "";
    private String preInsertLineCharacters = "";
    private String postInsertLineCharacters = "";
    private boolean collapseBlankLines = false;
    private boolean collapseLinearWhitespace = false;
    private boolean indentLines = false;
    private String indentOpenBrackets = "";
    private String indentCloseBrackets = "";
    private String unalignedOpenBrackets = "";
    private String unalignedCloseBrackets = "";
    private String indentNextLine = "";
    private String unindentThisLine = "";
    private String electricKeys = "";

    public DefaultBeautifier() {
    }

    public DefaultBeautifier(String modeName) {
        if (modeName == null || modeName.isEmpty()) {
            throw new IllegalArgumentException("mode name was null");
        }
        this.modeName = modeName;
        Properties props = BeautyPlugin.getCustomModeProperties(modeName);
        this.prePadOperator = "true".equals(props.getProperty(Constants.PRE_PAD_OPERATORS));
        this.prePadFunction = "true".equals(props.getProperty(Constants.PRE_PAD_FUNCTIONS));
        this.prePadDigit = "true".equals(props.getProperty(Constants.PRE_PAD_DIGITS));
        this.prePadKeyword1 = "true".equals(props.getProperty(Constants.PRE_PAD_KEYWORDS1));
        this.prePadKeyword2 = "true".equals(props.getProperty(Constants.PRE_PAD_KEYWORDS2));
        this.prePadKeyword3 = "true".equals(props.getProperty(Constants.PRE_PAD_KEYWORDS3));
        this.prePadKeyword4 = "true".equals(props.getProperty(Constants.PRE_PAD_KEYWORDS4));
        this.postPadOperator = "true".equals(props.getProperty(Constants.POST_PAD_OPERATORS));
        this.postPadFunction = "true".equals(props.getProperty(Constants.POST_PAD_FUNCTIONS));
        this.postPadDigit = "true".equals(props.getProperty(Constants.POST_PAD_DIGITS));
        this.postPadKeyword1 = "true".equals(props.getProperty(Constants.POST_PAD_KEYWORDS1));
        this.postPadKeyword2 = "true".equals(props.getProperty(Constants.POST_PAD_KEYWORDS2));
        this.postPadKeyword3 = "true".equals(props.getProperty(Constants.POST_PAD_KEYWORDS3));
        this.postPadKeyword4 = "true".equals(props.getProperty(Constants.POST_PAD_KEYWORDS4));
        this.labelOnSeparateLine = "true".equals(props.getProperty(Constants.LABEL_ON_SEPARATE_LINE));
        this.prePadCharacters = props.getProperty(Constants.PRE_PAD_CHARACTERS) == null ? "" : props.getProperty(Constants.PRE_PAD_CHARACTERS);
        this.postPadCharacters = props.getProperty(Constants.POST_PAD_CHARACTERS) == null ? "" : props.getProperty(Constants.POST_PAD_CHARACTERS);
        this.dontPrePadCharacters = props.getProperty(Constants.DONT_PRE_PAD_CHARACTERS) == null ? "" : props.getProperty(Constants.DONT_PRE_PAD_CHARACTERS);
        this.dontPostPadCharacters = props.getProperty(Constants.DONT_POST_PAD_CHARACTERS) == null ? "" : props.getProperty(Constants.DONT_POST_PAD_CHARACTERS);
        this.preInsertLineCharacters = props.getProperty(Constants.PRE_INSERT_LINE_CHARACTERS) == null ? "" : props.getProperty(Constants.PRE_INSERT_LINE_CHARACTERS);
        this.postInsertLineCharacters = props.getProperty(Constants.POST_INSERT_LINE_CHARACTERS) == null ? "" : props.getProperty(Constants.POST_INSERT_LINE_CHARACTERS);
        this.collapseBlankLines = "true".equals(props.getProperty(Constants.COLLAPSE_BLANK_LINES));
        this.collapseLinearWhitespace = "true".equals(props.getProperty(Constants.COLLAPSE_LINEAR_WHITESPACE));
        this.indentLines = "true".equals(props.getProperty(Constants.USE_JEDIT_INDENTER));
        this.indentOpenBrackets = props.getProperty(Constants.INDENT_OPEN_BRACKETS) == null ? "" : props.getProperty(Constants.INDENT_OPEN_BRACKETS);
        this.indentCloseBrackets = props.getProperty(Constants.INDENT_CLOSE_BRACKETS) == null ? "" : props.getProperty(Constants.INDENT_CLOSE_BRACKETS);
        this.unalignedOpenBrackets = props.getProperty(Constants.UNALIGNED_OPEN_BRACKETS) == null ? "" : props.getProperty(Constants.UNALIGNED_OPEN_BRACKETS);
        this.unalignedCloseBrackets = props.getProperty(Constants.UNALIGNED_CLOSE_BRACKETS) == null ? "" : props.getProperty(Constants.UNALIGNED_CLOSE_BRACKETS);
        this.indentNextLine = props.getProperty(Constants.INDENT_NEXT_LINE) == null ? "" : props.getProperty(Constants.INDENT_NEXT_LINE);
        this.unindentThisLine = props.getProperty(Constants.UNINDENT_THIS_LINE) == null ? "" : props.getProperty(Constants.UNINDENT_THIS_LINE);
        this.electricKeys = props.getProperty(Constants.ELECTRIC_KEYS) == null ? "" : props.getProperty(Constants.ELECTRIC_KEYS);
    }

    @Override
    public String beautify(String text) {
        StringBuilder sb = new StringBuilder(text);
        sb = this.padTokens(sb);
        List<PToken> tokens = this.parseTokens(sb);
        for (PToken token : tokens) {
            if (!token.isText) continue;
            String s = token.tokenText;
            s = this.prePadCharacters(s);
            s = this.postPadCharacters(s);
            s = this.preInsertLineSeparators(s);
            s = this.postInsertLineSeparators(s);
            s = this.dontPrePadCharacters(s);
            s = this.dontPostPadCharacters(s);
            s = this.collapseBlankLines(s);
            token.tokenText = s = this.collapseLinearWhitespace(s);
        }
        sb.setLength(0);
        for (PToken token : tokens) {
            sb.append(token.tokenText);
        }
        sb = this.padKeywords(sb);
        if (this.indentLines) {
            sb = this.indentLines(sb);
        }
        return sb.toString();
    }

    StringBuilder padTokens(StringBuilder sb) {
        if (this.prePadFunction || this.postPadFunction || this.prePadOperator || this.postPadOperator || this.prePadDigit || this.postPadDigit || this.prePadKeyword1 || this.postPadKeyword1 || this.prePadKeyword2 || this.postPadKeyword2 || this.prePadKeyword3 || this.postPadKeyword3 || this.prePadKeyword4 || this.postPadKeyword4) {
            try {
                File tempFile = File.createTempFile("tmp", null);
                tempFile.deleteOnExit();
                Buffer tempBuffer = jEdit.openTemporary((View)jEdit.getActiveView(), null, (String)tempFile.getAbsolutePath(), (boolean)true);
                tempBuffer.setMode(jEdit.getMode((String)this.modeName));
                tempBuffer.insert(0, sb.toString());
                sb.setLength(0);
                int firstLine = 0;
                int lastLine = tempBuffer.getLineCount();
                DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
                for (int lineNum = firstLine; lineNum < lastLine; ++lineNum) {
                    String nextTokenText;
                    tokenHandler.init();
                    int lineStart = tempBuffer.getLineStartOffset(lineNum);
                    tempBuffer.markTokens(lineNum, (TokenHandler)tokenHandler);
                    Token token = tokenHandler.getTokens();
                    int tokenStart = lineStart;
                    String previousTokenText = "";
                    int previousTokenId = 0;
                    String currentTokenText = tempBuffer.getText(tokenStart, token.length);
                    String string = nextTokenText = token.next != null ? tempBuffer.getText(tokenStart + token.length, token.next.length) : "";
                    while (token.id != 127) {
                        boolean onlyWhitespace;
                        if (!previousTokenText.endsWith(" ") && (token.id == 18 && this.prePadOperator && previousTokenId != 18 || token.id == 6 && this.prePadFunction || token.id == 5 && this.prePadDigit || token.id == 8 && this.prePadKeyword1 || token.id == 9 && this.prePadKeyword2 || token.id == 10 && this.prePadKeyword3 || token.id == 11 && this.prePadKeyword4)) {
                            sb.append(' ');
                        }
                        boolean bl = onlyWhitespace = tempBuffer.getText(lineStart, tokenStart - lineStart).trim().length() > 0;
                        if (token.id == 12 && this.labelOnSeparateLine && onlyWhitespace) {
                            sb.append(this.getLineSeparator());
                        }
                        sb.append(currentTokenText);
                        if (!nextTokenText.startsWith(" ") && (token.id == 18 && this.postPadOperator && token.next.id != 18 || token.id == 6 && this.postPadFunction || token.id == 5 && this.postPadDigit || token.id == 8 && this.postPadKeyword1 || token.id == 9 && this.postPadKeyword2 || token.id == 10 && this.postPadKeyword3 || token.id == 11 && this.postPadKeyword4)) {
                            sb.append(' ');
                            currentTokenText = currentTokenText + " ";
                        }
                        previousTokenText = currentTokenText;
                        previousTokenId = token.id;
                        currentTokenText = nextTokenText;
                        tokenStart += token.length;
                        token = token.next;
                        if (token.next == null) continue;
                        nextTokenText = tempBuffer.getText(tokenStart + token.length, token.next.length);
                    }
                    if (lineNum > lastLine - 2) continue;
                    sb.append(this.getLineSeparator());
                }
                if (sb.length() == 0) {
                    sb = new StringBuilder(tempBuffer.getText(0, tempBuffer.getLength()));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return sb;
    }

    String prePadCharacters(String s) {
        if (this.prePadCharacters.length() == 0) {
            return s;
        }
        for (int i = 0; i < this.prePadCharacters.length(); ++i) {
            char c = this.prePadCharacters.charAt(i);
            s = s.replaceAll("(\\S)[" + c + "]", "$1 " + c);
        }
        return s;
    }

    String postPadCharacters(String s) {
        if (this.postPadCharacters.length() == 0) {
            return s;
        }
        for (int i = 0; i < this.postPadCharacters.length(); ++i) {
            char c = this.postPadCharacters.charAt(i);
            s = s.replaceAll("[" + (c == '[' || c == ']' ? "\\" : "") + c + "](\\S)", c + " $1");
        }
        return s;
    }

    String preInsertLineSeparators(String s) {
        String[] chars;
        if (this.preInsertLineCharacters.length() == 0) {
            return s;
        }
        s = this.trimStart(s);
        String pilc = this.preInsertLineCharacters;
        pilc = pilc.replaceAll("\\\\,", "\\\\c1f");
        for (String c : chars = pilc.split(",")) {
            c = c.replaceAll("\\\\c1f", ",");
            s = this.preInsertLineSeparators(s, c);
        }
        return s;
    }

    String preInsertLineSeparators(String s, String c) {
        try {
            String ls = this.getLineSeparator();
            String regex = "(?<!(" + this.getLSString() + "))(" + c + ")";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(s);
            s = m.replaceAll(ls + "$2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    String postInsertLineSeparators(String s) {
        String[] chars;
        if (this.postInsertLineCharacters.length() == 0) {
            return s;
        }
        s = this.trimEnd(s);
        String pilc = this.postInsertLineCharacters;
        pilc = pilc.replaceAll("\\\\,", "\\\\c1f");
        for (String c : chars = pilc.split(",")) {
            c = c.replaceAll("\\\\c1f", ",");
            s = this.postInsertLineSeparators(s, c);
        }
        return s;
    }

    String postInsertLineSeparators(String s, String c) {
        try {
            String ls = this.getLineSeparator();
            String regex = "(" + c + ")(?!(" + this.getLSString() + "))";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(s);
            s = m.replaceAll("$1" + ls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    String dontPrePadCharacters(String s) {
        if (this.dontPrePadCharacters.length() == 0) {
            return s;
        }
        if (this.dontPrePadCharacters.length() > 0) {
            for (int i = 0; i < this.dontPrePadCharacters.length(); ++i) {
                char c = this.dontPrePadCharacters.charAt(i);
                s = s.replaceAll("\\s+[" + (c == '[' || c == ']' || c == '\\' ? "\\" : "") + c + "]", String.valueOf(c));
            }
        }
        return s;
    }

    String dontPostPadCharacters(String s) {
        if (this.dontPostPadCharacters.length() == 0) {
            return s;
        }
        if (this.dontPostPadCharacters.length() > 0) {
            for (int i = 0; i < this.dontPostPadCharacters.length(); ++i) {
                char c = this.dontPostPadCharacters.charAt(i);
                s = s.replaceAll("[" + (c == '[' || c == ']' || c == '\\' ? "\\" : "") + c + "]\\s+", String.valueOf(c));
            }
        }
        return s;
    }

    StringBuilder padKeywords(StringBuilder sb) {
        if (this.prePadKeyword1 || this.postPadKeyword1 || this.prePadKeyword2 || this.postPadKeyword2 || this.prePadKeyword3 || this.postPadKeyword3 || this.prePadKeyword4 || this.postPadKeyword4) {
            try {
                File tempFile = File.createTempFile("tmp", null);
                tempFile.deleteOnExit();
                Buffer tempBuffer = jEdit.openTemporary((View)jEdit.getActiveView(), null, (String)tempFile.getAbsolutePath(), (boolean)true);
                tempBuffer.setMode(jEdit.getMode((String)this.modeName));
                tempBuffer.insert(0, sb.toString());
                sb.setLength(0);
                int firstLine = 0;
                int lastLine = tempBuffer.getLineCount();
                DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
                for (int lineNum = firstLine; lineNum < lastLine; ++lineNum) {
                    String nextTokenText;
                    tokenHandler.init();
                    int lineStart = tempBuffer.getLineStartOffset(lineNum);
                    tempBuffer.markTokens(lineNum, (TokenHandler)tokenHandler);
                    Token token = tokenHandler.getTokens();
                    int tokenStart = lineStart;
                    String previousTokenText = "";
                    String currentTokenText = tempBuffer.getText(tokenStart, token.length);
                    String string = nextTokenText = token.next != null ? tempBuffer.getText(tokenStart + token.length, token.next.length) : "";
                    while (token.id != 127) {
                        if (!previousTokenText.endsWith(" ") && (token.id == 8 && this.prePadKeyword1 || token.id == 9 && this.prePadKeyword2 || token.id == 10 && this.prePadKeyword3 || token.id == 11 && this.prePadKeyword4)) {
                            sb.append(' ');
                        }
                        sb.append(currentTokenText);
                        if (!nextTokenText.startsWith(" ") && (token.id == 8 && this.postPadKeyword1 || token.id == 9 && this.postPadKeyword2 || token.id == 10 && this.postPadKeyword3 || token.id == 11 && this.postPadKeyword4)) {
                            sb.append(' ');
                            currentTokenText = currentTokenText + " ";
                        }
                        previousTokenText = currentTokenText;
                        currentTokenText = nextTokenText;
                        tokenStart += token.length;
                        token = token.next;
                        if (token.next == null) continue;
                        nextTokenText = tempBuffer.getText(tokenStart + token.length, token.next.length);
                    }
                    if (lineNum > lastLine - 2) continue;
                    sb.append(this.getLineSeparator());
                }
                if (sb.length() == 0) {
                    sb = new StringBuilder(tempBuffer.getText(0, tempBuffer.getLength()));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return sb;
    }

    String collapseBlankLines(String s) {
        if (!this.collapseBlankLines) {
            return s;
        }
        String regex = "(([ ]|[\\t])*(" + this.getLSString() + ")){2,}";
        s = s.replaceAll(regex, this.getLineSeparator());
        return s;
    }

    String collapseLinearWhitespace(String s) {
        if (!this.collapseLinearWhitespace) {
            return s;
        }
        String regex = "([ ]|[\\t]){2,}";
        s = s.replaceAll(regex, " ");
        return s;
    }

    StringBuilder indentLines(StringBuilder sb) {
        try {
            Mode mode = jEdit.getMode((String)this.modeName);
            PrivilegedAccessor.setValue(mode, "indentRules", null);
            mode.setProperty(Constants.INDENT_OPEN_BRACKETS, (Object)this.indentOpenBrackets);
            mode.setProperty(Constants.INDENT_CLOSE_BRACKETS, (Object)this.indentCloseBrackets);
            mode.setProperty(Constants.UNALIGNED_OPEN_BRACKETS, (Object)this.unalignedOpenBrackets);
            mode.setProperty(Constants.UNALIGNED_CLOSE_BRACKETS, (Object)this.unalignedCloseBrackets);
            mode.setProperty(Constants.INDENT_NEXT_LINE, (Object)this.indentNextLine);
            mode.setProperty(Constants.UNINDENT_THIS_LINE, (Object)this.unindentThisLine);
            mode.setProperty(Constants.ELECTRIC_KEYS, (Object)this.electricKeys);
            mode.getIndentRules();
            File tempFile = File.createTempFile("tmp", null);
            tempFile.deleteOnExit();
            Buffer tempBuffer = jEdit.openTemporary((View)jEdit.getActiveView(), null, (String)tempFile.getAbsolutePath(), (boolean)true);
            tempBuffer.setMode(mode);
            tempBuffer.insert(0, sb.toString());
            tempBuffer.indentLines(0, tempBuffer.getLineCount() - 1);
            sb = new StringBuilder(tempBuffer.getText(0, tempBuffer.getLength()));
            if (this.initialLevel > 0) {
                StringBuilder pad = new StringBuilder();
                for (int i = 0; i < this.initialLevel; ++i) {
                    pad.append(this.indent);
                }
                String all = sb.toString();
                String ls = this.getLineSeparator();
                String[] lines = all.split(ls);
                sb.setLength(0);
                for (String line : lines) {
                    sb.append((CharSequence)pad).append(line).append(ls);
                }
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return sb;
    }

    private String getLSString() {
        String ls = this.getLineSeparator();
        if ("\r".equals(ls)) {
            return "\\r";
        }
        if ("\r\n".equals(ls)) {
            return "\\r\\n";
        }
        return "\\n";
    }

    public List<PToken> parseTokens(StringBuilder sb) {
        ArrayList<PToken> ptokens = new ArrayList<PToken>();
        try {
            StringBuilder textBuffer = new StringBuilder();
            StringBuilder commentBuffer = new StringBuilder();
            StringBuilder literalBuffer = new StringBuilder();
            File tempFile = File.createTempFile("tmp", null);
            tempFile.deleteOnExit();
            Buffer tempBuffer = jEdit.openTemporary((View)jEdit.getActiveView(), null, (String)tempFile.getAbsolutePath(), (boolean)true);
            tempBuffer.setMode(jEdit.getMode((String)this.modeName));
            tempBuffer.insert(0, sb.toString());
            int firstLine = 0;
            int lastLine = tempBuffer.getLineCount();
            DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
            for (int lineNum = firstLine; lineNum < lastLine; ++lineNum) {
                String nextTokenText;
                tokenHandler.init();
                int lineStart = tempBuffer.getLineStartOffset(lineNum);
                tempBuffer.markTokens(lineNum, (TokenHandler)tokenHandler);
                Token token = tokenHandler.getTokens();
                int tokenStart = lineStart;
                String currentTokenText = tempBuffer.getText(tokenStart, token.length);
                String string = nextTokenText = token.next != null ? tempBuffer.getText(tokenStart + token.length, token.next.length) : "";
                while (token.id != 127) {
                    PToken commentToken;
                    PToken literalToken;
                    PToken textToken;
                    if (token.id == 1 || token.id == 2 || token.id == 3 || token.id == 4) {
                        if (textBuffer.length() > 0) {
                            textToken = new PToken();
                            textToken.isText = true;
                            textToken.tokenText = textBuffer.toString();
                            ptokens.add(textToken);
                            textBuffer.setLength(0);
                        }
                        if (literalBuffer.length() > 0) {
                            literalToken = new PToken();
                            literalToken.isText = false;
                            literalToken.tokenText = literalBuffer.toString();
                            ptokens.add(literalToken);
                            literalBuffer.setLength(0);
                        }
                        commentBuffer.append(currentTokenText);
                    } else if (token.id == 13 || token.id == 14 || token.id == 15 || token.id == 16) {
                        if (textBuffer.length() > 0) {
                            textToken = new PToken();
                            textToken.isText = true;
                            textToken.tokenText = textBuffer.toString();
                            ptokens.add(textToken);
                            textBuffer.setLength(0);
                        }
                        if (commentBuffer.length() > 0) {
                            commentToken = new PToken();
                            commentToken.isText = false;
                            commentToken.tokenText = commentBuffer.toString();
                            ptokens.add(commentToken);
                            commentBuffer.setLength(0);
                        }
                        literalBuffer.append(currentTokenText);
                    } else {
                        if (commentBuffer.length() > 0) {
                            commentToken = new PToken();
                            commentToken.isText = false;
                            commentToken.tokenText = commentBuffer.toString();
                            ptokens.add(commentToken);
                            commentBuffer.setLength(0);
                        }
                        if (literalBuffer.length() > 0) {
                            literalToken = new PToken();
                            literalToken.isText = false;
                            literalToken.tokenText = literalBuffer.toString();
                            ptokens.add(literalToken);
                            literalBuffer.setLength(0);
                        }
                        textBuffer.append(currentTokenText);
                    }
                    currentTokenText = nextTokenText;
                    tokenStart += token.length;
                    token = token.next;
                    if (token.next == null) continue;
                    nextTokenText = tempBuffer.getText(tokenStart + token.length, token.next.length);
                }
                if (lineNum <= lastLine - 2 && textBuffer.length() > 0) {
                    textBuffer.append(this.getLineSeparator());
                }
                if (lineNum > lastLine - 2 || commentBuffer.length() <= 0) continue;
                commentBuffer.append(this.getLineSeparator());
            }
            if (textBuffer.length() > 0) {
                PToken textToken = new PToken();
                textToken.isText = true;
                textToken.tokenText = textBuffer.toString();
                ptokens.add(textToken);
            }
            if (commentBuffer.length() > 0) {
                PToken commentToken = new PToken();
                commentToken.isText = false;
                commentToken.tokenText = commentBuffer.toString();
                ptokens.add(commentToken);
            }
            if (literalBuffer.length() > 0) {
                PToken literalToken = new PToken();
                literalToken.isText = false;
                literalToken.tokenText = literalBuffer.toString();
                ptokens.add(literalToken);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ptokens;
    }

    String trimStart(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    String trimEnd(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setPrePadOperator(boolean prePadOperator) {
        this.prePadOperator = prePadOperator;
    }

    public void setPrePadFunction(boolean prePadFunction) {
        this.prePadFunction = prePadFunction;
    }

    public void setPrePadDigit(boolean prePadDigit) {
        this.prePadDigit = prePadDigit;
    }

    public void setPrePadKeyword1(boolean prePadKeyword1) {
        this.prePadKeyword1 = prePadKeyword1;
    }

    public void setPrePadKeyword2(boolean prePadKeyword2) {
        this.prePadKeyword2 = prePadKeyword2;
    }

    public void setPrePadKeyword3(boolean prePadKeyword3) {
        this.prePadKeyword3 = prePadKeyword3;
    }

    public void setPrePadKeyword4(boolean prePadKeyword4) {
        this.prePadKeyword4 = prePadKeyword4;
    }

    public void setPostPadOperator(boolean postPadOperator) {
        this.postPadOperator = postPadOperator;
    }

    public void setPostPadFunction(boolean postPadFunction) {
        this.postPadFunction = postPadFunction;
    }

    public void setPostPadDigit(boolean postPadDigit) {
        this.postPadDigit = postPadDigit;
    }

    public void setPostPadKeyword1(boolean postPadKeyword1) {
        this.postPadKeyword1 = postPadKeyword1;
    }

    public void setPostPadKeyword2(boolean postPadKeyword2) {
        this.postPadKeyword2 = postPadKeyword2;
    }

    public void setPostPadKeyword3(boolean postPadKeyword3) {
        this.postPadKeyword3 = postPadKeyword3;
    }

    public void setPostPadKeyword4(boolean postPadKeyword4) {
        this.postPadKeyword4 = postPadKeyword4;
    }

    public void setLabelOnSeparateLine(boolean labelOnSeparateLine) {
        this.labelOnSeparateLine = labelOnSeparateLine;
    }

    public void setPrePadCharacters(String prePadCharacters) {
        this.prePadCharacters = prePadCharacters;
    }

    public void setPostPadCharacters(String postPadCharacters) {
        this.postPadCharacters = postPadCharacters;
    }

    public void setDontPrePadCharacters(String dontPrePadCharacters) {
        this.dontPrePadCharacters = dontPrePadCharacters;
    }

    public void setDontPostPadCharacters(String dontPostPadCharacters) {
        this.dontPostPadCharacters = dontPostPadCharacters;
    }

    public void setPreInsertLineCharacters(String preInsertLineCharacters) {
        this.preInsertLineCharacters = preInsertLineCharacters;
    }

    public void setPostInsertLineCharacters(String postInsertLineCharacters) {
        this.postInsertLineCharacters = postInsertLineCharacters;
    }

    public void setCollapseBlankLines(boolean collapseBlankLines) {
        this.collapseBlankLines = collapseBlankLines;
    }

    public void setCollapseLinearWhitespaces(boolean collapseLinearWhitespace) {
        this.collapseLinearWhitespace = collapseLinearWhitespace;
    }

    public class PToken {
        boolean isText = false;
        String tokenText;
    }
}

