/*
 * Decompiled with CFR 0.152.
 */
package beauty.beautifiers;

import beauty.parsers.ParserException;

public abstract class Beautifier {
    protected String lineSeparator = System.getProperty("line.separator");
    protected String editMode = null;
    protected int tabWidth = 4;
    protected int wrapMargin = 1024;
    protected String wrapMode = "none";
    protected int initialLevel = 0;
    protected int indentWidth = 4;
    protected boolean softTabs = true;
    protected String indent = "    ";
    protected String doubleIndent = this.indent + this.indent;
    public static final String SERVICE_NAME = "beauty.beautifiers.Beautifier";

    public void init() {
    }

    public abstract String beautify(String var1) throws ParserException;

    public void setTabWidth(int w) {
        this.tabWidth = w;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setIndentWidth(int w) {
        this.indentWidth = w;
        if (this.indentWidth <= 0) {
            this.indentWidth = 4;
        }
        this.indent = "";
        for (int i = 0; i < w; ++i) {
            this.indent = this.indent + " ";
        }
        this.doubleIndent = this.indent + this.indent;
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void setUseSoftTabs(boolean b) {
        this.softTabs = b;
        if (b) {
            this.setIndentWidth(this.indentWidth);
        } else {
            this.indent = "\t";
            this.doubleIndent = "\t\t";
        }
    }

    public boolean getUseSoftTabs() {
        return this.softTabs;
    }

    public void setLineSeparator(String ls) {
        this.lineSeparator = ls;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setWrapMargin(int i) {
        this.wrapMargin = i;
    }

    public int getWrapMargin() {
        return this.wrapMargin;
    }

    public void setWrapMode(String s) {
        if (s != null && (s.equals("none") || s.equals("soft") || s.equals("hard"))) {
            this.wrapMode = s;
        }
    }

    public String getWrapMode() {
        return this.wrapMode;
    }

    public void setEditMode(String m) {
        this.editMode = m;
    }

    public String getEditMode() {
        return this.editMode;
    }

    public void setInitialIndentLevel(int level) {
        this.initialLevel = level;
    }
}

