/*
 * Decompiled with CFR 0.152.
 */
package beauty;

import beauty.BeautyPlugin;
import beauty.beautifiers.Beautifier;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class BeautyThread
implements Runnable {
    private View view = null;
    private Buffer buffer = null;
    private boolean showErrorDialogs = false;
    private Beautifier beautifier = null;

    public BeautyThread(Buffer buffer, View view, boolean showErrorDialogs, Beautifier beautifier) {
        this.buffer = buffer;
        this.view = view;
        this.showErrorDialogs = showErrorDialogs;
        this.beautifier = beautifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.beautifier == null) {
            return;
        }
        EditPane[] editPanes = null;
        int[] caretPositions = null;
        try {
            if (this.view == null) {
                this.view = jEdit.getActiveView();
            }
            if (this.view != null) {
                this.view.showWaitCursor();
                editPanes = this.view.getEditPanes();
                if (editPanes != null) {
                    caretPositions = new int[editPanes.length];
                    for (int i = 0; i < editPanes.length; ++i) {
                        caretPositions[i] = editPanes[i].getTextArea().getCaretPosition();
                    }
                }
            }
            Mode mode = this.buffer.getMode();
            String modeName = mode.getName();
            String ls = this.buffer.getStringProperty("lineSeparator");
            int tabWidth = this.buffer.getIntegerProperty("tabSize", 4);
            int indentWidth = this.buffer.getIntegerProperty("indentSize", 4);
            boolean softTabs = this.buffer.getBooleanProperty("noTabs");
            int wrapMargin = this.buffer.getIntegerProperty("maxLineLength", 1024);
            String wrapMode = this.buffer.getStringProperty("wrap");
            this.beautifier.setEditMode(modeName);
            this.beautifier.setLineSeparator(ls);
            this.beautifier.setTabWidth(tabWidth);
            this.beautifier.setIndentWidth(indentWidth);
            this.beautifier.setUseSoftTabs(softTabs);
            this.beautifier.setWrapMargin(wrapMargin);
            this.beautifier.setWrapMode(wrapMode);
            this.beautifier.init();
            String contents = this.beautifier.beautify(this.buffer.getText(0, this.buffer.getLength()));
            if (contents == null || contents.length() == 0) {
                Log.log((int)9, (Object)this, (Object)jEdit.getProperty((String)"beauty.error.empty.message"));
                if (this.showErrorDialogs) {
                    GUIUtilities.error((Component)this.view, (String)"beauty.error.empty", null);
                }
                return;
            }
            if (contents.equals(this.buffer.getText(0, this.buffer.getLength()))) {
                return;
            }
            Vector markers = (Vector)this.buffer.getMarkers().clone();
            this.buffer.removeAllMarkers();
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, contents);
            this.buffer.endCompoundEdit();
            Enumeration itr = markers.elements();
            while (itr.hasMoreElements()) {
                Marker marker = (Marker)itr.nextElement();
                this.buffer.addMarker(marker.getShortcut(), marker.getPosition());
            }
            if (editPanes != null) {
                for (int i = 0; i < editPanes.length; ++i) {
                    BeautyPlugin.restoreCaretPosition(editPanes[i], caretPositions[i]);
                }
            }
        }
        catch (Exception ex) {
            Log.log((int)9, (Object)this, (Object)ex);
            if (this.showErrorDialogs) {
                GUIUtilities.error((Component)this.view, (String)"beauty.error.other", (Object[])new Object[]{ex});
            }
        }
        finally {
            if (this.view != null) {
                this.view.hideWaitCursor();
            }
        }
    }
}

