/*
 * Decompiled with CFR 0.152.
 */
package beauty;

import beauty.BeautyThread;
import beauty.beautifiers.Beautifier;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class BeautyPlugin
extends EditPlugin {
    private static HashMap<String, File> modeFiles;

    public void start() {
        this.copyBundledProperties();
        BeautyPlugin.loadProperties();
        BeautyPlugin.registerServices();
    }

    private void copyBundledProperties() {
        String propsFiles = jEdit.getProperty((String)"plugin.beauty.beautifiers.custom");
        if (propsFiles == null || propsFiles.length() == 0) {
            return;
        }
        String[] filenames = propsFiles.split(",");
        File homeDir = jEdit.getPlugin((String)"beauty.BeautyPlugin").getPluginHome();
        homeDir.mkdirs();
        for (String filename : filenames) {
            File outfile = new File(homeDir, filename = filename.trim());
            if (outfile.exists()) continue;
            String resource = "beauty/beautifiers/custom/" + filename;
            BeautyPlugin.copyToFile(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource), outfile);
        }
    }

    public static void registerServices() {
        PluginJAR jar = jEdit.getPlugin((String)"beauty.BeautyPlugin").getPluginJAR();
        for (String modeName : modeFiles.keySet()) {
            ServiceManager.registerService((String)"beauty.beautifiers.Beautifier", (String)(modeName + ".custom"), (String)("new beauty.beautifiers.DefaultBeautifier(\"" + modeName + "\")"), (PluginJAR)jar);
        }
    }

    private static void loadProperties() {
        try {
            File homeDir = jEdit.getPlugin((String)"beauty.BeautyPlugin").getPluginHome();
            File[] files = homeDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".properties");
                }
            });
            modeFiles = new HashMap();
            for (File file : files) {
                String filename = file.getName();
                String modeName = filename.substring(0, filename.lastIndexOf(".properties"));
                modeFiles.put(modeName, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Properties getCustomModeProperties(String modeName) {
        BeautyPlugin.loadProperties();
        File modeFile = modeFiles.get(modeName);
        Properties props = BeautyPlugin.getModeIndentProperties(modeName);
        if (modeFile == null) {
            StringWriter sw = new StringWriter();
            props.list(new PrintWriter(sw));
            return props;
        }
        try {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(modeFile));
            Properties p = new Properties();
            p.load(reader);
            ((InputStream)reader).close();
            props.putAll((Map<?, ?>)p);
            StringWriter sw = new StringWriter();
            props.list(new PrintWriter(sw));
            return props;
        }
        catch (Exception e) {
            e.printStackTrace();
            return props;
        }
    }

    private static Properties getModeIndentProperties(String modeName) {
        Mode mode = jEdit.getMode((String)modeName);
        ModeProvider.instance.loadMode(mode);
        mode.loadIfNecessary();
        mode.init();
        mode.getIndentRules();
        Properties p = new Properties();
        String indentOpenBrackets = (String)mode.getProperty("indentOpenBrackets");
        String indentCloseBrackets = (String)mode.getProperty("indentCloseBrackets");
        String unalignedOpenBrackets = (String)mode.getProperty("unalignedOpenBrackets");
        String unalignedCloseBrackets = (String)mode.getProperty("unalignedCloseBrackets");
        String indentNextLine = (String)mode.getProperty("indentNextLine");
        String unindentThisLine = (String)mode.getProperty("unindentThisLine");
        String electricKeys = (String)mode.getProperty("electricKeys");
        String lineUpClosingBracket = mode.getBooleanProperty("lineUpClosingBracket") ? "true" : "false";
        String doubleBracketIndent = mode.getBooleanProperty("doubleBracketIndent") ? "true" : "false";
        p.setProperty("indentOpenBrackets", indentOpenBrackets == null ? "" : indentOpenBrackets);
        p.setProperty("indentCloseBrackets", indentCloseBrackets == null ? "" : indentCloseBrackets);
        p.setProperty("unalignedOpenBrackets", unalignedOpenBrackets == null ? "" : unalignedOpenBrackets);
        p.setProperty("unalignedCloseBrackets", unalignedCloseBrackets == null ? "" : unalignedCloseBrackets);
        p.setProperty("indentNextLine", indentNextLine == null ? "" : indentNextLine);
        p.setProperty("unindentThisLine", unindentThisLine == null ? "" : unindentThisLine);
        p.setProperty("electricKeys", electricKeys == null ? "" : electricKeys);
        p.setProperty("lineUpClosingBracket", lineUpClosingBracket);
        p.setProperty("doubleBracketIndent", doubleBracketIndent);
        return p;
    }

    public static void saveProperties(String modeName, Properties modeProperties) {
        if (modeName == null || modeProperties == null) {
            return;
        }
        try {
            File homeDir = jEdit.getPlugin((String)"beauty.BeautyPlugin").getPluginHome();
            if (!homeDir.exists()) {
                homeDir.mkdir();
            }
            File customFile = new File(homeDir, modeName + ".properties");
            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(customFile));
            modeProperties.save(writer, "Properties for " + modeName + " custom beautifier.");
            ((OutputStream)writer).flush();
            ((OutputStream)writer).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BeautyPlugin.loadProperties();
    }

    public static void beautify(Buffer buffer, View view, boolean showErrorDialogs) {
        BeautyPlugin.beautify(buffer, view);
    }

    public static void beautify(Buffer buffer, View view) {
        Beautifier beautifier;
        boolean showErrorDialogs = jEdit.getBooleanProperty((String)"beauty.general.showErrorDialogs", (boolean)true);
        if (buffer.isReadOnly()) {
            Log.log((int)5, BeautyPlugin.class, (Object)jEdit.getProperty((String)"beauty.error.isReadOnly.message"));
            if (showErrorDialogs) {
                GUIUtilities.error((Component)view, (String)"beauty.error.isReadOnly", null);
            }
            return;
        }
        String mode = buffer.getStringProperty("beauty.beautifier");
        if (mode == null) {
            mode = buffer.getMode().getName();
        }
        if ((beautifier = (Beautifier)ServiceManager.getService((String)"beauty.beautifiers.Beautifier", (String)mode)) == null) {
            if (jEdit.getBooleanProperty((String)"beauty.useBuiltInIndenter", (boolean)false)) {
                BeautyPlugin.indentLines(view);
                return;
            }
            if (showErrorDialogs) {
                JOptionPane.showMessageDialog((Component)view, "Error: can't beautify this buffer because I don't know how to handle this mode.", "Beauty Error", 0);
                return;
            }
            Log.log((int)5, BeautyPlugin.class, (Object)("buffer " + buffer.getName() + " not beautified, because mode is not supported."));
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new BeautyThread(buffer, view, showErrorDialogs, beautifier).run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new BeautyThread(buffer, view, showErrorDialogs, beautifier));
            }
            catch (Exception e) {
                if (showErrorDialogs) {
                    JOptionPane.showMessageDialog((Component)view, e.getMessage(), "Beauty Error", 0);
                    return;
                }
                Log.log((int)5, BeautyPlugin.class, (Object)("buffer " + buffer.getName() + " not beautified.\n" + e.getMessage()));
                return;
            }
        }
    }

    public static void indentLines(View view) {
        JEditTextArea ta = view.getEditPane().getTextArea();
        int cp = ta.getCaretPosition();
        Buffer buffer = view.getBuffer();
        buffer.indentLines(0, buffer.getLineCount() - 1);
        BeautyPlugin.restoreCaretPosition(view.getEditPane(), cp);
    }

    static void restoreCaretPosition(EditPane editPane, int caretPosition) {
        final EditPane ep = editPane;
        final int offset = Math.min(caretPosition, editPane.getTextArea().getBufferLength());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ep.getTextArea().setCaretPosition(offset, true);
                ep.getTextArea().scrollToCaret(true);
            }
        });
    }

    public static void toggleSplitAttributes(View view) {
        boolean split = jEdit.getBooleanProperty((String)"xmlindenter.splitAttributes", (boolean)false);
        jEdit.setBooleanProperty((String)"xmlindenter.splitAttributes", (!split ? 1 : 0) != 0);
        BeautyPlugin.beautify(view.getBuffer(), view);
    }

    public static void copyToFile(InputStream from, File to) {
        try {
            int bytes_read;
            FileOutputStream out = new FileOutputStream(to);
            byte[] buffer = new byte[1024];
            while ((bytes_read = from.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
            out.flush();
            out.close();
            from.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

