/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.zencoding.html;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Tag
implements Cloneable {
    final String name;
    final LinkedList<Object> subTags;
    final Map<String, String> attributes;
    private String lastAttribute;

    Tag() {
        this(null);
    }

    public Tag(String name) {
        this.name = name;
        this.subTags = new LinkedList();
        this.attributes = new HashMap<String, String>();
    }

    public void addSubtag(Object o) {
        this.subTags.add(o);
    }

    public void removeSubtag(Object o) {
        this.subTags.remove(o);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void addAttribute(String name, String value) {
        this.lastAttribute = name;
        this.attributes.put(name, value);
    }

    public void appendAttribute(String name, String value, boolean space) {
        this.lastAttribute = name;
        String oldValue = this.attributes.get(name);
        if (oldValue == null) {
            this.addAttribute(name, value);
        } else if (space) {
            this.attributes.put(name, oldValue + ' ' + value);
        } else {
            this.attributes.put(name, oldValue + value);
        }
    }

    public void appendAttribute(String name, String value) {
        this.appendAttribute(name, value, false);
    }

    public String getLastAttribute() {
        return this.lastAttribute;
    }

    public Tag clone() {
        Tag cloned = new Tag(this.name);
        cloned.attributes.putAll(this.attributes);
        cloned.lastAttribute = this.lastAttribute;
        cloned.subTags.addAll(this.subTags);
        return cloned;
    }

    public String toString() {
        return this.name + '>';
    }
}

