/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.zencoding.html;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import superabbrevs.zencoding.html.Tag;
import superabbrevs.zencoding.html.ZenSerializer;

public class MLSerializer
implements ZenSerializer {
    private int index;
    private final String mode;
    private final Properties props;

    public MLSerializer(String mode, Properties props) {
        this.mode = mode;
        this.props = props;
    }

    protected Map<String, String> getAttributes(Tag tag) {
        String baseProperty;
        String attribute;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String baseName = "defaultattributes.html." + tag.name + '.';
        for (int i = 0; i < 100 && (attribute = this.props.getProperty(baseProperty = baseName + i)) != null; ++i) {
            String value = this.props.getProperty(baseProperty + ".value");
            attributes.put(attribute, value);
        }
        attributes.putAll(tag.attributes);
        return attributes;
    }

    public void toString(Tag tag, int indent, StringBuilder builder, boolean skipIndent) {
        String tabs = MLSerializer.getTabs(indent);
        if (tag.name != null) {
            if (!skipIndent) {
                builder.append(tabs);
            }
            builder.append('<').append(tag.name);
            Map<String, String> attributes = this.getAttributes(tag);
            for (Map.Entry<String, String> stringStringEntry : attributes.entrySet()) {
                builder.append(' ');
                builder.append(stringStringEntry.getKey()).append("=\"");
                String string = stringStringEntry.getValue();
                if (string == null) {
                    builder.append('$').append(this.index++);
                } else {
                    builder.append(string);
                }
                builder.append('\"');
            }
            builder.append('>');
        }
        if (tag.subTags.isEmpty()) {
            builder.append('$').append(this.index++);
        } else {
            int i = 0;
            boolean prevNodeIsText = false;
            for (Object e : tag.subTags) {
                if (e instanceof Tag) {
                    Tag subTag = (Tag)e;
                    if (!(indent == -1 && i == 0 || prevNodeIsText)) {
                        builder.append('\n');
                    }
                    this.toString(subTag, indent + 1, builder, prevNodeIsText);
                    ++i;
                    prevNodeIsText = false;
                    continue;
                }
                if (!(e instanceof String)) continue;
                prevNodeIsText = true;
                builder.append(e);
            }
        }
        if (tag.name != null) {
            if (!tag.subTags.isEmpty() && tag.subTags.getLast() instanceof Tag) {
                builder.append('\n').append(tabs);
            }
            builder.append("</").append(tag.name).append('>');
        }
    }

    @Override
    public String serialize(Tag tag) {
        this.index = 1;
        StringBuilder builder = new StringBuilder();
        this.toString(tag, -1, builder, false);
        return builder.toString();
    }

    private static String getTabs(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append('\t');
        }
        return builder.toString();
    }
}

