/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.zencoding.html;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import junit.framework.TestCase;
import org.gjt.sp.util.IOUtilities;
import superabbrevs.zencoding.html.HTMLZenParser;
import superabbrevs.zencoding.html.MLSerializer;
import superabbrevs.zencoding.html.ParseException;
import superabbrevs.zencoding.html.ZenSerializer;

public class HTMLZenParserTester
extends TestCase {
    private ZenSerializer serializer;

    public void testXML() {
        Properties props = HTMLZenParserTester.getProps();
        this.serializer = new MLSerializer("xml", props);
        this.doTest("#name.b", "<div id=\"name\" class=\"b\">$1</div>");
        this.doTest(".a#b", "<div id=\"b\" class=\"a\">$1</div>");
        this.doTest("div#name", "<div id=\"name\">$1</div>");
        this.doTest("div.name", "<div class=\"name\">$1</div>");
        this.doTest("div.one.two", "<div class=\"one two\">$1</div>");
        this.doTest("div#name.one.two", "<div id=\"name\" class=\"one two\">$1</div>");
        this.doTest("head>link", "<head>\n\t<link rel=\"stylesheet\" href=\"$1\">$2</link>\n</head>");
        this.doTest("table>tr>td", "<table>\n\t<tr>\n\t\t<td>$1</td>\n\t</tr>\n</table>");
        this.doTest("ul#name>li.item", "<ul id=\"name\">\n\t<li class=\"item\">$1</li>\n</ul>");
        this.doTest("p.a+p", "<p class=\"a\">$1</p>\n<p>$2</p>");
        this.doTest("p[title]", "<p title=\"$1\">$2</p>");
        this.doTest("td[colspan=2]", "<td colspan=\"2\">$1</td>");
        this.doTest("span[title=\"Hello\" rel]", "<span title=\"Hello\" rel=\"$1\">$2</span>");
        this.doTest("p*3", "<p>$1</p>\n<p>$2</p>\n<p>$3</p>");
        this.doTest("ul#name>li.item*3", "<ul id=\"name\">\n\t<li class=\"item\">$1</li>\n\t<li class=\"item\">$2</li>\n\t<li class=\"item\">$3</li>\n</ul>");
        this.doTest("p.name-$$$$*3", "<p class=\"name-0001\">$1</p>\n<p class=\"name-0002\">$2</p>\n<p class=\"name-0003\">$3</p>");
        this.doTest("div#header.some.classes+ul>li", "<div id=\"header\" class=\"some classes\">$1</div>\n<ul>\n\t<li>$2</li>\n</ul>");
        this.doTest("div#name>p.one+p.two", "<div id=\"name\">\n\t<p class=\"one\">$1</p>\n\t<p class=\"two\">$2</p>\n</div>");
        this.doTest("select>option#item-$*3", "<select id=\"$1\" name=\"$2\">\n\t<option id=\"item-1\" value=\"$3\">$4</option>\n\t<option id=\"item-2\" value=\"$5\">$6</option>\n\t<option id=\"item-3\" value=\"$7\">$8</option>\n</select>");
        this.doTest("div#page>div.logo+ul#navigation>li*5>a", "<div id=\"page\">\n\t<div class=\"logo\">$1</div>\n\t<ul id=\"navigation\">\n\t\t<li>\n\t\t\t<a href=\"$2\">$3</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$4\">$5</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$6\">$7</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$8\">$9</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$10\">$11</a>\n\t\t</li>\n\t</ul>\n</div>");
        this.doTest("p{here}", "<p>here</p>");
        this.doTest("p>{here}", "<p>here</p>");
        this.doTest("p>{Click }+a{here}+{ to continue}", "<p>Click <a href=\"$1\">here</a> to continue</p>");
    }

    public void testHTML() throws IOException {
        Properties props = HTMLZenParserTester.getProps();
        this.serializer = new MLSerializer("html", props);
        this.doTest("#name.b", "<div id=\"name\" class=\"b\">$1</div>");
        this.doTest(".a#b", "<div id=\"b\" class=\"a\">$1</div>");
        this.doTest("div#name", "<div id=\"name\">$1</div>");
        this.doTest("div.name", "<div class=\"name\">$1</div>");
        this.doTest("div.one.two", "<div class=\"one two\">$1</div>");
        this.doTest("div#name.one.two", "<div id=\"name\" class=\"one two\">$1</div>");
        this.doTest("head>link", "<head>\n\t<link rel=\"stylesheet\" href=\"$1\">$2</link>\n</head>");
        this.doTest("table>tr>td", "<table>\n\t<tr>\n\t\t<td>$1</td>\n\t</tr>\n</table>");
        this.doTest("ul#name>li.item", "<ul id=\"name\">\n\t<li class=\"item\">$1</li>\n</ul>");
        this.doTest("p.a+p", "<p class=\"a\">$1</p>\n<p>$2</p>");
        this.doTest("p[title]", "<p title=\"$1\">$2</p>");
        this.doTest("td[colspan=2]", "<td colspan=\"2\">$1</td>");
        this.doTest("span[title=\"Hello\" rel]", "<span title=\"Hello\" rel=\"$1\">$2</span>");
        this.doTest("p*3", "<p>$1</p>\n<p>$2</p>\n<p>$3</p>");
        this.doTest("ul#name>li.item*3", "<ul id=\"name\">\n\t<li class=\"item\">$1</li>\n\t<li class=\"item\">$2</li>\n\t<li class=\"item\">$3</li>\n</ul>");
        this.doTest("p.name-$$$$*3", "<p class=\"name-0001\">$1</p>\n<p class=\"name-0002\">$2</p>\n<p class=\"name-0003\">$3</p>");
        this.doTest("div#header.some.classes+ul>li", "<div id=\"header\" class=\"some classes\">$1</div>\n<ul>\n\t<li>$2</li>\n</ul>");
        this.doTest("div#name>p.one+p.two", "<div id=\"name\">\n\t<p class=\"one\">$1</p>\n\t<p class=\"two\">$2</p>\n</div>");
        this.doTest("select>option#item-$*3", "<select id=\"$1\" name=\"$2\">\n\t<option id=\"item-1\" value=\"$3\">$4</option>\n\t<option id=\"item-2\" value=\"$5\">$6</option>\n\t<option id=\"item-3\" value=\"$7\">$8</option>\n</select>");
        this.doTest("div#page>div.logo+ul#navigation>li*5>a", "<div id=\"page\">\n\t<div class=\"logo\">$1</div>\n\t<ul id=\"navigation\">\n\t\t<li>\n\t\t\t<a href=\"$2\">$3</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$4\">$5</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$6\">$7</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$8\">$9</a>\n\t\t</li>\n\t\t<li>\n\t\t\t<a href=\"$10\">$11</a>\n\t\t</li>\n\t</ul>\n</div>");
        this.doTest("p{here}", "<p>here</p>");
        this.doTest("p>{here}", "<p>here</p>");
        this.doTest("p>{Click }+a{here}+{ to continue}", "<p>Click <a href=\"$1\">here</a> to continue</p>");
        this.doTest("img", "<img alt=\"$1\" src=\"$2\">$3</img>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProps() {
        Properties props = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader("SuperAbbrevs.props");
            props.load(reader);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(reader);
                throw throwable;
            }
            IOUtilities.closeQuietly((Reader)reader);
        }
        IOUtilities.closeQuietly((Reader)reader);
        return props;
    }

    private void doTest(String tested, String value) {
        HTMLZenParser parser = new HTMLZenParser(new StringReader(tested));
        try {
            HTMLZenParserTester.assertEquals((String)value, (String)parser.parse(this.serializer));
        }
        catch (ParseException e) {
            HTMLZenParserTester.fail((String)e.getMessage());
        }
    }
}

