/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.template;

import superabbrevs.template.SelectableField;
import superabbrevs.template.WriteOutsideTemplateException;

public class VariableField
extends SelectableField {
    private String value;

    public VariableField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int getLength() {
        return this.value.length();
    }

    public void insert(int at, String s) throws WriteOutsideTemplateException {
        int length = this.getLength();
        int offset = this.getOffset();
        if (offset > at || at > offset + length) {
            throw new WriteOutsideTemplateException("Insert \"" + s + "\" out Side template: " + at);
        }
        StringBuffer v = new StringBuffer(this.value);
        v.insert(at - offset, s);
        this.value = v.toString();
    }

    public void delete(int at, int deletionLength) throws WriteOutsideTemplateException {
        int length = this.getLength();
        int offset = this.getOffset();
        if (offset > at || at + deletionLength > offset + length) {
            throw new WriteOutsideTemplateException("Delete out Side template: " + at + " length: " + deletionLength);
        }
        StringBuffer v = new StringBuffer(this.value);
        int start = at - offset;
        int end = start + deletionLength;
        v.delete(start, end);
        this.value = v.toString();
    }
}

