/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.template;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.ParseException;
import org.gjt.sp.jedit.bsh.TargetError;
import superabbrevs.SuperAbbrevsIO;
import superabbrevs.template.Field;
import superabbrevs.template.VariableField;

public class TransformationField
implements Field {
    private VariableField field;
    private String code;
    private Interpreter interpreter;
    private String lastEvaluated;
    private String lastResult;

    public TransformationField(VariableField field, String code, Interpreter interpreter) {
        this.field = field;
        this.code = code;
        this.interpreter = interpreter;
        try {
            interpreter.source(SuperAbbrevsIO.getAbbrevsFunctionPath());
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
        }
        catch (ParseException e) {
        }
        catch (EvalError e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        String s = this.field.toString();
        try {
            if (!s.equals(this.lastEvaluated)) {
                this.interpreter.set("s", (Object)s);
                this.lastResult = (String)this.interpreter.eval(this.code);
                this.lastEvaluated = s;
            }
        }
        catch (TargetError e) {
            System.out.println("TargetError");
            System.out.println(e.getMessage());
            this.lastResult = "<target error>";
            this.lastEvaluated = "<target error>";
        }
        catch (ParseException e) {
            System.out.println("ParseException");
            System.out.println(e.getMessage());
            this.lastResult = "<pasing error>";
            this.lastEvaluated = "<pasing error>";
        }
        catch (EvalError e) {
            System.out.println("EvalError");
            System.out.println(e.getErrorLineNumber());
            System.out.println(e.getMessage());
            this.lastResult = "<eval error>";
            this.lastEvaluated = "<eval error>";
        }
        return this.lastResult;
    }

    @Override
    public int getLength() {
        String s = this.field.toString();
        if (!s.equals(this.lastEvaluated)) {
            this.toString();
        }
        return this.lastResult.length();
    }

    public String firstUp(String s) {
        StringBuffer res = new StringBuffer(s);
        if (0 < res.length()) {
            char first = res.charAt(0);
            res.setCharAt(0, Character.toUpperCase(first));
        }
        return res.toString();
    }
}

