/*
 * Decompiled with CFR 0.152.
 */
package superabbrevs.template;

import java.util.List;
import superabbrevs.template.Field;
import superabbrevs.template.SelectableField;
import superabbrevs.template.VariableField;
import superabbrevs.template.WriteOutsideTemplateException;

public class Template {
    private List template;
    private List fieldList;
    private int currentField = 0;
    private int offset = 0;
    private int length;

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.updateOffsets();
    }

    public int getLength() {
        return this.length;
    }

    public Template(List template, List fieldList) {
        this.template = template;
        this.fieldList = fieldList;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        for (Field field : this.template) {
            output.append(((Object)field).toString());
        }
        return output.toString();
    }

    private void updateOffsets() {
        int offset = this.offset;
        for (Field field : this.template) {
            if (field instanceof SelectableField) {
                SelectableField selectableField = (SelectableField)field;
                selectableField.setOffset(offset);
            }
            offset += field.getLength();
        }
        this.length = offset - this.offset;
    }

    public void insert(int at, String s) throws WriteOutsideTemplateException {
        SelectableField field = this.getCurrentField();
        if (!(field instanceof VariableField)) {
            throw new WriteOutsideTemplateException("Insert in $end field");
        }
        VariableField variableField = (VariableField)field;
        variableField.insert(at, s);
        this.updateOffsets();
    }

    public void delete(int at, int length) throws WriteOutsideTemplateException {
        SelectableField field = this.getCurrentField();
        if (!(field instanceof VariableField)) {
            throw new WriteOutsideTemplateException("Delete in $end field");
        }
        VariableField variableField = (VariableField)field;
        variableField.delete(at, length);
        this.updateOffsets();
    }

    public SelectableField getCurrentField() {
        return (SelectableField)this.fieldList.get(this.currentField);
    }

    public boolean inCurrentField(int pos) {
        SelectableField field = this.getCurrentField();
        return field.inField(pos);
    }

    public void nextField() {
        ++this.currentField;
        if (this.fieldList.size() <= this.currentField) {
            this.currentField = 0;
        }
    }

    public void prevField() {
        --this.currentField;
        if (this.currentField < 0) {
            this.currentField = this.fieldList.size() - 1;
        }
    }
}

